package cn.wjee.commons.enums;

/**
 * Http头
 *
 * @author listening
 */
public enum HttpHeaderEnum {
    /**
     * 请求类型
     */
    TRACE_ID("TraceId"),
    /**
     * 请求类型
     */
    CONTENT_TYPE("Content-Type"),
    // -------------------------------------------------- CORS Response Headers
    /**
     * The Access-Control-Allow-Origin header indicates whether a resource can
     * be shared based by returning the value of the Origin request header in
     * the response.
     */
    ACCESS_CONTROL_ALLOW_ORIGIN("Access-Control-Allow-Origin"),
    /**
     * The Access-Control-Allow-Credentials header indicates whether the
     * response to request can be exposed when the omit credentials flag is
     * unset. When part of the response to a preflight request it indicates that
     * the actual request can include user credentials.
     */
    ACCESS_CONTROL_ALLOW_CREDENTIALS("Access-Control-Allow-Credentials"),
    /**
     * The Access-Control-Expose-Headers header indicates which headers are safe
     * to expose to the API of a CORS API specification
     */
    ACCESS_CONTROL_EXPOSE_HEADERS("Access-Control-Expose-Headers"),
    /**
     * The Access-Control-Max-Age header indicates how long the results of a
     * preflight request can be cached in a preflight result cache.
     */
    ACCESS_CONTROL_MAX_AGE("Access-Control-Max-Age"),
    /**
     * The Access-Control-Allow-Methods header indicates, as part of the
     * response to a preflight request, which methods can be used during the
     * actual request.
     */
    ACCESS_CONTROL_ALLOW_METHODS("Access-Control-Allow-Methods"),
    /**
     * The Access-Control-Allow-Headers header indicates, as part of the
     * response to a preflight request, which header field names can be used
     * during the actual request.
     */
    ACCESS_CONTROL_ALLOW_HEADERS("Access-Control-Allow-Headers"),
    // -------------------------------------------------- CORS Request Headers
    /**
     * The Origin header indicates where the cross-origin request or preflight
     * request originates from.
     */
    ORIGIN("Origin"),
    /**
     * The Access-Control-Request-Method header indicates which method will be
     * used in the actual request as part of the preflight request.
     */
    ACCESS_CONTROL_REQUEST_METHOD("Access-Control-Request-Method"),
    /**
     * The Access-Control-Request-Headers header indicates which headers will be
     * used in the actual request as part of the preflight request.
     */
    ACCESS_CONTROL_REQUEST_HEADERS("Access-Control-Request-Headers"),
    /**
     * Header Validate Field For JSON Token
     */
    AUTHORIZATION("Authorization");

    private final String code;

    HttpHeaderEnum(String code) {
        this.code = code;
    }

    public String getCode() {
        return code;
    }
}
