package cn.wjee.commons.enums;

import cn.wjee.commons.lang.StringUtils;
import lombok.Getter;

import java.util.Arrays;

/**
 * Mail Smtp Enum
 *
 * @author wjee
 * @version $Id: MailHostEnum.java, v 0.1 2015年11月4日 下午1:20:22 wjee Exp $
 */
@Getter
public enum MailHostEnum {
    /**
     * smtp 163
     */
    SMTP_163("smtp.163.com"),
    /**
     * smtp 163
     */
    SMTP_126("smtp.126.com"),
    /**
     * smtp qq
     */
    SMTP_QQ("smtp.qq.com"),
    /**
     * smtp aliyun
     */
    SMTP_ALI_YUN("smtp.mxhichina.com");

    private final String code;

    MailHostEnum(String code) {
        this.code = code;
    }

    public static MailHostEnum getByCode(String code) {
        return Arrays.stream(MailHostEnum.values()).filter(item -> StringUtils.equals(code, item.code)).findFirst().orElse(null);
    }
}
