package cn.wjee.commons.enums;

import lombok.Getter;

import java.util.concurrent.TimeUnit;

/**
 * 时间区间枚举
 *
 * @author listening
 */
@Getter
public enum PeriodEnum {
    /**
     * 永久
     */
    FOREVER("forever", 0, TimeUnit.SECONDS, "永久"),
    /**
     * 分钟
     */
    MINUTE_1("minute_1", 1, TimeUnit.MINUTES, "1分钟"),
    MINUTE_2("minute_2", 2, TimeUnit.MINUTES, "2分钟"),
    MINUTE_5("minute_5", 5, TimeUnit.MINUTES, "5分钟"),
    MINUTE_15("minute_15", 15, TimeUnit.MINUTES, "15分钟"),
    MINUTE_30("minute_30", 30, TimeUnit.MINUTES, "30分钟"),
    /**
     * 小时
     */
    HOUR_1("hour_1", 1, TimeUnit.HOURS, "1小时"),
    HOUR_6("hour_6", 6, TimeUnit.HOURS, "6小时"),
    HOUR_12("hour_12", 12, TimeUnit.HOURS, "12小时"),
    /**
     * 天
     */
    DAY_1("day_1", 1, TimeUnit.DAYS, "1天"),
    DAY_7("day_7", 7, TimeUnit.DAYS, "7天"),
    DAY_15("day_15", 15, TimeUnit.DAYS, "15天"),
    /**
     * 月
     */
    MONTH_1("month_1", 30, TimeUnit.DAYS, "1月"),
    MONTH_3("month_3", 90, TimeUnit.DAYS, "3月"),
    MONTH_6("month_6", 180, TimeUnit.DAYS, "6月"),
    /**
     * 年
     */
    YEAR_1("year_1", 360, TimeUnit.DAYS, "1年"),
    ;
    /**
     * 时间
     */
    private final int expires;
    /**
     * 时间单位
     */
    private final TimeUnit timeUnit;
    /**
     * 编码
     */
    private final String code;
    /**
     * 描述
     */
    private final String desc;

    PeriodEnum(String code, int expires, TimeUnit timeUnit, String desc) {
        this.code = code;
        this.expires = expires;
        this.timeUnit = timeUnit;
        this.desc = desc;
    }

    public long getSeconds() {
        return this.timeUnit.toSeconds(this.expires);
    }
}
