package cn.wjee.commons.enums;

import cn.wjee.commons.collection.CollectionUtils;
import cn.wjee.commons.lang.StringUtils;
import lombok.Getter;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 运行环境枚举
 *
 * @author listening
 */
@Getter
public enum ProfilesEnum {
    /**
     * DEV
     */
    DEV("DEV环境", "dev"),
    /**
     * SIT
     */
    SIT("SIT环境", "sit"),
    /**
     * UAT
     */
    UAT("UAT环境", "uat"),
    /**
     * PROD
     */
    PRO("生产环境", "pro", "prod");

    private final String[] codes;
    private final String desc;

    ProfilesEnum(String desc, String... codes) {
        this.desc = desc;
        this.codes = codes;
    }

    public List<String> getCodeList() {
        return Arrays.stream(this.codes).collect(Collectors.toList());
    }

    public String getCode() {
        return Arrays.stream(this.codes).findFirst().orElse("");
    }

    // Check Profiles
    public static boolean isEnv(ProfilesEnum profile, String activeProfile) {
        if (StringUtils.isBlank(activeProfile)) {
            return false;
        }
        ProfilesEnum realProfile = ProfilesEnum.getProfile(activeProfile);
        return realProfile != null && CollectionUtils.containsAny(realProfile.getCodeList(), profile.getCodeList());
    }

    /**
     * 根据当前活动Profile检测Profile
     *
     * @param activeProfile 活动Profile
     * @return Profiles
     */
    public static ProfilesEnum getProfile(String activeProfile) {
        List<String> activeProfileList = CollectionUtils.tokenizeToList(activeProfile, ",");
        if (CollectionUtils.isEmpty(activeProfileList)) {
            return null;
        }
        return Arrays.stream(ProfilesEnum.values())
            .filter(tempObj -> CollectionUtils.containsAny(activeProfileList, tempObj.getCodeList()))
            .findFirst().orElse(null);
    }
}
