package cn.wjee.commons.enums;


import cn.wjee.commons.lang.StringUtils;

/**
 * 脱敏方法
 *
 * @author listening
 */
public enum SensitiveEnum {
    /**
     * 默认(头尾保留，中间脱敏)
     */
    DEFAULT() {
        @Override
        public String mask(String value) {
            return StringUtils.safeValue(value);
        }
    },
    /**
     * 手机号(中间4位脱敏)
     */
    MOBILE() {
        @Override
        public String mask(String value) {
            return StringUtils.safeMobile(value);
        }
    },
    /**
     * 身份证
     */
    IDENTITY_NO() {
        @Override
        public String mask(String value) {
            return StringUtils.safeIdentity(value);
        }
    },

    /**
     * 身份证
     */
    EMAIL() {
        @Override
        public String mask(String value) {
            return StringUtils.safeEmail(value);
        }
    },
    /**
     * 无
     */
    NONE() {
        @Override
        public String mask(String value) {
            return value;
        }
    };

    public abstract String mask(String value);
}
