package cn.wjee.commons.enums;

import cn.wjee.commons.lang.StringUtils;
import lombok.Getter;

/**
 * Token类型
 *
 * @author listening
 */
@Getter
public enum TokenTypeEnum {
    /**
     * 请求Token
     */
    ACCESS_TOKEN("access_token", "请求Token"),
    /**
     * 刷新Token
     */
    REFRESH_TOKEN("refresh_token", "刷新Token"),
    ;

    private final String code;
    private final String desc;

    TokenTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public boolean match(String code) {
        return StringUtils.equalsIgnoreCase(this.code, code);
    }
}
