package cn.wjee.commons.enums;

import cn.wjee.commons.lang.StringUtils;
import lombok.Getter;

import java.util.Arrays;

/**
 * 是否
 *
 * @author listening
 */
@Getter
public enum YesNoEnum {
    /**
     * 是
     */
    YES("1", "是"),
    /**
     * 否
     */
    NO("0", "是");

    private final String code;
    private final String desc;

    YesNoEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getIntCode() {
        return Integer.valueOf(getCode());
    }

    public Byte getByteCode() {
        return Byte.parseByte(getCode());
    }

    /**
     * 给定编码，是否等于此枚举项
     *
     * @param code 编码值
     * @return boolean
     */
    public boolean isMatch(String code) {
        return StringUtils.isNotBlank(code) && StringUtils.equals(code, getCode());
    }

    public boolean isMatch(Integer code) {
        return code != null && isMatch(code + "");
    }

    public boolean isMatch(Byte code) {
        return code != null && isMatch(code + "");
    }

    /**
     * 给定的编码是否在枚举中定义
     *
     * @param code 编码
     * @return boolean
     */
    public static boolean isAny(String code) {
        return getByCode(code) != null;
    }

    public static boolean isAny(Integer code) {
        return code != null && isAny(code + "");
    }

    public static boolean isAny(Byte code) {
        return code != null && isAny(code + "");
    }

    /**
     * 根据编码转枚举项
     *
     * @param code 编码
     * @return YesNoEnum
     */
    public static YesNoEnum getByCode(String code) {
        return Arrays.stream(YesNoEnum.values()).filter(item -> StringUtils.equals(code, item.code)).findFirst().orElse(null);
    }

    /**
     * 根据编码获取名称
     *
     * @param code 编码
     * @return String
     */
    public static String getNameByCode(String code) {
        YesNoEnum yesNoEnum = getByCode(code);
        return yesNoEnum != null ? yesNoEnum.getDesc() : null;
    }

    /**
     * 根据Bool值确定, true-YES/false-NO
     *
     * @param value boolean值
     * @return YesNoEnum
     */
    public static YesNoEnum getByBool(boolean value) {
        return value ? YesNoEnum.YES : YesNoEnum.NO;
    }
}
