package cn.wjee.commons.exception;

import cn.wjee.commons.enums.ApiStatusEnum;
import cn.wjee.commons.lang.StringUtils;

/**
 * 断言
 *
 * @author listening
 */
public class Asserts {
    private Asserts() {
    }

    /**
     * 是否为真
     *
     * @param expression 表达式
     * @param codeEnum   异常信息
     */
    public static void isTrue(boolean expression, ICodeEnum codeEnum) {
        isTrue(expression, codeEnum.getCode(), codeEnum.getMessage());
    }

    /**
     * 断言为真
     *
     * @param expression 真
     * @param message    描述
     */
    public static void isTrue(boolean expression, String message) {
        isTrue(expression, ApiStatusEnum.FAILURE_400.getCode(), message);
    }

    /**
     * 断言为真
     *
     * @param value   字符串
     * @param message 描述
     */
    public static void notBlank(String value, String message) {
        isTrue(StringUtils.isNotBlank(value), ApiStatusEnum.FAILURE_400.getCode(), message);
    }

    /**
     * 是否为真
     *
     * @param expression 表达式
     * @param exception  异常信息
     */
    public static void isTrue(boolean expression, BusinessException exception) {
        if (!expression) {
            throw exception;
        }
    }

    /**
     * 断言为真
     *
     * @param expression 真
     * @param code       编码
     * @param message    描述
     */
    public static void isTrue(boolean expression, Integer code, String message) {
        if (!expression) {
            throw new BusinessException(code, message);
        }
    }

    /**
     * 断言是否非空
     *
     * @param input    值
     * @param codeEnum 错误信息
     */
    public static void notNull(Object input, ICodeEnum codeEnum) {
        isTrue(input != null, codeEnum);
    }

    /**
     * 断言是否非空
     *
     * @param input   值
     * @param message 错误消息
     */
    public static void notNull(Object input, String message) {
        isTrue(input != null, ApiStatusEnum.FAILURE_400.getCode(), message);
    }
}
