package cn.wjee.commons.exception;

import cn.wjee.commons.enums.ApiStatusEnum;
import lombok.Getter;

/**
 * 版本不兼容异常
 *
 * @author lxn
 */
@Getter
public class BadVersionException extends RuntimeException {
    private static final long serialVersionUID = 1L;

    /**
     * 错误码
     */
    private final Integer errorCode = ApiStatusEnum.FAILURE_BAT_VERSION.getCode();
    /**
     * 错误描述
     */
    private final String errorDesc;

    public BadVersionException() {
        this("版本不匹配");
    }

    public BadVersionException(String msg) {
        this(msg, null);
    }

    public BadVersionException(String msg, Throwable t) {
        super(msg, t, false, t != null);
        this.errorDesc = msg;
    }
}
