package cn.wjee.commons.exception;

import cn.wjee.commons.enums.ApiStatusEnum;
import lombok.Getter;

/**
 * Common Exceptions
 *
 * @author WJee
 * @version $Id: BizException.java, v 0.1 2016年5月18日 下午10:57:43 WJee Exp $
 */
@Getter
public class BizException extends RuntimeException {
    /**
     * 错误码
     */
    private final Integer errorCode;
    /**
     * 错误描述
     */
    private final String errorDesc;

    public BizException(Integer errorCode, String errorDesc, Throwable e) {
        super(errorDesc, e, false, e != null);
        this.errorCode = errorCode;
        this.errorDesc = errorDesc;
    }

    public BizException(String message) {
        this(ApiStatusEnum.FAILURE_500.getCode(), message, null);
    }

    public BizException(Integer errorCode, String message) {
        this(errorCode, message, null);
    }

    public BizException(String errorDesc, Throwable t) {
        this(ApiStatusEnum.FAILURE_500.getCode(), errorDesc, t);
    }

    public BizException(ICodeEnum statusEnum) {
        this(statusEnum, null);
    }

    public BizException(ICodeEnum statusEnum, Throwable t) {
        this(statusEnum.getCode(), statusEnum.getMessage(), t);
    }
}
