package cn.wjee.commons.exception;

import cn.wjee.commons.enums.ApiStatusEnum;
import lombok.Getter;

/**
 * Common Exceptions
 *
 * @author WJee
 * @version $Id: BusinessException.java, v 0.1 2016年5月18日 下午10:57:43 WJee Exp $
 */
@Getter
public class BusinessException extends RuntimeException {
    /**
     *
     */
    private static final long serialVersionUID = 1L;
    /**
     * 错误码
     */
    private final Integer errorCode;
    /**
     * 错误描述
     */
    private final String errorDesc;
    /**
     * 是否可以显示到页面
     */
    private final boolean show;
    /**
     * 忽略监控
     */
    private final boolean monitor;

    public BusinessException(ICodeEnum statusEnum) {
        this(statusEnum, null);
    }

    public BusinessException(ICodeEnum statusEnum, Throwable t) {
        this(statusEnum.getCode(), statusEnum.getMessage(), t);
    }

    public BusinessException(String errorDesc, Throwable t) {
        this(ApiStatusEnum.FAILURE_500.getCode(), errorDesc, t);
    }

    public BusinessException(Integer errorCode, String message) {
        this(errorCode, message, null);
    }

    public BusinessException(Integer errorCode, String errorDesc, Throwable e) {
        this(errorCode, errorDesc, true, true, e);
    }

    public BusinessException(Integer errorCode, String errorDesc, boolean monitor, boolean show, Throwable e) {
        super(errorDesc, e, false, e != null);
        this.errorCode = errorCode;
        this.errorDesc = errorDesc;
        this.monitor = monitor;
        this.show = show;
    }

    public String getShowMsg(String defaultMsg) {
        if (show) {
            return errorDesc;
        }
        return (defaultMsg + (this.errorCode != null ? "" : ("[" + errorDesc + "]")));
    }
}
