package cn.wjee.commons.exception;

import cn.wjee.commons.lang.StringUtils;

import java.io.PrintWriter;
import java.io.StringWriter;

/**
 * Exceptions 工具类
 *
 * @author listening
 * @version $Id: Exceptions.java, v 0.1 2016年5月18日 下午10:57:43 Wjee Exp $
 */
public class ExceptionUtils {

    private ExceptionUtils() {

    }

    /**
     * 获取异常堆栈信息
     *
     * @param throwable 异常
     * @return String
     */
    public static String getStackTrace(final Throwable throwable) {
        final StringWriter sw = new StringWriter();
        final PrintWriter pw = new PrintWriter(sw, true);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    /**
     * 长度拦截
     *
     * @param throwable 异常
     * @param maxLength 最大长度
     * @return String 截取内容
     */
    public static String getStackTrace(Throwable throwable, int maxLength) {
        String traceContent = getStackTrace(throwable);
        if (StringUtils.isBlank(traceContent)) {
            return "";
        }
        if (traceContent.length() > maxLength) {
            return StringUtils.substring(traceContent, 0, maxLength);
        } else {
            return traceContent;
        }
    }
}
