package cn.wjee.commons.exception;

import java.text.MessageFormat;

/**
 * 状态描述接口
 *
 * @author listening
 */
public interface ICodeEnum {
    /**
     * 获取状态码
     *
     * @return Integer
     */
    Integer getCode();

    /**
     * 获取描述信息
     *
     * @return String
     */
    String getMessage();

    /**
     * 错误码转异常
     *
     * @return BusinessException
     */
    default BusinessException toEx() {
        return new BusinessException(this.getCode(), this.getMessage());
    }

    /**
     * 格式化提示信息
     *
     * @param params 参数
     * @return BusinessException
     */
    default BusinessException toEx(Object... params) {
        String formatMsg = MessageFormat.format(getMessage(), params);
        return new BusinessException(this.getCode(), formatMsg);
    }

    /**
     * 错误码转异常
     *
     * @param show 是否展示
     * @return BusinessException
     */
    default BusinessException toEx(boolean show) {
        return new BusinessException(this.getCode(), this.getMessage(), show, true, null);
    }

    /**
     * 是否状态码一致
     *
     * @param code 状态码
     * @return boolean
     */
    default boolean isMatch(Integer code) {
        return getCode().equals(code);
    }
}
