package cn.wjee.commons.http;


import cn.wjee.commons.collection.MapUtils;
import cn.wjee.commons.enums.ApiStatusEnum;
import cn.wjee.commons.exception.BusinessException;
import cn.wjee.commons.io.IOUtils;
import cn.wjee.commons.lang.StringUtils;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

/**
 * Request工具类
 *
 * @author listening
 */
public class Requests {
    /**
     * Http Get
     *
     * @param url 请求地址
     * @return String
     */
    public static String get(String url) {
        return get(url, new HashMap<>(0), null);
    }

    /**
     * Http Get
     *
     * @param url    请求地址
     * @param params 参数列表
     * @return String
     */
    public static String get(String url, Map<String, String> params) {
        return get(url, params, null);
    }

    /**
     * Http Get
     *
     * @param url     请求地址
     * @param params  参数
     * @param headers 请求头
     * @return String
     */
    public static String get(String url, Map<String, String> params, Map<String, String> headers) {
        String urlParams = "";
        if (MapUtils.isNotEmpty(params)) {
            urlParams = MapUtils.paramAsciiOrder(params, true, false);
        }
        String address = url;
        if (StringUtils.isNotBlank(urlParams)) {
            address = url + (StringUtils.contains(url, "?") ? "&" : "?") + urlParams;
        }
        RequestBuilder.HttpResponse response = RequestBuilder.get(address).headers(headers).execute();
        if (response == null || !ApiStatusEnum.SUCCESS.isMatch(response.getCode())) {
            throw new BusinessException(ApiStatusEnum.FAILURE_500);
        }
        return IOUtils.toString(response.getBody());
    }

    /**
     * Http download
     *
     * @param url      请求地址
     * @param savePath 保存地址
     */
    public static void download(String url, String savePath) {
        RequestBuilder.get(url).execute(resp -> IOUtils.copyStream(resp.getBody(), new File(savePath)));
    }

    /**
     * Http post
     *
     * @param url  请求地址
     * @param json 请求JSON
     * @return String
     */
    public static String post(String url, String json) {
        return post(url, json, new HashMap<>(0));
    }

    /**
     * Http post
     *
     * @param url     请求地址
     * @param json    请求JSON
     * @param headers 请求头
     * @return String
     */
    public static String post(String url, String json, Map<String, String> headers) {
        try (RequestBuilder.HttpResponse response = RequestBuilder.post(url).json(json).headers(headers).execute()) {
            if (response == null || !ApiStatusEnum.SUCCESS.isMatch(response.getCode())) {
                throw new BusinessException(ApiStatusEnum.FAILURE_500);
            }
            return IOUtils.toString(response.getBody());
        }
    }
}
