package cn.wjee.commons.io;

import cn.wjee.commons.exception.BizException;

import javax.imageio.ImageIO;
import java.awt.*;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

/**
 * 图片操作工具类
 *
 * @author wjee
 */
public class ImageUtils {

    private ImageUtils() {

    }

    /**
     * 图片绘制合并
     *
     * @param backgroundImg 背景图
     * @param frontImg      前景图
     * @param point         绘制坐标
     * @return byte[]
     * @throws IOException ex
     */
    public static byte[] combine(BufferedImage backgroundImg, BufferedImage frontImg, Point point) throws IOException {
        // 背景图尺寸
        int backgroundWidth = backgroundImg.getWidth();
        int backgroundHeight = backgroundImg.getHeight();
        // 前景图尺寸
        int frontImgWidth = frontImg.getWidth();
        int frontImgHeight = frontImg.getHeight();
        if (backgroundHeight < frontImgHeight || backgroundWidth < frontImgWidth) {
            throw new BizException("背景图尺寸不能小于前景图");
        }

        Graphics2D graphics = backgroundImg.createGraphics();
        // 绘制框
        final int padding = 4;
        int startX = point.x;
        int startY = point.y;

        // 绘制背景
        int logoBgX = startX - padding;
        int logoBgY = startY - padding;
        int logoBgWidth = frontImgWidth + 2 * padding;
        int logoBgHeight = frontImgHeight + 2 * padding;
        graphics.setBackground(Color.white);
        graphics.fillRoundRect(logoBgX, logoBgY, logoBgWidth, logoBgHeight, 8, 8);
        // 绘制背景框
        int logoShapeX = startX - padding + 1;
        int logoShapeY = startY - padding + 1;
        int logoShapeWidth = frontImgWidth + 2 * padding - 3;
        int logoShapeHeight = frontImgHeight + 2 * padding - 3;
        Shape shape = new RoundRectangle2D.Float(logoShapeX, logoShapeY, logoShapeWidth, logoShapeHeight, 6, 6);
        graphics.setStroke(new BasicStroke(0f));
        graphics.setColor(Color.GRAY);
        graphics.draw(shape);

        // 绘制子图
        graphics.drawImage(frontImg, startX, startY, frontImgWidth, frontImgHeight, null);
        graphics.dispose();

        // 利用ImageIO类提供的write方法，将bi以png图片的数据模式写入流。
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write(backgroundImg, "png", os);
        return os.toByteArray();
    }
}
