package cn.wjee.commons.io;

import cn.wjee.commons.collection.MapUtils;
import cn.wjee.commons.constants.Vars;
import cn.wjee.commons.lang.StringUtils;
import lombok.extern.slf4j.Slf4j;

import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/**
 * 文件类型
 *
 * @author listening
 */
@Slf4j
public class MimeUtils {
    private static final ConcurrentMap<String, String> MIME_MAP = new ConcurrentHashMap<>();

    private MimeUtils() {
        init();
    }

    private static void init() {
        try {
            Properties properties = new Properties();
            properties.load(MimeUtils.class.getResourceAsStream("/META-INF/mimes.properties"));

            properties.forEach((key, value) -> {
                if (key != null && value != null) {
                    String rawKey = (String) key;
                    String rawValue = (String) value;
                    if (!StringUtils.isAnyBlank(rawKey, rawValue)) {
                        MIME_MAP.put(rawKey, rawValue);
                    }
                }
            });
        } catch (Exception e) {
            log.warn("mimes load fail");
        }
    }

    public static String getMime(String fileExtension) {
        if (MapUtils.isEmpty(MIME_MAP)) {
            init();
        }
        String fileType = StringUtils.lowerCase(fileExtension);
        if (StringUtils.contains(fileType, Vars.DOT)) {
            fileType = fileType.substring(fileType.lastIndexOf(Vars.DOT) + 1);
        }
        return MIME_MAP.getOrDefault(fileType, "");
    }
}
