package cn.wjee.commons.lang;

import cn.wjee.commons.exception.BizException;

import java.math.BigInteger;

/**
 * CommonNumberUtils
 *
 * @author wjee
 * @version $Id: NumberUtils.java, v 0.1 2015年11月1日 下午11:28:26 wjee Exp $
 */
public class NumberUtils {
    private NumberUtils() {
    }

    /**
     * String转int
     *
     * @param str          值
     * @param defaultValue 默认值
     * @return int
     */
    public static int toInt(final String str, final int defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(str);
        } catch (final NumberFormatException nfe) {
            return defaultValue;
        }
    }


    /**
     * Convert Long To Int
     *
     * @param value Long
     * @return Integer
     */
    public static Integer longToInt(Long value) {
        if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
            throw new BizException("long value overflow integer area");
        }
        return toInt(String.valueOf(value), 0);
    }

    /**
     * 是否小于等于
     *
     * @param value      数
     * @param compareVal 比数
     * @return boolean
     */
    public static boolean let(Integer value, Integer compareVal) {
        if (value == null && compareVal == null) {
            return true;
        }
        if (value == null || compareVal == null) {
            return false;
        }
        return value <= compareVal;
    }

    /**
     * Is Blank Or Zero
     *
     * @param value 值
     * @return boolean
     */
    public static boolean isBlankZero(Integer value) {
        return value == null || value == 0;
    }

    public static boolean isBlankZero(Long value) {
        return value == null || value == 0L;
    }

    /**
     * 计算数字次方
     *
     * @param num 数字
     * @param e   次方值
     * @return BigInteger
     */
    public static BigInteger pow(final Long num, int e) {
        return new BigInteger(num + "").pow(e);
    }

    /**
     * 比较两个值是否相同
     *
     * @param numOne 数1
     * @param numTwo 数2
     * @return boolean
     */
    public static boolean isSame(Long numOne, Long numTwo) {
        return numOne != null && numTwo != null && numOne.longValue() == numTwo.longValue();
    }

    /**
     * 比较两个值是否相同
     *
     * @param numOne 数1
     * @param numTwo 数2
     * @return boolean
     */
    public static boolean isSame(Integer numOne, Integer numTwo) {
        return numOne != null && numTwo != null && numOne.intValue() == numTwo.intValue();
    }

    /**
     * 比对后取值
     *
     * @param value        值
     * @param compareValue 比对值
     * @param defaultValue 默认值
     * @return Integer
     */
    public static Integer getGtValue(Integer value, Integer compareValue, Integer defaultValue) {
        return value != null && value > compareValue ? value : defaultValue;
    }

    /**
     * 获取Int值，null返回默认值
     *
     * @param value    值
     * @param defaults 默认值
     * @return Integer
     */
    public static Integer getInt(Integer value, Integer defaults) {
        return value == null ? defaults : value;
    }

    /**
     * 获取Long值，null返回默认值
     *
     * @param value    值
     * @param defaults 默认值
     * @return Integer
     */
    public static Long getLong(Long value, Long defaults) {
        return value == null ? defaults : value;
    }
}
