package cn.wjee.commons.lang;

import java.util.Random;
import java.util.UUID;

/**
 * 随机数工具类
 *
 * @author wjee
 * @version $Id: RandomUtils.java, v 0.1 2015年5月5日 下午5:45:37 wjee Exp $
 */
public class RandomUtils {
    private RandomUtils() {

    }

    /**
     * 随机数产生工具
     */
    private static final Random RANDOM = new Random();

    /**
     * 产生范围内的随机数
     *
     * @param length 长度
     * @return int
     */
    public static String getRandomNum(int length) {
        return getRandom(length, false);
    }

    /**
     * 范围内随机数
     *
     * @param start 开始
     * @param end   结束
     * @return int
     */
    public static int nextInt(int start, int end) {
        return start + RANDOM.nextInt(end - start);
    }

    /**
     * 生成指定位数的随机字符串
     *
     * @param length      长度
     * @param useAlphabet 是否使用字母
     * @return String
     */
    public static String getRandom(int length, boolean useAlphabet) {
        StringBuilder buffer = new StringBuilder();
        String s = "0123456789" + (useAlphabet ? "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ" : "");
        for (int i = 0; i < length; i++) {
            buffer.append(s.charAt(RANDOM.nextInt(s.length())));
        }
        return buffer.toString();
    }

    /**
     * 生成指定位数的随机字符串
     *
     * @param length 长度
     * @return String
     */
    public static String getRandom(int length) {
        return getRandom(length, true);
    }

    /**
     * Generate UUID
     *
     * @return String
     */
    public static String getUuid() {
        return UUID.randomUUID().toString().replace("-", "");
    }
}
