package cn.wjee.commons.lang;


import cn.wjee.commons.constants.Vars;
import cn.wjee.commons.domain.Version;

/**
 * 版本号工具
 * <p>
 * 版本号规则 : 【大版本】.【小版本】.【补丁号】【- SNAPSHOT】
 *
 * @author listening
 */
public class VersionUtil {

    private VersionUtil() {
    }

    /**
     * 判断版本是否大于比对版本(1.2.0 vs 1.2.1)
     *
     * @param version     当前版本
     * @param versionLine 版本线
     * @return boolean
     */
    public static boolean isGt(String version, String versionLine) {
        try {
            return compare(version, versionLine) > 0;
        } catch (Exception e) {
            return false;
        }
    }

    /**
     * 判断版本是否大于等于比对版本(1.2.0 vs 1.2.1)
     *
     * @param version     当前版本
     * @param versionLine 版本线
     * @return boolean
     */
    public static boolean isGte(String version, String versionLine) {
        try {
            return compare(version, versionLine) >= 0;
        } catch (Exception e) {
            return false;
        }
    }

    /**
     * 判断版本是否小于比对版本(1.2.0 vs 1.2.1)
     *
     * @param version     当前版本
     * @param versionLine 版本线
     * @return boolean
     */
    public static boolean isLt(String version, String versionLine) {
        try {
            return compare(version, versionLine) < 0;
        } catch (Exception e) {
            return false;
        }
    }

    /**
     * 判断版本是否小于等于比对版本(1.2.0 vs 1.2.1)
     *
     * @param version     当前版本
     * @param versionLine 版本线
     * @return boolean
     */
    public static boolean isLte(String version, String versionLine) {
        try {
            return compare(version, versionLine) <= 0;
        } catch (Exception e) {
            return false;
        }
    }

    /**
     * 判断版本是否大于比对版本(1.2.0 vs 1.2.1)
     *
     * @param version     当前版本
     * @param versionLine 版本线
     * @return int 大于0:GT, 等于0:EQ, 小于0: LT
     */
    private static int compare(String version, String versionLine) {
        Version v = getVersion(version);
        Version line = getVersion(versionLine);
        return v.compareTo(line);
    }

    private static Version getVersion(String v) {
        String[] split = StringUtils.split(v, "\\.");
        String char1 = split.length >= 1 ? split[0] : "0";
        String char2 = split.length >= 2 ? split[1] : "0";
        String char3 = split.length >= 3 ? split[2] : "0";
        int majorVer = StringUtils.getIntValue(char1, 0);
        int minorVer = StringUtils.getIntValue(char2, 0);

        int patchLevel;
        String snapshot = "";
        if (StringUtils.contains(char3, Vars.HYPHEN)) {
            snapshot = StringUtils.substring(char3, char3.indexOf(Vars.HYPHEN));
            String patch = StringUtils.substring(char3, 0, char3.indexOf(Vars.HYPHEN));
            patchLevel = StringUtils.getIntValue(patch, 0);
        } else {
            patchLevel = StringUtils.getIntValue(char3, 0);
        }
        return new Version(majorVer, minorVer, patchLevel, snapshot);
    }
}
