package cn.wjee.commons.lock;

import java.util.concurrent.locks.Lock;

/**
 * 分布式锁
 *
 * @author wjee
 */
public interface DistributedLock {
    /**
     * 分布式加锁
     *
     * @param key            唯一标记
     * @param lockWaitMills  获得锁等待时长
     * @param lockLeaseMills 锁持有时长
     * @return boolean
     */
    Lock lock(String key, long lockWaitMills, long lockLeaseMills);

    /**
     * 释放锁
     *
     * @param lock 锁定结果
     */
    void unlock(Lock lock);


}
