package cn.wjee.commons.lock;

import lombok.Data;
import lombok.NonNull;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

/**
 * 无操作锁，只用来标记
 *
 * @author lxn
 */
@Data
public class NoneLock implements Lock {

    private String name;

    @Override
    public void lock() {
        // nothing
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    @Override
    public boolean tryLock() {
        return true;
    }

    @Override
    public boolean tryLock(long l, @NonNull TimeUnit tu) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        } else {
            return true;
        }
    }

    @Override
    public void unlock() {
        // nothing
    }

    @Override
    @NonNull
    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    public static NoneLock of(String name) {
        NoneLock noneLock = new NoneLock();
        noneLock.setName(name);
        return noneLock;
    }
}
