package cn.wjee.commons.swing;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionListener;

/**
 * 按钮
 *
 * @author listening
 */
public class JButtonBuilder {

    private final JButton button;

    private JButtonBuilder() {
        button = new JButton();
    }

    public static JButtonBuilder builder() {
        return new JButtonBuilder();
    }

    public JButtonBuilder text(String text) {
        button.setText(text);
        return this;
    }

    public JButtonBuilder size(Integer width, Integer height) {
        button.setPreferredSize(new Dimension(width, height));
        return this;
    }

    public JButtonBuilder actionListener(ActionListener listener) {
        button.addActionListener(listener);
        return this;
    }

    public JButtonBuilder icon(Icon icon) {
        button.setIcon(icon);
        return this;
    }

    public JButton build() {
        return button;
    }

}
