package cn.wjee.commons.swing;

import javax.swing.*;
import java.awt.event.ActionListener;

/**
 * 菜单
 *
 * @author listening
 */
public class JMenuBuilder {
    private final JMenu jMenu;

    private JMenuBuilder() {
        jMenu = new JMenu();
    }

    public static JMenuBuilder builder() {
        return new JMenuBuilder();
    }

    public JMenuBuilder setMenuText(String text) {
        jMenu.setText(text);
        return this;
    }

    public JMenuBuilder addSubMenu(JMenu menu) {
        jMenu.add(menu);
        return this;
    }

    public JMenuBuilder addMenuItem(String text, ActionListener actionListener) {
        return addMenuItem(text, null, actionListener);
    }

    public JMenuBuilder addMenuItem(String text, Icon icon, ActionListener actionListener) {
        JMenuItem item = new JMenuItem(text);
        if (icon != null) {
            item.setIcon(icon);
        }
        item.addActionListener(actionListener);
        jMenu.add(item);
        return this;
    }

    public JMenu build() {
        return jMenu;
    }
}
