/*
 * Decompiled with CFR 0.152.
 */
package cn.workde.core.boot.handler;

import cn.hutool.core.exceptions.ValidateException;
import cn.hutool.core.lang.Console;
import cn.hutool.core.util.StrUtil;
import cn.workde.core.base.exception.AuthorizeException;
import cn.workde.core.base.exception.BusinessException;
import cn.workde.core.base.exception.ForbiddenException;
import cn.workde.core.base.exception.LoginException;
import cn.workde.core.base.exception.ResultException;
import cn.workde.core.base.result.Result;
import cn.workde.core.base.utils.ExceptionUtils;
import cn.workde.core.base.utils.WebUtils;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={Exception.class})
    public Result<?> exceptionHandler(Exception e) {
        e.printStackTrace();
        return Result.error((Object)e.toString());
    }

    @ExceptionHandler(value={BusinessException.class})
    public Result<?> businessExceptionHandler(BusinessException e) {
        e.printStackTrace();
        return Result.fail((String)e.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={ResultException.class})
    public synchronized Result<?> resultExceptionHandler(ResultException e) {
        Result result = e.getResult();
        log.error(result.toString());
        ExceptionUtils.printException((Exception)e);
        return result;
    }

    @ResponseBody
    @ExceptionHandler(value={BindException.class})
    public Result<?> bindExceptionHandler(BindException e) {
        String uri = WebUtils.getRequest().getRequestURI();
        Console.error((String)"uri={}", (Object[])new Object[]{uri});
        List errors = e.getAllErrors();
        JSONObject paramHint = new JSONObject();
        errors.forEach(error -> {
            String str = StrUtil.subAfter((CharSequence)error.getArguments()[0].toString(), (CharSequence)"[", (boolean)true);
            String key = str.substring(0, str.length() - 1);
            String msg = error.getDefaultMessage();
            paramHint.put(key, (Object)msg);
            Console.error((Object)(key + " " + msg));
        });
        return Result.param_check_not_pass((String)paramHint.toString());
    }

    @ResponseBody
    @ExceptionHandler(value={ValidateException.class})
    public Result<?> validateExceptionHandler(ValidateException e) {
        ExceptionUtils.printException((Exception)e);
        return Result.param_check_not_pass((String)e.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={ForbiddenException.class})
    public Result<?> forbiddenExceptionHandler(ForbiddenException e) {
        ExceptionUtils.printException((Exception)e);
        return Result.forbidden();
    }

    @ResponseBody
    @ExceptionHandler(value={LoginException.class})
    public Result<?> loginExceptionHandler(LoginException e) {
        ExceptionUtils.printException((Exception)e);
        return Result.unauthorized();
    }

    @ExceptionHandler(value={AuthorizeException.class})
    public Result<?> authorizeExceptionHandler(AuthorizeException e) {
        ExceptionUtils.printException((Exception)e);
        return Result.forbidden();
    }
}

