/*
 * Decompiled with CFR 0.152.
 */
package cn.workde.core.boot.launch;

import cn.hutool.core.util.StrUtil;
import cn.workde.core.boot.service.LauncherService;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.SimpleCommandLinePropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.env.SystemEnvironmentPropertySource;
import org.springframework.util.Assert;

public class WorkdeApplication {
    public static ConfigurableApplicationContext run(String appName, Class source, String ... args) {
        SpringApplicationBuilder builder = WorkdeApplication.createSpringApplicationBuilder(appName, source, args);
        return builder.run(args);
    }

    public static SpringApplicationBuilder createSpringApplicationBuilder(String appName, Class source, String ... args) {
        Assert.hasText((String)appName, (String)"[appName]\u670d\u52a1\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        StandardEnvironment environment = new StandardEnvironment();
        MutablePropertySources propertySources = environment.getPropertySources();
        propertySources.addFirst((PropertySource)new SimpleCommandLinePropertySource(args));
        propertySources.addLast((PropertySource)new MapPropertySource("systemProperties", environment.getSystemProperties()));
        propertySources.addLast((PropertySource)new SystemEnvironmentPropertySource("systemEnvironment", environment.getSystemEnvironment()));
        SpringApplicationBuilder builder = new SpringApplicationBuilder(new Class[]{source});
        String profile = WorkdeApplication.isLocalDev() ? "dev" : "prod";
        String startJarPath = WorkdeApplication.class.getResource("/").getPath().split("!")[0];
        System.out.println(String.format("----\u542f\u52a8\u4e2d\uff0c\u8bfb\u53d6\u5230\u7684\u73af\u5883\u53d8\u91cf:[%s]\uff0cjar\u5730\u5740:[%s]----", profile, startJarPath));
        Properties props = System.getProperties();
        props.setProperty("spring.application.name", appName);
        props.setProperty("spring.profiles.active", profile);
        props.setProperty("info.desc", appName);
        props.setProperty("info.version", "1.0.0");
        props.setProperty("workde.env", profile);
        props.setProperty("workde.name", appName);
        props.setProperty("workde.is-local", String.valueOf(WorkdeApplication.isLocalDev()));
        props.setProperty("workde.dev-mode", profile.equals("prod") ? "false" : "true");
        props.setProperty("spring.main.allow-bean-definition-overriding", "true");
        ArrayList launcherList = new ArrayList();
        ServiceLoader.load(LauncherService.class).forEach(launcherList::add);
        launcherList.stream().sorted(Comparator.comparing(LauncherService::getOrder)).collect(Collectors.toList()).forEach(launcherService -> launcherService.launcher(builder, appName, profile, WorkdeApplication.isLocalDev()));
        return builder;
    }

    public static boolean isLocalDev() {
        String osName = System.getProperty("os.name");
        return StrUtil.isNotEmpty((CharSequence)osName) && !"LINUX".equals(osName.toUpperCase());
    }
}

