/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.base.http;

import cn.xfyun.base.Client;
import cn.xfyun.base.http.HttpBuilder;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public abstract class HttpClient
extends Client {
    protected static final MediaType JSON = MediaType.get((String)"application/json; charset=utf-8");
    protected static final MediaType FORM = MediaType.get((String)"application/x-www-form-urlencoded; charset=utf-8");
    protected static final MediaType BINARY = MediaType.get((String)"binary/octet-stream");
    protected Request request;
    protected OkHttpClient okHttpClient;

    public Request getRequest() {
        return this.request;
    }

    public OkHttpClient getOkHttpClient() {
        return this.okHttpClient;
    }

    protected String sendPost(String url, MediaType mediaType, Map<String, String> header, String body) throws IOException {
        return this.sendPost(url, header, RequestBody.create((MediaType)mediaType, (String)body));
    }

    protected String sendPost(String url, MediaType mediaType, String body) throws IOException {
        return this.sendPost(url, null, RequestBody.create((MediaType)mediaType, (String)body));
    }

    protected String sendPost(String url, MediaType mediaType, Map<String, String> header, byte[] body) throws IOException {
        return this.sendPost(url, header, RequestBody.create((MediaType)mediaType, (byte[])body));
    }

    protected String sendPost(String url, Map<String, String> header, Map<String, String> body) throws IOException {
        FormBody.Builder formBuilder = new FormBody.Builder();
        if (Objects.nonNull(body)) {
            for (Map.Entry<String, String> entry : body.entrySet()) {
                formBuilder.add(entry.getKey(), entry.getValue());
            }
        }
        return this.sendPost(url, header, (RequestBody)formBuilder.build());
    }

    private String sendPost(String url, Map<String, String> header, RequestBody requestBody) throws IOException {
        Request.Builder builder = new Request.Builder().url(url).post(requestBody);
        if (Objects.nonNull(header)) {
            for (Map.Entry<String, String> entry : header.entrySet()) {
                builder.addHeader(entry.getKey(), entry.getValue());
            }
        }
        this.request = builder.build();
        try (Response response = this.okHttpClient.newCall(this.request).execute();){
            String string = response.body().string();
            return string;
        }
    }

    public HttpClient(HttpBuilder builder) {
        this.hostUrl = builder.getHostUrl();
        this.appId = builder.getAppId();
        this.apiKey = builder.getApiKey();
        this.apiSecret = builder.getApiSecret();
        this.okHttpClient = new OkHttpClient.Builder().callTimeout((long)builder.getCallTimeout(), TimeUnit.SECONDS).connectTimeout((long)builder.getConnectTimeout(), TimeUnit.SECONDS).readTimeout((long)builder.getReadTimeout(), TimeUnit.SECONDS).writeTimeout((long)builder.getWriteTimeout(), TimeUnit.SECONDS).retryOnConnectionFailure(builder.getRetryOnConnectionFailure()).build();
    }

    public boolean getRetryOnConnectionFailure() {
        return this.okHttpClient.retryOnConnectionFailure();
    }

    public int getCallTimeout() {
        return this.okHttpClient.callTimeoutMillis() / 1000;
    }

    public int getConnectTimeout() {
        return this.okHttpClient.connectTimeoutMillis() / 1000;
    }

    public int getReadTimeout() {
        return this.okHttpClient.readTimeoutMillis() / 1000;
    }

    public int getWriteTimeout() {
        return this.okHttpClient.writeTimeoutMillis() / 1000;
    }
}

