/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.base.webscoket;

import cn.xfyun.base.Client;
import cn.xfyun.model.sign.AbstractSignature;
import cn.xfyun.model.sign.Hmac256Signature;
import cn.xfyun.util.AuthUtil;
import java.net.MalformedURLException;
import java.security.SignatureException;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;

public abstract class WebSocketClient
extends Client {
    protected String originHostUrl;
    protected AbstractSignature signature;
    protected Request request;
    protected OkHttpClient okHttpClient;
    protected WebSocket webSocket;
    protected boolean retryOnConnectionFailure;
    protected int callTimeout;
    protected int connectTimeout;
    protected int readTimeout;
    protected int writeTimeout;
    protected int pingInterval;

    public WebSocket getWebSocket() {
        return this.webSocket;
    }

    protected void createWebSocketConnect(WebSocketListener webSocketListener) throws MalformedURLException, SignatureException {
        this.signature = new Hmac256Signature(this.apiKey, this.apiSecret, this.originHostUrl);
        String url = AuthUtil.generateRequestUrl(this.signature);
        this.hostUrl = url.replace("http://", "ws://").replace("https://", "wss://");
        this.request = new Request.Builder().url(this.hostUrl).build();
        this.newWebSocket(webSocketListener);
    }

    protected void newWebSocket(WebSocketListener listener) {
        this.webSocket = this.okHttpClient.newWebSocket(this.request, listener);
    }

    public void closeWebsocket() {
        this.webSocket.close(1000, null);
        this.okHttpClient.connectionPool().evictAll();
    }
}

