/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.core;

import com.xphsc.elasticsearch.core.ElasticsearchOperations;
import com.xphsc.elasticsearch.core.client.RestHighLevelClientBulider;
import com.xphsc.elasticsearch.core.entity.Sort;
import com.xphsc.elasticsearch.core.entity.cluster.ClusterHealth;
import com.xphsc.elasticsearch.core.entity.cluster.ClusterStatsNodesInfo;
import com.xphsc.elasticsearch.core.executor.AliasExecutor;
import com.xphsc.elasticsearch.core.executor.ClusterNodesExecutor;
import com.xphsc.elasticsearch.core.executor.CountExecutor;
import com.xphsc.elasticsearch.core.executor.CreateDocumentExecutor;
import com.xphsc.elasticsearch.core.executor.CreateEntityExecutor;
import com.xphsc.elasticsearch.core.executor.CreateExecutor;
import com.xphsc.elasticsearch.core.executor.DeleteDocmentExecutor;
import com.xphsc.elasticsearch.core.executor.DeleteEntityExecutor;
import com.xphsc.elasticsearch.core.executor.DeleteExecutor;
import com.xphsc.elasticsearch.core.executor.ExistExecutor;
import com.xphsc.elasticsearch.core.executor.GetEntityExecutor;
import com.xphsc.elasticsearch.core.executor.IndexExecutor;
import com.xphsc.elasticsearch.core.executor.PutExecutor;
import com.xphsc.elasticsearch.core.executor.RefreshExecutor;
import com.xphsc.elasticsearch.core.executor.SelectEntityExecutor;
import com.xphsc.elasticsearch.core.executor.SelectExecutor;
import com.xphsc.elasticsearch.core.executor.SettingsExecutor;
import com.xphsc.elasticsearch.core.executor.UpdateEntityExecutor;
import com.xphsc.elasticsearch.core.executor.UpdateExecutor;
import com.xphsc.elasticsearch.core.query.CriteriaWrapper;
import com.xphsc.elasticsearch.core.query.DeleteQuery;
import com.xphsc.elasticsearch.core.query.DocumentQuery;
import com.xphsc.elasticsearch.core.query.IndexSettings;
import com.xphsc.elasticsearch.core.query.QueryCriteria;
import com.xphsc.elasticsearch.core.query.SearchQuery;
import com.xphsc.elasticsearch.core.query.UpdateQuery;
import com.xphsc.elasticsearch.core.query.UpdateResponseMapper;
import com.xphsc.elasticsearch.core.support.ElasticsearchAccessor;
import com.xphsc.elasticsearch.page.Page;
import com.xphsc.elasticsearch.util.Asserts;
import com.xphsc.elasticsearch.util.Collects;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ElasticsearchTemplate
extends ElasticsearchAccessor
implements ElasticsearchOperations {
    @Override
    public RestHighLevelClientBulider getClient() {
        return this.initClient();
    }

    @Override
    public boolean createIndex(String indexName) {
        Asserts.notNull((Object)indexName, () -> "No index defined for createIndex()");
        CreateExecutor executor = new CreateExecutor(this::getClient, indexName);
        boolean result = (Boolean)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> boolean createIndex(Class<T> clazz) {
        CreateExecutor executor = new CreateExecutor(this::getClient, clazz);
        boolean result = (Boolean)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> boolean deleteIndex(String ... indexNames) {
        Asserts.notNull((Object)indexNames, () -> "No index defined for deleteIndex()");
        DeleteExecutor executor = new DeleteExecutor(this::getClient, indexNames);
        boolean result = (Boolean)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> boolean deleteIndex(Class<T> clazz) {
        DeleteExecutor executor = new DeleteExecutor(this::getClient, clazz);
        boolean result = (Boolean)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> boolean putMapping(Class<T> clazz) {
        PutExecutor executor = new PutExecutor(this::getClient, clazz);
        boolean result = (Boolean)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> boolean putMapping(String indexName, String type, Object mapping) {
        Asserts.notNull((Object)indexName, () -> "No index defined for putMapping()");
        Asserts.notNull((Object)type, () -> "No type defined for putMapping()");
        PutExecutor executor = new PutExecutor(this::getClient, indexName, type, mapping);
        boolean result = (Boolean)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> boolean putMapping(String indexName, Object mapping) {
        Asserts.notNull((Object)indexName, () -> "No index defined for putMapping()");
        PutExecutor executor = new PutExecutor(this::getClient, indexName, mapping);
        boolean result = (Boolean)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> T save(T entity) {
        Asserts.notNull(entity, "Cannot save 'null' entity.");
        CreateEntityExecutor<T> executor = new CreateEntityExecutor<T>(this::getClient, entity);
        Object result = executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> int save(List<T> entities) {
        Asserts.notEmpty(entities, () -> "Cannot save 'null' entity.");
        CreateEntityExecutor<T> executor = new CreateEntityExecutor<T>(this::getClient, entities);
        int result = (Integer)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> T get(T entity) {
        Asserts.notNull(entity, () -> "Cannot get 'null' entity.");
        GetEntityExecutor<T> executor = new GetEntityExecutor<T>(this::getClient, entity);
        Object result = executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> Optional<T> getOne(T entity) {
        Asserts.notNull(entity, () -> "Cannot get 'null' entity.");
        GetEntityExecutor<T> executor = new GetEntityExecutor<T>(this::getClient, entity);
        Object result = executor.execute();
        executor = null;
        return Optional.ofNullable(result);
    }

    @Override
    public <T> T get(Serializable id, Class<T> clazz) {
        Asserts.notNull((Object)id, () -> "Cannot get 'null' id.");
        GetEntityExecutor executor = new GetEntityExecutor(this::getClient, clazz, id);
        Object result = executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> int delete(T entity) {
        Asserts.notNull(entity, () -> "Cannot delete 'null' entity.");
        DeleteEntityExecutor<T> executor = new DeleteEntityExecutor<T>(this::getClient, entity);
        int result = (Integer)executor.execute();
        executor = null;
        this.refresh(entity.getClass());
        return result;
    }

    @Override
    public <T> int delete(Class<T> entity, Serializable id) {
        Asserts.notNull((Object)id, () -> "Cannot delete 'null' id.");
        DeleteEntityExecutor executor = new DeleteEntityExecutor(this::getClient, entity, id);
        int result = (Integer)executor.execute();
        executor = null;
        this.refresh(entity);
        return result;
    }

    @Override
    public int delete(String indexName, String type, Serializable id) {
        Asserts.notNull((Object)indexName, () -> "Cannot delete 'null' indexName.");
        Asserts.notNull((Object)id, () -> "Cannot delete 'null' id.");
        DeleteEntityExecutor executor = new DeleteEntityExecutor(this::getClient, indexName, type, id);
        int result = (Integer)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public int delete(String indexName, Serializable id) {
        Asserts.notNull((Object)indexName, () -> "Cannot delete 'null' indexName.");
        Asserts.notNull((Object)id, () -> "Cannot delete 'null' id.");
        DeleteEntityExecutor executor = new DeleteEntityExecutor(this::getClient, indexName, id);
        int result = (Integer)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public int delete(DeleteQuery deleteQuery) {
        Asserts.notNull((Object)deleteQuery.getIndex(), () -> "Cannot delete 'null' indexName.");
        Asserts.notNull((Object)deleteQuery.getId(), () -> "Cannot delete 'null' id.");
        DeleteDocmentExecutor executor = new DeleteDocmentExecutor(this::getClient, deleteQuery);
        int result = (Integer)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> int deleteByIds(Class<T> entity, Iterable<?> ids) {
        Asserts.notNull(ids, () -> "Cannot deleteByIds 'null' ids.");
        DeleteEntityExecutor<T> executor = new DeleteEntityExecutor<T>(this::getClient, entity, ids);
        int result = (Integer)executor.execute();
        executor = null;
        this.refresh(entity);
        return result;
    }

    @Override
    public <T> boolean exists(Class<T> clazz, Serializable id) {
        Asserts.notNull((Object)id, () -> "Cannot exists 'null' id.");
        return this.get(id, clazz) != null;
    }

    @Override
    public <T> T update(T entity) {
        Asserts.notNull(entity, () -> "Cannot update 'null' entity.");
        UpdateEntityExecutor<T> executor = new UpdateEntityExecutor<T>(this::getClient, entity);
        Object result = executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> int update(List<? extends T> entities) {
        Asserts.notEmpty(entities, () -> "Cannot update 'null' entities.");
        UpdateEntityExecutor<T> executor = new UpdateEntityExecutor<T>(this::getClient, entities, true);
        int result = (Integer)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> T update(Serializable id, T entity) {
        Asserts.notNull((Object)id, () -> "No _id defined for update()");
        UpdateEntityExecutor<T> executor = new UpdateEntityExecutor<T>(this::getClient, entity, id);
        Object result = executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> UpdateResponseMapper update(UpdateQuery query) {
        UpdateExecutor executor = new UpdateExecutor(this::getClient, query);
        UpdateResponseMapper result = (UpdateResponseMapper)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public int bulkUpdate(List<UpdateQuery> queries) {
        UpdateExecutor executor = new UpdateExecutor(this::getClient, queries);
        int result = (Integer)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public boolean createIndexSettings(IndexSettings settings) {
        Asserts.notNull((Object)settings.getIndexName(), () -> "No index defined for createIndexSettings ");
        boolean result = false;
        if (!this.indexExist(settings.getIndexName())) {
            CreateExecutor executor = new CreateExecutor(this::getClient, settings.getIndexName(), settings);
            result = (Boolean)executor.execute();
            Object var3_3 = null;
        }
        return result;
    }

    @Override
    public boolean createSettings(String indexName, Object settings) {
        Asserts.notNull((Object)indexName, () -> "No index defined for createSettings ");
        SettingsExecutor executor = new SettingsExecutor(this::getClient, indexName, settings);
        boolean result = (Boolean)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public void refresh(String indexName) {
        Asserts.notNull((Object)indexName, () -> "No index defined for refresh()");
        RefreshExecutor executor = new RefreshExecutor(this::getClient, indexName);
        executor.execute();
    }

    @Override
    public <T> boolean refresh(Class<T> clazz) {
        RefreshExecutor executor = new RefreshExecutor(this::getClient, clazz);
        boolean result = (Boolean)executor.execute();
        return result;
    }

    @Override
    public <T> boolean indexExist(String indexName) {
        Asserts.notNull((Object)indexName, () -> "No index defined for indexExist()");
        ExistExecutor executor = new ExistExecutor(this::getClient, indexName);
        boolean result = (Boolean)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> boolean indexExist(Class<T> clazz) {
        ExistExecutor executor = new ExistExecutor(this::getClient, clazz);
        boolean result = (Boolean)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> String document(DocumentQuery query) {
        CreateDocumentExecutor executor = new CreateDocumentExecutor(this::getClient, query);
        String result = (String)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> int bulkDocument(List<DocumentQuery> queries) {
        CreateDocumentExecutor executor = new CreateDocumentExecutor(this::getClient, queries);
        int result = (Integer)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> Boolean addAlias(String indexName, String alias) {
        Asserts.notNull((Object)indexName, () -> "Cannot addAlias 'null' indexName.");
        Asserts.notNull((Object)alias, "Cannot addAlias 'null' alias.");
        AliasExecutor executor = new AliasExecutor(this::getClient, indexName, alias, AliasExecutor.AliasType.ADD);
        boolean result = (Boolean)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> Boolean deleteAlias(String indexName, String alias) {
        Asserts.notNull((Object)indexName, () -> "Cannot deleteAlias 'null' indexName.");
        Asserts.notNull((Object)alias, "Cannot deleteAlias 'null' alias.");
        AliasExecutor executor = new AliasExecutor(this::getClient, indexName, alias, AliasExecutor.AliasType.REMOVE);
        boolean result = (Boolean)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> boolean existsAlias(String indices, String alias) {
        Asserts.notNull((Object)indices, "Cannot existsAlias 'null' indices.");
        Asserts.notNull((Object)alias, "Cannot existsAlias 'null' alias.");
        AliasExecutor executor = new AliasExecutor(this::getClient, indices, alias);
        boolean result = (Boolean)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> List<T> findByIds(Class<T> clazz, List<?> ids) {
        Asserts.notNull(ids, "Cannot findByIds 'null' ids.");
        SelectEntityExecutor executor = new SelectEntityExecutor(this::getClient, clazz, ids);
        List result = (List)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> List<T> findAll(Class<T> clazz) {
        SelectEntityExecutor executor = new SelectEntityExecutor(this::getClient, clazz);
        List result = (List)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> List<T> findAll(Class<T> clazz, Sort sort) {
        SelectEntityExecutor executor = new SelectEntityExecutor(this::getClient, clazz, sort);
        List result = (List)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> Page<T> findByPage(Class<T> clazz, Page page) {
        Asserts.notNull((Object)page, "Page must not be empty");
        SelectEntityExecutor executor = new SelectEntityExecutor(this::getClient, clazz, page);
        Page result = (Page)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> Page<T> findByPage(Class<T> clazz, Page page, Sort sort) {
        Asserts.notNull((Object)page, "Page must not be empty");
        SelectEntityExecutor executor = new SelectEntityExecutor(this::getClient, clazz, page, sort);
        Page result = (Page)executor.execute();
        executor = null;
        return result;
    }

    @Override
    @Deprecated
    public <T> T get(QueryCriteria queryCriteria, Class<?> clazz) {
        Object get;
        Object v0 = get = Collects.isNotEmpty(this.find(queryCriteria, clazz)) ? this.find(queryCriteria, clazz).get(0) : null;
        Object result = queryCriteria.queryProperty.getPage() == null ? get : (this.findByPage(queryCriteria, clazz) != null ? this.findByPage(queryCriteria, clazz).getList().get(0) : null);
        return result;
    }

    @Override
    public <T> T get(CriteriaWrapper criteriaWrapper, Class<?> clazz) {
        Object get;
        Object v0 = get = Collects.isNotEmpty(this.find(criteriaWrapper, clazz)) ? this.find(criteriaWrapper, clazz).get(0) : null;
        Object result = criteriaWrapper.queryProperty.getPage() == null ? get : (this.findByPage(criteriaWrapper, clazz) != null ? this.findByPage(criteriaWrapper, clazz).getList().get(0) : null);
        return result;
    }

    @Override
    @Deprecated
    public <T> List<T> find(QueryCriteria queryCriteria, Class<?> clazz) {
        Asserts.notNull((Object)queryCriteria, "queryCriteria must not be empty");
        Asserts.isNull((Object)queryCriteria.queryProperty.getPage(), "Page must  be empty");
        SelectEntityExecutor executor = new SelectEntityExecutor(this::getClient, queryCriteria, clazz);
        List result = (List)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> List<T> find(CriteriaWrapper criteriaWrapper, Class<?> clazz) {
        Asserts.notNull((Object)criteriaWrapper, "queryCriteria must not be empty");
        Asserts.isNull((Object)criteriaWrapper.queryProperty.getPage(), "Page must  be empty");
        SelectEntityExecutor executor = new SelectEntityExecutor(this::getClient, criteriaWrapper, clazz);
        List result = (List)executor.execute();
        executor = null;
        return result;
    }

    @Override
    @Deprecated
    public <T> List<Map<String, Object>> find(QueryCriteria queryCriteria) {
        Asserts.notNull((Object)queryCriteria, "queryCriteria must not be empty");
        Asserts.notNull((Object)queryCriteria.queryProperty.getSearchIndexRequest(), "queryCriteria indices  must not be empty");
        Asserts.isNull((Object)queryCriteria.queryProperty.getPage(), "Page must  be empty");
        SelectEntityExecutor executor = new SelectEntityExecutor(this::getClient, queryCriteria);
        List result = (List)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> List<Map<String, Object>> find(CriteriaWrapper criteriaWrapper) {
        Asserts.notNull((Object)criteriaWrapper, "criteriaWrapper must not be empty");
        Asserts.notNull((Object)criteriaWrapper.queryProperty.getSearchIndexRequest(), "criteriaWrapper indices  must not be empty");
        Asserts.isNull((Object)criteriaWrapper.queryProperty.getPage(), "Page must  be empty");
        SelectEntityExecutor executor = new SelectEntityExecutor(this::getClient, criteriaWrapper);
        List result = (List)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> List<Map<String, Object>> queryForList(SearchQuery searchQuery) {
        Asserts.notNull((Object)searchQuery, "searchQuery must not be empty");
        Asserts.notNull((Object)searchQuery.getIndices(), "searchQuery indices  must not be empty");
        Asserts.isNull((Object)searchQuery.getPage(), "Page must  be empty");
        SelectExecutor executor = new SelectExecutor(this::getClient, searchQuery);
        List result = (List)executor.execute();
        executor = null;
        return result;
    }

    @Override
    @Deprecated
    public <T> Page<T> findByPage(QueryCriteria queryCriteria, Class<?> clazz) {
        Asserts.notNull((Object)queryCriteria.queryProperty.getPage(), "Page must not be empty");
        SelectEntityExecutor executor = new SelectEntityExecutor(this::getClient, queryCriteria, clazz);
        Page result = (Page)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> Page<T> findByPage(CriteriaWrapper criteriaWrapper, Class<?> clazz) {
        Asserts.notNull((Object)criteriaWrapper.queryProperty.getPage(), "Page must not be empty");
        SelectEntityExecutor executor = new SelectEntityExecutor(this::getClient, criteriaWrapper, clazz);
        Page result = (Page)executor.execute();
        executor = null;
        return result;
    }

    @Override
    @Deprecated
    public <T> Page<Map<String, Object>> findByPage(QueryCriteria queryCriteria) {
        Asserts.notNull((Object)queryCriteria, "queryCriteria must not be empty");
        Asserts.notNull((Object)queryCriteria.queryProperty.getSearchIndexRequest(), "queryCriteria indices  must not be empty");
        Asserts.notNull((Object)queryCriteria.queryProperty.getPage(), "Page must not be empty");
        SelectEntityExecutor executor = new SelectEntityExecutor(this::getClient, queryCriteria);
        Page result = (Page)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> Page<Map<String, Object>> findByPage(CriteriaWrapper criteriaWrapper) {
        Asserts.notNull((Object)criteriaWrapper, "criteriaWrapper must not be empty");
        Asserts.notNull((Object)criteriaWrapper.queryProperty.getSearchIndexRequest(), "queryCriteria indices  must not be empty");
        Asserts.notNull((Object)criteriaWrapper.queryProperty.getPage(), "Page must not be empty");
        SelectEntityExecutor executor = new SelectEntityExecutor(this::getClient, criteriaWrapper);
        Page result = (Page)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> Page<Map<String, Object>> queryForPage(SearchQuery searchQuery) {
        Asserts.notNull((Object)searchQuery, "searchQuery must not be empty");
        Asserts.notNull((Object)searchQuery.getIndices(), "searchQuery indices  must not be empty");
        Asserts.notNull((Object)searchQuery.getPage(), "Page must not be empty");
        SelectExecutor executor = new SelectExecutor(this::getClient, searchQuery);
        Page result = (Page)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> long count(Class<T> clazz) {
        CountExecutor executor = new CountExecutor(this::getClient, clazz);
        long result = (Long)executor.execute();
        executor = null;
        return result;
    }

    @Override
    @Deprecated
    public <T> long count(QueryCriteria queryCriteria, Class<T> clazz) {
        CountExecutor executor = new CountExecutor(this::getClient, queryCriteria, clazz);
        long result = (Long)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> long count(CriteriaWrapper criteriaWrapper, Class<T> clazz) {
        CountExecutor executor = new CountExecutor(this::getClient, criteriaWrapper, clazz);
        long result = (Long)executor.execute();
        executor = null;
        return result;
    }

    @Override
    @Deprecated
    public <T> long count(QueryCriteria queryCriteria) {
        Asserts.notNull((Object)queryCriteria, "queryCriteria must not be empty");
        Asserts.notNull((Object)queryCriteria.queryProperty.getSearchIndexRequest(), "queryCriteria indices  must not be empty");
        CountExecutor executor = new CountExecutor(this::getClient, queryCriteria);
        long result = (Long)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> long count(CriteriaWrapper criteriaWrapper) {
        Asserts.notNull((Object)criteriaWrapper, "queryCriteria must not be empty");
        Asserts.notNull((Object)criteriaWrapper.queryProperty.getSearchIndexRequest(), "queryCriteria indices  must not be empty");
        CountExecutor executor = new CountExecutor(this::getClient, criteriaWrapper);
        long result = (Long)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> long count(SearchQuery searchQuery) {
        Asserts.notNull((Object)searchQuery, "searchQuery must not be empty");
        Asserts.notNull((Object)searchQuery.getIndices(), "searchQuery indices  must not be empty");
        CountExecutor executor = new CountExecutor(this::getClient, searchQuery);
        long result = (Long)executor.execute();
        executor = null;
        return result;
    }

    @Override
    @Deprecated
    public <T> List<Map<String, Object>> aggregate(QueryCriteria queryCriteria) {
        Asserts.notNull((Object)queryCriteria.queryProperty.getSearchIndexRequest(), "queryCriteria indices  must not be empty");
        Asserts.notNull((Object)queryCriteria.queryProperty.getAggregateBuilder(), "queryCriteria Aggregation must not be empty");
        Asserts.isNull((Object)queryCriteria.queryProperty.getPage(), "Page must  be empty");
        SelectEntityExecutor executor = new SelectEntityExecutor(this::getClient, queryCriteria);
        List result = (List)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> List<Map<String, Object>> aggregate(CriteriaWrapper criteriaWrapper) {
        Asserts.notNull((Object)criteriaWrapper.queryProperty.getSearchIndexRequest(), "criteriaWrapper indices  must not be empty");
        Asserts.notNull((Object)criteriaWrapper.queryProperty.getAggregateBuilder(), "criteriaWrapper Aggregation must not be empty");
        Asserts.isNull((Object)criteriaWrapper.queryProperty.getPage(), "Page must  be empty");
        SelectEntityExecutor executor = new SelectEntityExecutor(this::getClient, criteriaWrapper);
        List result = (List)executor.execute();
        executor = null;
        return result;
    }

    @Override
    @Deprecated
    public <T> List<T> aggregate(QueryCriteria queryCriteria, Class<?> clazz) {
        Asserts.notNull((Object)queryCriteria.queryProperty.getAggregateBuilder(), "Aggregation must not be empty");
        Asserts.isNull((Object)queryCriteria.queryProperty.getPage(), "Page must  be empty");
        SelectEntityExecutor executor = new SelectEntityExecutor(this::getClient, queryCriteria, clazz);
        List result = (List)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> List<T> aggregate(CriteriaWrapper criteriaWrapper, Class<?> clazz) {
        Asserts.notNull((Object)criteriaWrapper.queryProperty.getAggregateBuilder(), "Aggregation must not be empty");
        Asserts.isNull((Object)criteriaWrapper.queryProperty.getPage(), "Page must  be empty");
        SelectEntityExecutor executor = new SelectEntityExecutor(this::getClient, criteriaWrapper, clazz);
        List result = (List)executor.execute();
        executor = null;
        return result;
    }

    @Override
    @Deprecated
    public <T> Page<Map<String, Object>> aggregateForPage(QueryCriteria queryCriteria) {
        Asserts.notNull((Object)queryCriteria.queryProperty.getSearchIndexRequest(), "queryCriteria indices  must not be empty ");
        Asserts.notNull((Object)queryCriteria.queryProperty.getAggregateBuilder(), "Aggregation must not be empty");
        Asserts.notNull((Object)queryCriteria.queryProperty.getPage(), "Page must not be empty");
        SelectEntityExecutor executor = new SelectEntityExecutor(this::getClient, queryCriteria);
        Page result = (Page)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> Page<Map<String, Object>> aggregateForPage(CriteriaWrapper criteriaWrapper) {
        Asserts.notNull((Object)criteriaWrapper.queryProperty.getSearchIndexRequest(), "criteriaWrapper indices  must not be empty ");
        Asserts.notNull((Object)criteriaWrapper.queryProperty.getAggregateBuilder(), "Aggregation must not be empty");
        Asserts.notNull((Object)criteriaWrapper.queryProperty.getPage(), "Page must not be empty");
        SelectEntityExecutor executor = new SelectEntityExecutor(this::getClient, criteriaWrapper);
        Page result = (Page)executor.execute();
        executor = null;
        return result;
    }

    @Override
    @Deprecated
    public <T> Page<T> aggregateForPage(QueryCriteria queryCriteria, Class<?> clazz) {
        Asserts.notNull((Object)queryCriteria.queryProperty.getAggregateBuilder(), "Aggregation must not be empty");
        Asserts.notNull((Object)queryCriteria.queryProperty.getPage(), "Page must not be empty");
        SelectEntityExecutor executor = new SelectEntityExecutor(this::getClient, queryCriteria, clazz);
        Page result = (Page)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> Page<T> aggregateForPage(CriteriaWrapper criteriaWrapper, Class<?> clazz) {
        Asserts.notNull((Object)criteriaWrapper.queryProperty.getAggregateBuilder(), "Aggregation must not be empty");
        Asserts.notNull((Object)criteriaWrapper.queryProperty.getPage(), "Page must not be empty");
        SelectEntityExecutor executor = new SelectEntityExecutor(this::getClient, criteriaWrapper, clazz);
        Page result = (Page)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> String status(String indices) {
        Asserts.notNull((Object)indices, "Cannot status 'null' indices.");
        ClusterNodesExecutor executor = new ClusterNodesExecutor(this::getClient, indices, ClusterNodesExecutor.IndexMode.STATUS);
        String result = (String)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> List<String> indices(String indices) {
        Asserts.notNull((Object)indices, "Cannot status 'null' indices.");
        ClusterNodesExecutor executor = new ClusterNodesExecutor(this::getClient, indices, ClusterNodesExecutor.IndexMode.INDICES);
        List result = (List)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> String getMapping(String indices) {
        Asserts.notNull((Object)indices, "Cannot status 'null' indices.");
        ClusterNodesExecutor executor = new ClusterNodesExecutor(this::getClient, indices, ClusterNodesExecutor.IndexMode.MAPPING);
        Object result = executor.execute();
        executor = null;
        return result.toString();
    }

    @Override
    public <T> String getSettings(String indices) {
        Asserts.notNull((Object)indices, "Cannot status 'null' indices.");
        ClusterNodesExecutor executor = new ClusterNodesExecutor(this::getClient, indices, ClusterNodesExecutor.IndexMode.SETTING);
        Object result = executor.execute();
        executor = null;
        return result.toString();
    }

    @Override
    public <T> ClusterHealth getClusterHealth() {
        ClusterNodesExecutor executor = new ClusterNodesExecutor(this::getClient, ClusterNodesExecutor.IndexMode.CLUSTER_HEALTH);
        ClusterHealth result = (ClusterHealth)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> ClusterStatsNodesInfo getClusterStats() {
        ClusterNodesExecutor executor = new ClusterNodesExecutor(this::getClient, ClusterNodesExecutor.IndexMode.CLUSTER_STATS);
        ClusterStatsNodesInfo result = (ClusterStatsNodesInfo)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> List<ClusterStatsNodesInfo> getAllNodeStatus() {
        ClusterNodesExecutor executor = new ClusterNodesExecutor(this::getClient, ClusterNodesExecutor.IndexMode.NODES);
        List result = (List)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> boolean open(String indexName) {
        Asserts.notNull((Object)indexName, "Cannot openIndex 'null' indexName.");
        IndexExecutor executor = new IndexExecutor(this::getClient, indexName, IndexExecutor.IndexRequestMode.OPEN);
        boolean result = (Boolean)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> boolean open(Class<T> clazz) {
        IndexExecutor<T> executor = new IndexExecutor<T>(this::getClient, clazz, IndexExecutor.IndexRequestMode.OPEN);
        boolean result = (Boolean)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> boolean close(String indexName) {
        Asserts.notNull((Object)indexName, "Cannot closeIndex 'null' indexName.");
        IndexExecutor executor = new IndexExecutor(this::getClient, indexName, IndexExecutor.IndexRequestMode.CLOSE);
        boolean result = (Boolean)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> boolean close(Class<T> clazz) {
        IndexExecutor<T> executor = new IndexExecutor<T>(this::getClient, clazz, IndexExecutor.IndexRequestMode.CLOSE);
        boolean result = (Boolean)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> boolean flush(String indexName) {
        Asserts.notNull((Object)indexName, "Cannot flush 'null' indexName.");
        IndexExecutor executor = new IndexExecutor(this::getClient, indexName, IndexExecutor.IndexRequestMode.FLUSH);
        boolean result = (Boolean)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> boolean flush(Class<T> clazz) {
        IndexExecutor<T> executor = new IndexExecutor<T>(this::getClient, clazz, IndexExecutor.IndexRequestMode.FLUSH);
        boolean result = (Boolean)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> boolean clearCache(String indexName) {
        Asserts.notNull((Object)indexName, "Cannot clearCacheIndex 'null' indexName.");
        IndexExecutor executor = new IndexExecutor(this::getClient, indexName, IndexExecutor.IndexRequestMode.CLEAR_CACHE);
        boolean result = (Boolean)executor.execute();
        executor = null;
        return result;
    }

    @Override
    public <T> boolean clearCache(Class<T> clazz) {
        IndexExecutor<T> executor = new IndexExecutor<T>(this::getClient, clazz, IndexExecutor.IndexRequestMode.CLEAR_CACHE);
        boolean result = (Boolean)executor.execute();
        executor = null;
        return result;
    }
}

