/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.core.client;

import com.xphsc.elasticsearch.core.client.RequestConvertersBuilder;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.cache.clear.ClearIndicesCacheRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.flush.FlushRequest;
import org.elasticsearch.action.admin.indices.flush.SyncedFlushRequest;
import org.elasticsearch.action.admin.indices.forcemerge.ForceMergeRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.open.OpenIndexRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.admin.indices.shrink.ResizeRequest;
import org.elasticsearch.action.admin.indices.shrink.ResizeType;
import org.elasticsearch.action.admin.indices.template.delete.DeleteIndexTemplateRequest;
import org.elasticsearch.action.admin.indices.validate.query.ValidateQueryRequest;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.indices.AnalyzeRequest;
import org.elasticsearch.client.indices.CloseIndexRequest;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.FreezeIndexRequest;
import org.elasticsearch.client.indices.GetIndexTemplatesRequest;
import org.elasticsearch.client.indices.GetMappingsRequest;
import org.elasticsearch.client.indices.IndexTemplatesExistRequest;
import org.elasticsearch.client.indices.PutIndexTemplateRequest;
import org.elasticsearch.client.indices.ReloadAnalyzersRequest;
import org.elasticsearch.client.indices.UnfreezeIndexRequest;
import org.elasticsearch.client.indices.rollover.RolloverRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentType;

public final class IndicesRequestConvertersBuilder {
    static Request deleteIndex(DeleteIndexRequest deleteIndexRequest) {
        String endpoint = RequestConvertersBuilder.endpoint(deleteIndexRequest.indices());
        Request request = new Request("DELETE", endpoint);
        RequestConvertersBuilder.Params parameters = new RequestConvertersBuilder.Params();
        parameters.withTimeout(deleteIndexRequest.timeout());
        parameters.withMasterTimeout(deleteIndexRequest.masterNodeTimeout());
        parameters.withIndicesOptions(deleteIndexRequest.indicesOptions());
        Map<String, String> asMap = parameters.asMap();
        request.addParameters(parameters.asMap());
        return request;
    }

    static Request openIndex(OpenIndexRequest openIndexRequest) {
        String endpoint = RequestConvertersBuilder.endpoint(openIndexRequest.indices(), "_open");
        Request request = new Request("POST", endpoint);
        RequestConvertersBuilder.Params parameters = new RequestConvertersBuilder.Params();
        parameters.withTimeout(openIndexRequest.timeout());
        parameters.withMasterTimeout(openIndexRequest.masterNodeTimeout());
        parameters.withWaitForActiveShards(openIndexRequest.waitForActiveShards());
        parameters.withIndicesOptions(openIndexRequest.indicesOptions());
        Map<String, String> asMap = parameters.asMap();
        request.addParameters(asMap);
        return request;
    }

    static Request closeIndex(CloseIndexRequest closeIndexRequest) {
        String endpoint = RequestConvertersBuilder.endpoint(closeIndexRequest.indices(), "_close");
        Request request = new Request("POST", endpoint);
        RequestConvertersBuilder.Params parameters = new RequestConvertersBuilder.Params();
        parameters.withTimeout(closeIndexRequest.timeout());
        parameters.withMasterTimeout(closeIndexRequest.masterNodeTimeout());
        parameters.withIndicesOptions(closeIndexRequest.indicesOptions());
        Map<String, String> asMap = parameters.asMap();
        request.addParameters(asMap);
        return request;
    }

    static Request createIndex(CreateIndexRequest createIndexRequest) throws IOException {
        String endpoint = new RequestConvertersBuilder.EndpointBuilder().addPathPart(createIndexRequest.index()).build();
        Request request = new Request("PUT", endpoint);
        RequestConvertersBuilder.Params parameters = new RequestConvertersBuilder.Params();
        parameters.withTimeout(createIndexRequest.timeout());
        parameters.withMasterTimeout(createIndexRequest.masterNodeTimeout());
        parameters.withWaitForActiveShards(createIndexRequest.waitForActiveShards());
        Map<String, String> asMap = parameters.asMap();
        request.addParameters(asMap);
        request.setEntity(RequestConvertersBuilder.createEntity((ToXContent)createIndexRequest, RequestConvertersBuilder.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request createIndex(org.elasticsearch.action.admin.indices.create.CreateIndexRequest createIndexRequest) throws IOException {
        String endpoint = RequestConvertersBuilder.endpoint(createIndexRequest.indices());
        Request request = new Request("PUT", endpoint);
        RequestConvertersBuilder.Params parameters = new RequestConvertersBuilder.Params();
        parameters.withTimeout(createIndexRequest.timeout());
        parameters.withMasterTimeout(createIndexRequest.masterNodeTimeout());
        parameters.withWaitForActiveShards(createIndexRequest.waitForActiveShards());
        request.addParameters(parameters.asMap());
        request.setEntity(RequestConvertersBuilder.createEntity((ToXContent)createIndexRequest, XContentType.JSON));
        return request;
    }

    static Request updateAliases(IndicesAliasesRequest indicesAliasesRequest) throws IOException {
        Request request = new Request("POST", "/_aliases");
        RequestConvertersBuilder.Params parameters = new RequestConvertersBuilder.Params();
        parameters.withTimeout(indicesAliasesRequest.timeout());
        parameters.withMasterTimeout(indicesAliasesRequest.masterNodeTimeout());
        request.addParameters(parameters.asMap());
        request.setEntity(RequestConvertersBuilder.createEntity((ToXContent)indicesAliasesRequest, RequestConvertersBuilder.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request putMapping(org.elasticsearch.client.indices.PutMappingRequest putMappingRequest) throws IOException {
        Request request = new Request("PUT", RequestConvertersBuilder.endpoint(putMappingRequest.indices(), "_mapping"));
        RequestConvertersBuilder.Params parameters = new RequestConvertersBuilder.Params();
        parameters.withTimeout(putMappingRequest.timeout());
        parameters.withMasterTimeout(putMappingRequest.masterNodeTimeout());
        request.addParameters(parameters.asMap());
        request.setEntity(RequestConvertersBuilder.createEntity((ToXContent)putMappingRequest, RequestConvertersBuilder.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    @Deprecated
    static Request putMapping(PutMappingRequest putMappingRequest) throws IOException {
        if (putMappingRequest.getConcreteIndex() != null) {
            throw new IllegalArgumentException("concreteIndex cannot be set on PutMapping requests made over the REST API");
        }
        Request request = new Request("PUT", RequestConvertersBuilder.endpoint(putMappingRequest.indices(), "_mapping", putMappingRequest.type()));
        RequestConvertersBuilder.Params parameters = new RequestConvertersBuilder.Params();
        parameters.withTimeout(putMappingRequest.timeout());
        parameters.withMasterTimeout(putMappingRequest.masterNodeTimeout());
        request.addParameters(parameters.asMap());
        request.setEntity(RequestConvertersBuilder.createEntity((ToXContent)putMappingRequest, RequestConvertersBuilder.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request putMappingForIncludTypeName(PutMappingRequest putMappingRequest) throws IOException {
        if (putMappingRequest.getConcreteIndex() != null) {
            throw new IllegalArgumentException("concreteIndex cannot be set on PutMapping requests made over the REST API");
        }
        Request request = new Request("PUT", RequestConvertersBuilder.endpoint(putMappingRequest.indices(), "_mapping", putMappingRequest.type()));
        RequestConvertersBuilder.Params parameters = new RequestConvertersBuilder.Params();
        parameters.withTimeout(putMappingRequest.timeout());
        parameters.withMasterTimeout(putMappingRequest.masterNodeTimeout());
        parameters.putParam("include_type_name", "true");
        request.addParameters(parameters.asMap());
        request.setEntity(RequestConvertersBuilder.createEntity((ToXContent)putMappingRequest, RequestConvertersBuilder.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request getMappings(GetMappingsRequest getMappingsRequest) {
        String[] indices = getMappingsRequest.indices() == null ? Strings.EMPTY_ARRAY : getMappingsRequest.indices();
        Request request = new Request("GET", RequestConvertersBuilder.endpoint(indices, "_mapping"));
        RequestConvertersBuilder.Params parameters = new RequestConvertersBuilder.Params();
        parameters.withMasterTimeout(getMappingsRequest.masterNodeTimeout());
        parameters.withIndicesOptions(getMappingsRequest.indicesOptions());
        parameters.withLocal(getMappingsRequest.local());
        Map<String, String> asMap = parameters.asMap();
        request.addParameters(parameters.asMap());
        return request;
    }

    @Deprecated
    static Request getMappings(org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequest getMappingsRequest) {
        String[] indices = getMappingsRequest.indices() == null ? Strings.EMPTY_ARRAY : getMappingsRequest.indices();
        String[] types = getMappingsRequest.types() == null ? Strings.EMPTY_ARRAY : getMappingsRequest.types();
        Request request = new Request("GET", RequestConvertersBuilder.endpoint(indices, "_mapping", types));
        RequestConvertersBuilder.Params parameters = new RequestConvertersBuilder.Params();
        parameters.withMasterTimeout(getMappingsRequest.masterNodeTimeout());
        parameters.withIndicesOptions(getMappingsRequest.indicesOptions());
        parameters.withLocal(getMappingsRequest.local());
        request.addParameters(parameters.asMap());
        return request;
    }

    static Request getFieldMapping(org.elasticsearch.client.indices.GetFieldMappingsRequest getFieldMappingsRequest) {
        String[] indices = getFieldMappingsRequest.indices() == null ? Strings.EMPTY_ARRAY : getFieldMappingsRequest.indices();
        String[] fields = getFieldMappingsRequest.fields() == null ? Strings.EMPTY_ARRAY : getFieldMappingsRequest.fields();
        String endpoint = new RequestConvertersBuilder.EndpointBuilder().addCommaSeparatedPathParts(indices).addPathPartAsIs("_mapping").addPathPartAsIs("field").addCommaSeparatedPathParts(fields).build();
        Request request = new Request("GET", endpoint);
        RequestConvertersBuilder.Params parameters = new RequestConvertersBuilder.Params();
        parameters.withIndicesOptions(getFieldMappingsRequest.indicesOptions());
        parameters.withIncludeDefaults(getFieldMappingsRequest.includeDefaults());
        parameters.withLocal(getFieldMappingsRequest.local());
        Map<String, String> asMap = parameters.asMap();
        request.addParameters(asMap);
        return request;
    }

    @Deprecated
    static Request getFieldMapping(GetFieldMappingsRequest getFieldMappingsRequest) {
        String[] indices = getFieldMappingsRequest.indices() == null ? Strings.EMPTY_ARRAY : getFieldMappingsRequest.indices();
        String[] types = getFieldMappingsRequest.types() == null ? Strings.EMPTY_ARRAY : getFieldMappingsRequest.types();
        String[] fields = getFieldMappingsRequest.fields() == null ? Strings.EMPTY_ARRAY : getFieldMappingsRequest.fields();
        String endpoint = new RequestConvertersBuilder.EndpointBuilder().addCommaSeparatedPathParts(indices).addPathPartAsIs("_mapping").addCommaSeparatedPathParts(types).addPathPartAsIs("field").addCommaSeparatedPathParts(fields).build();
        Request request = new Request("GET", endpoint);
        RequestConvertersBuilder.Params parameters = new RequestConvertersBuilder.Params();
        parameters.withIndicesOptions(getFieldMappingsRequest.indicesOptions());
        parameters.withIncludeDefaults(getFieldMappingsRequest.includeDefaults());
        parameters.withLocal(getFieldMappingsRequest.local());
        request.addParameters(parameters.asMap());
        return request;
    }

    static Request refresh(RefreshRequest refreshRequest) {
        String[] indices = refreshRequest.indices() == null ? Strings.EMPTY_ARRAY : refreshRequest.indices();
        Request request = new Request("POST", RequestConvertersBuilder.endpoint(indices, "_refresh"));
        RequestConvertersBuilder.Params parameters = new RequestConvertersBuilder.Params();
        parameters.withIndicesOptions(refreshRequest.indicesOptions());
        Map<String, String> asMap = parameters.asMap();
        request.addParameters(asMap);
        return request;
    }

    static Request flush(FlushRequest flushRequest) {
        String[] indices = flushRequest.indices() == null ? Strings.EMPTY_ARRAY : flushRequest.indices();
        Request request = new Request("POST", RequestConvertersBuilder.endpoint(indices, "_flush"));
        RequestConvertersBuilder.Params parameters = new RequestConvertersBuilder.Params();
        parameters.withIndicesOptions(flushRequest.indicesOptions());
        parameters.putParam("wait_if_ongoing", Boolean.toString(flushRequest.waitIfOngoing()));
        parameters.putParam("force", Boolean.toString(flushRequest.force()));
        request.addParameters(parameters.asMap());
        return request;
    }

    static Request flushSynced(SyncedFlushRequest syncedFlushRequest) {
        String[] indices = syncedFlushRequest.indices() == null ? Strings.EMPTY_ARRAY : syncedFlushRequest.indices();
        Request request = new Request("POST", RequestConvertersBuilder.endpoint(indices, "_flush/synced"));
        RequestConvertersBuilder.Params parameters = new RequestConvertersBuilder.Params();
        parameters.withIndicesOptions(syncedFlushRequest.indicesOptions());
        request.addParameters(parameters.asMap());
        return request;
    }

    static Request forceMerge(ForceMergeRequest forceMergeRequest) {
        String[] indices = forceMergeRequest.indices() == null ? Strings.EMPTY_ARRAY : forceMergeRequest.indices();
        Request request = new Request("POST", RequestConvertersBuilder.endpoint(indices, "_forcemerge"));
        RequestConvertersBuilder.Params parameters = new RequestConvertersBuilder.Params();
        parameters.withIndicesOptions(forceMergeRequest.indicesOptions());
        parameters.putParam("max_num_segments", Integer.toString(forceMergeRequest.maxNumSegments()));
        parameters.putParam("only_expunge_deletes", Boolean.toString(forceMergeRequest.onlyExpungeDeletes()));
        parameters.putParam("flush", Boolean.toString(forceMergeRequest.flush()));
        request.addParameters(parameters.asMap());
        return request;
    }

    static Request clearCache(ClearIndicesCacheRequest clearIndicesCacheRequest) {
        String[] indices = clearIndicesCacheRequest.indices() == null ? Strings.EMPTY_ARRAY : clearIndicesCacheRequest.indices();
        Request request = new Request("POST", RequestConvertersBuilder.endpoint(indices, "_cache/clear"));
        RequestConvertersBuilder.Params parameters = new RequestConvertersBuilder.Params();
        parameters.withIndicesOptions(clearIndicesCacheRequest.indicesOptions());
        parameters.putParam("query", Boolean.toString(clearIndicesCacheRequest.queryCache()));
        parameters.putParam("fielddata", Boolean.toString(clearIndicesCacheRequest.fieldDataCache()));
        parameters.putParam("request", Boolean.toString(clearIndicesCacheRequest.requestCache()));
        parameters.putParam("fields", String.join((CharSequence)",", clearIndicesCacheRequest.fields()));
        request.addParameters(parameters.asMap());
        return request;
    }

    static Request existsAlias(GetAliasesRequest getAliasesRequest) {
        if (!(getAliasesRequest.indices() != null && getAliasesRequest.indices().length != 0 || getAliasesRequest.aliases() != null && getAliasesRequest.aliases().length != 0)) {
            throw new IllegalArgumentException("existsAlias requires at least an alias or an index");
        }
        String[] indices = getAliasesRequest.indices() == null ? Strings.EMPTY_ARRAY : getAliasesRequest.indices();
        String[] aliases = getAliasesRequest.aliases() == null ? Strings.EMPTY_ARRAY : getAliasesRequest.aliases();
        Request request = new Request("HEAD", RequestConvertersBuilder.endpoint(indices, "_alias", aliases));
        RequestConvertersBuilder.Params params = new RequestConvertersBuilder.Params();
        params.withIndicesOptions(getAliasesRequest.indicesOptions());
        params.withLocal(getAliasesRequest.local());
        Map<String, String> asMap = params.asMap();
        request.addParameters(asMap);
        return request;
    }

    static Request split(ResizeRequest resizeRequest) throws IOException {
        if (resizeRequest.getResizeType() != ResizeType.SPLIT) {
            throw new IllegalArgumentException("Wrong resize type [" + resizeRequest.getResizeType() + "] for indices split request");
        }
        return IndicesRequestConvertersBuilder.resize(resizeRequest);
    }

    static Request shrink(ResizeRequest resizeRequest) throws IOException {
        if (resizeRequest.getResizeType() != ResizeType.SHRINK) {
            throw new IllegalArgumentException("Wrong resize type [" + resizeRequest.getResizeType() + "] for indices shrink request");
        }
        return IndicesRequestConvertersBuilder.resize(resizeRequest);
    }

    static Request clone(ResizeRequest resizeRequest) throws IOException {
        if (resizeRequest.getResizeType() != ResizeType.CLONE) {
            throw new IllegalArgumentException("Wrong resize type [" + resizeRequest.getResizeType() + "] for indices clone request");
        }
        return IndicesRequestConvertersBuilder.resize(resizeRequest);
    }

    private static Request resize(ResizeRequest resizeRequest) throws IOException {
        String endpoint = new RequestConvertersBuilder.EndpointBuilder().addPathPart(resizeRequest.getSourceIndex()).addPathPartAsIs("_" + resizeRequest.getResizeType().name().toLowerCase(Locale.ROOT)).addPathPart(resizeRequest.getTargetIndexRequest().index()).build();
        Request request = new Request("PUT", endpoint);
        RequestConvertersBuilder.Params params = new RequestConvertersBuilder.Params();
        params.withTimeout(resizeRequest.timeout());
        params.withMasterTimeout(resizeRequest.masterNodeTimeout());
        params.withWaitForActiveShards(resizeRequest.getTargetIndexRequest().waitForActiveShards());
        request.addParameters(params.asMap());
        request.setEntity(RequestConvertersBuilder.createEntity((ToXContent)resizeRequest, RequestConvertersBuilder.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request rollover(RolloverRequest rolloverRequest) throws IOException {
        String endpoint = new RequestConvertersBuilder.EndpointBuilder().addPathPart(rolloverRequest.getAlias()).addPathPartAsIs("_rollover").addPathPart(rolloverRequest.getNewIndexName()).build();
        Request request = new Request("POST", endpoint);
        RequestConvertersBuilder.Params params = new RequestConvertersBuilder.Params();
        params.withTimeout(rolloverRequest.timeout());
        params.withMasterTimeout(rolloverRequest.masterNodeTimeout());
        params.withWaitForActiveShards(rolloverRequest.getCreateIndexRequest().waitForActiveShards());
        if (rolloverRequest.isDryRun()) {
            params.putParam("dry_run", Boolean.TRUE.toString());
        }
        request.addParameters(params.asMap());
        request.setEntity(RequestConvertersBuilder.createEntity((ToXContent)rolloverRequest, RequestConvertersBuilder.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    @Deprecated
    static Request rollover(org.elasticsearch.action.admin.indices.rollover.RolloverRequest rolloverRequest) throws IOException {
        String endpoint = new RequestConvertersBuilder.EndpointBuilder().addPathPartAsIs("_rollover").addPathPart(rolloverRequest.getNewIndexName()).build();
        Request request = new Request("POST", endpoint);
        RequestConvertersBuilder.Params params = new RequestConvertersBuilder.Params();
        params.withTimeout(rolloverRequest.timeout());
        params.withMasterTimeout(rolloverRequest.masterNodeTimeout());
        params.withWaitForActiveShards(rolloverRequest.getCreateIndexRequest().waitForActiveShards());
        if (rolloverRequest.isDryRun()) {
            params.putParam("dry_run", Boolean.TRUE.toString());
        }
        params.putParam("include_type_name", "true");
        request.setEntity(RequestConvertersBuilder.createEntity((ToXContent)rolloverRequest, RequestConvertersBuilder.REQUEST_BODY_CONTENT_TYPE));
        request.addParameters(params.asMap());
        return request;
    }

    static Request getSettings(GetSettingsRequest getSettingsRequest) {
        String[] indices = getSettingsRequest.indices() == null ? Strings.EMPTY_ARRAY : getSettingsRequest.indices();
        String[] names = getSettingsRequest.names() == null ? Strings.EMPTY_ARRAY : getSettingsRequest.names();
        String endpoint = RequestConvertersBuilder.endpoint(indices, "_settings", names);
        Request request = new Request("GET", endpoint);
        RequestConvertersBuilder.Params params = new RequestConvertersBuilder.Params();
        params.withIndicesOptions(getSettingsRequest.indicesOptions());
        params.withLocal(getSettingsRequest.local());
        params.withIncludeDefaults(getSettingsRequest.includeDefaults());
        params.withMasterTimeout(getSettingsRequest.masterNodeTimeout());
        request.addParameters(params.asMap());
        return request;
    }

    @Deprecated
    static Request getIndex(GetIndexRequest getIndexRequest) {
        String[] indices = getIndexRequest.indices() == null ? Strings.EMPTY_ARRAY : getIndexRequest.indices();
        String endpoint = RequestConvertersBuilder.endpoint(indices);
        Request request = new Request("GET", endpoint);
        RequestConvertersBuilder.Params params = new RequestConvertersBuilder.Params();
        params.withIndicesOptions(getIndexRequest.indicesOptions());
        params.withLocal(getIndexRequest.local());
        params.withIncludeDefaults(getIndexRequest.includeDefaults());
        params.withHuman(getIndexRequest.humanReadable());
        params.withMasterTimeout(getIndexRequest.masterNodeTimeout());
        params.putParam("include_type_name", "true");
        request.addParameters(params.asMap());
        return request;
    }

    static Request getIndex(org.elasticsearch.client.indices.GetIndexRequest getIndexRequest) {
        String[] indices = getIndexRequest.indices() == null ? Strings.EMPTY_ARRAY : getIndexRequest.indices();
        String endpoint = RequestConvertersBuilder.endpoint(indices);
        Request request = new Request("GET", endpoint);
        RequestConvertersBuilder.Params params = new RequestConvertersBuilder.Params();
        params.withIndicesOptions(getIndexRequest.indicesOptions());
        params.withLocal(getIndexRequest.local());
        params.withIncludeDefaults(getIndexRequest.includeDefaults());
        params.withHuman(getIndexRequest.humanReadable());
        params.withMasterTimeout(getIndexRequest.masterNodeTimeout());
        request.addParameters(params.asMap());
        return request;
    }

    @Deprecated
    public static Request indicesExist(GetIndexRequest getIndexRequest) {
        if (getIndexRequest.indices() == null || getIndexRequest.indices().length == 0) {
            throw new IllegalArgumentException("indices are mandatory");
        }
        String endpoint = RequestConvertersBuilder.endpoint(getIndexRequest.indices(), "");
        Request request = new Request("HEAD", endpoint);
        RequestConvertersBuilder.Params params = new RequestConvertersBuilder.Params();
        params.withLocal(getIndexRequest.local());
        params.withHuman(getIndexRequest.humanReadable());
        request.addParameters(params.asMap());
        return request;
    }

    static Request indicesExist(org.elasticsearch.client.indices.GetIndexRequest getIndexRequest) {
        if (getIndexRequest.indices() == null || getIndexRequest.indices().length == 0) {
            throw new IllegalArgumentException("indices are mandatory");
        }
        String endpoint = RequestConvertersBuilder.endpoint(getIndexRequest.indices(), "");
        Request request = new Request("HEAD", endpoint);
        RequestConvertersBuilder.Params params = new RequestConvertersBuilder.Params();
        params.withLocal(getIndexRequest.local());
        params.withHuman(getIndexRequest.humanReadable());
        params.withIndicesOptions(getIndexRequest.indicesOptions());
        params.withIncludeDefaults(getIndexRequest.includeDefaults());
        Map<String, String> asMap = params.asMap();
        request.addParameters(asMap);
        return request;
    }

    static Request indexPutSettings(UpdateSettingsRequest updateSettingsRequest) throws IOException {
        String[] indices = updateSettingsRequest.indices() == null ? Strings.EMPTY_ARRAY : updateSettingsRequest.indices();
        Request request = new Request("PUT", RequestConvertersBuilder.endpoint(indices, "_settings"));
        RequestConvertersBuilder.Params parameters = new RequestConvertersBuilder.Params();
        parameters.withTimeout(updateSettingsRequest.timeout());
        parameters.withMasterTimeout(updateSettingsRequest.masterNodeTimeout());
        parameters.withIndicesOptions(updateSettingsRequest.indicesOptions());
        parameters.withPreserveExisting(updateSettingsRequest.isPreserveExisting());
        Map<String, String> asMap = parameters.asMap();
        request.addParameters(asMap);
        request.setEntity(RequestConvertersBuilder.createEntity((ToXContent)updateSettingsRequest, RequestConvertersBuilder.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    @Deprecated
    static Request putTemplate(org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest putIndexTemplateRequest) throws IOException {
        String endpoint = new RequestConvertersBuilder.EndpointBuilder().addPathPartAsIs("_template").addPathPart(putIndexTemplateRequest.name()).build();
        Request request = new Request("PUT", endpoint);
        RequestConvertersBuilder.Params params = new RequestConvertersBuilder.Params();
        params.withMasterTimeout(putIndexTemplateRequest.masterNodeTimeout());
        if (putIndexTemplateRequest.create()) {
            params.putParam("create", Boolean.TRUE.toString());
        }
        if (Strings.hasText((String)putIndexTemplateRequest.cause())) {
            params.putParam("cause", putIndexTemplateRequest.cause());
        }
        params.putParam("include_type_name", "true");
        request.addParameters(params.asMap());
        request.setEntity(RequestConvertersBuilder.createEntity((ToXContent)putIndexTemplateRequest, RequestConvertersBuilder.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request putTemplate(PutIndexTemplateRequest putIndexTemplateRequest) throws IOException {
        String endpoint = new RequestConvertersBuilder.EndpointBuilder().addPathPartAsIs("_template").addPathPart(putIndexTemplateRequest.name()).build();
        Request request = new Request("PUT", endpoint);
        RequestConvertersBuilder.Params params = new RequestConvertersBuilder.Params();
        params.withMasterTimeout(putIndexTemplateRequest.masterNodeTimeout());
        if (putIndexTemplateRequest.create()) {
            params.putParam("create", Boolean.TRUE.toString());
        }
        if (Strings.hasText((String)putIndexTemplateRequest.cause())) {
            params.putParam("cause", putIndexTemplateRequest.cause());
        }
        request.addParameters(params.asMap());
        request.setEntity(RequestConvertersBuilder.createEntity((ToXContent)putIndexTemplateRequest, RequestConvertersBuilder.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request validateQuery(ValidateQueryRequest validateQueryRequest) throws IOException {
        String[] indices = validateQueryRequest.indices() == null ? Strings.EMPTY_ARRAY : validateQueryRequest.indices();
        String[] types = validateQueryRequest.types() == null || indices.length <= 0 ? Strings.EMPTY_ARRAY : validateQueryRequest.types();
        String endpoint = RequestConvertersBuilder.endpoint(indices, types, "_validate/query");
        Request request = new Request("GET", endpoint);
        RequestConvertersBuilder.Params params = new RequestConvertersBuilder.Params();
        params.withIndicesOptions(validateQueryRequest.indicesOptions());
        params.putParam("explain", Boolean.toString(validateQueryRequest.explain()));
        params.putParam("all_shards", Boolean.toString(validateQueryRequest.allShards()));
        params.putParam("rewrite", Boolean.toString(validateQueryRequest.rewrite()));
        request.addParameters(params.asMap());
        request.setEntity(RequestConvertersBuilder.createEntity((ToXContent)validateQueryRequest, RequestConvertersBuilder.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request getAlias(GetAliasesRequest getAliasesRequest) {
        String[] indices = getAliasesRequest.indices() == null ? Strings.EMPTY_ARRAY : getAliasesRequest.indices();
        String[] aliases = getAliasesRequest.aliases() == null ? Strings.EMPTY_ARRAY : getAliasesRequest.aliases();
        String endpoint = RequestConvertersBuilder.endpoint(indices, "_alias", aliases);
        Request request = new Request("GET", endpoint);
        RequestConvertersBuilder.Params params = new RequestConvertersBuilder.Params();
        params.withIndicesOptions(getAliasesRequest.indicesOptions());
        params.withLocal(getAliasesRequest.local());
        request.addParameters(params.asMap());
        return request;
    }

    @Deprecated
    static Request getTemplatesWithDocumentTypes(GetIndexTemplatesRequest getIndexTemplatesRequest) {
        return IndicesRequestConvertersBuilder.getTemplates(getIndexTemplatesRequest, true);
    }

    static Request getTemplates(GetIndexTemplatesRequest getIndexTemplatesRequest) {
        return IndicesRequestConvertersBuilder.getTemplates(getIndexTemplatesRequest, false);
    }

    private static Request getTemplates(GetIndexTemplatesRequest getIndexTemplatesRequest, boolean includeTypeName) {
        String endpoint = new RequestConvertersBuilder.EndpointBuilder().addPathPartAsIs("_template").addCommaSeparatedPathParts(getIndexTemplatesRequest.names()).build();
        Request request = new Request("GET", endpoint);
        RequestConvertersBuilder.Params params = new RequestConvertersBuilder.Params();
        params.withLocal(getIndexTemplatesRequest.isLocal());
        params.withMasterTimeout(getIndexTemplatesRequest.getMasterNodeTimeout());
        if (includeTypeName) {
            params.putParam("include_type_name", "true");
        }
        request.addParameters(params.asMap());
        return request;
    }

    static Request templatesExist(IndexTemplatesExistRequest indexTemplatesExistRequest) {
        String endpoint = new RequestConvertersBuilder.EndpointBuilder().addPathPartAsIs("_template").addCommaSeparatedPathParts(indexTemplatesExistRequest.names()).build();
        Request request = new Request("HEAD", endpoint);
        RequestConvertersBuilder.Params params = new RequestConvertersBuilder.Params();
        params.withLocal(indexTemplatesExistRequest.isLocal());
        params.withMasterTimeout(indexTemplatesExistRequest.getMasterNodeTimeout());
        request.addParameters(params.asMap());
        return request;
    }

    static Request analyze(AnalyzeRequest request) throws IOException {
        RequestConvertersBuilder.EndpointBuilder builder = new RequestConvertersBuilder.EndpointBuilder();
        String index = request.index();
        if (index != null) {
            builder.addPathPart(index);
        }
        builder.addPathPartAsIs("_analyze");
        Request req = new Request("GET", builder.build());
        req.setEntity(RequestConvertersBuilder.createEntity((ToXContent)request, RequestConvertersBuilder.REQUEST_BODY_CONTENT_TYPE));
        return req;
    }

    static Request freezeIndex(FreezeIndexRequest freezeIndexRequest) {
        String endpoint = RequestConvertersBuilder.endpoint(freezeIndexRequest.getIndices(), "_freeze");
        Request request = new Request("POST", endpoint);
        RequestConvertersBuilder.Params parameters = new RequestConvertersBuilder.Params();
        parameters.withTimeout(freezeIndexRequest.timeout());
        parameters.withMasterTimeout(freezeIndexRequest.masterNodeTimeout());
        parameters.withIndicesOptions(freezeIndexRequest.indicesOptions());
        parameters.withWaitForActiveShards(freezeIndexRequest.getWaitForActiveShards());
        request.addParameters(parameters.asMap());
        return request;
    }

    static Request unfreezeIndex(UnfreezeIndexRequest unfreezeIndexRequest) {
        String endpoint = RequestConvertersBuilder.endpoint(unfreezeIndexRequest.getIndices(), "_unfreeze");
        Request request = new Request("POST", endpoint);
        RequestConvertersBuilder.Params parameters = new RequestConvertersBuilder.Params();
        parameters.withTimeout(unfreezeIndexRequest.timeout());
        parameters.withMasterTimeout(unfreezeIndexRequest.masterNodeTimeout());
        parameters.withIndicesOptions(unfreezeIndexRequest.indicesOptions());
        parameters.withWaitForActiveShards(unfreezeIndexRequest.getWaitForActiveShards());
        request.addParameters(parameters.asMap());
        return request;
    }

    static Request deleteTemplate(DeleteIndexTemplateRequest deleteIndexTemplateRequest) {
        String name = deleteIndexTemplateRequest.name();
        String endpoint = new RequestConvertersBuilder.EndpointBuilder().addPathPartAsIs("_template").addPathPart(name).build();
        Request request = new Request("DELETE", endpoint);
        RequestConvertersBuilder.Params params = new RequestConvertersBuilder.Params();
        params.withMasterTimeout(deleteIndexTemplateRequest.masterNodeTimeout());
        request.addParameters(params.asMap());
        return request;
    }

    static Request reloadAnalyzers(ReloadAnalyzersRequest reloadAnalyzersRequest) {
        String endpoint = RequestConvertersBuilder.endpoint(reloadAnalyzersRequest.getIndices(), "_reload_search_analyzers");
        Request request = new Request("POST", endpoint);
        RequestConvertersBuilder.Params parameters = new RequestConvertersBuilder.Params();
        parameters.withIndicesOptions(reloadAnalyzersRequest.indicesOptions());
        request.addParameters(parameters.asMap());
        return request;
    }
}

