/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.core.client;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NByteArrayEntity;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.admin.cluster.storedscripts.DeleteStoredScriptRequest;
import org.elasticsearch.action.admin.cluster.storedscripts.GetStoredScriptRequest;
import org.elasticsearch.action.admin.cluster.storedscripts.PutStoredScriptRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.explain.ExplainRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Requests;
import org.elasticsearch.client.RethrottleRequest;
import org.elasticsearch.client.core.CountRequest;
import org.elasticsearch.client.core.MultiTermVectorsRequest;
import org.elasticsearch.client.core.TermVectorsRequest;
import org.elasticsearch.client.indices.AnalyzeRequest;
import org.elasticsearch.client.security.RefreshPolicy;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.rankeval.RankEvalRequest;
import org.elasticsearch.index.reindex.AbstractBulkByScrollRequest;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;
import org.elasticsearch.script.mustache.MultiSearchTemplateRequest;
import org.elasticsearch.script.mustache.SearchTemplateRequest;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.tasks.TaskId;

public class RequestConvertersBuilder {
    static final XContentType REQUEST_BODY_CONTENT_TYPE = XContentType.JSON;

    private RequestConvertersBuilder() {
    }

    static Request delete(DeleteRequest deleteRequest) {
        String endpoint = RequestConvertersBuilder.endpoint(deleteRequest.index(), deleteRequest.type(), deleteRequest.id());
        Request request = new Request("DELETE", endpoint);
        Params parameters = new Params();
        parameters.withRouting(deleteRequest.routing());
        parameters.withTimeout(deleteRequest.timeout());
        parameters.withVersion(deleteRequest.version());
        parameters.withVersionType(deleteRequest.versionType());
        parameters.withRefreshPolicy(deleteRequest.getRefreshPolicy());
        parameters.withWaitForActiveShards(deleteRequest.waitForActiveShards());
        request.addParameters(parameters.asMap());
        return request;
    }

    static Request info() {
        return new Request("GET", "/");
    }

    public static Request bulk(BulkRequest bulkRequest) throws IOException {
        Request request = new Request("POST", "/_bulk");
        Params parameters = new Params();
        parameters.withTimeout(bulkRequest.timeout());
        parameters.withRefreshPolicy(bulkRequest.getRefreshPolicy());
        XContentType bulkContentType = null;
        for (int i = 0; i < bulkRequest.numberOfActions(); ++i) {
            DocWriteRequest action = (DocWriteRequest)bulkRequest.requests().get(i);
            DocWriteRequest.OpType opType = action.opType();
            if (opType != DocWriteRequest.OpType.INDEX && opType != DocWriteRequest.OpType.CREATE) {
                if (opType != DocWriteRequest.OpType.UPDATE) continue;
                UpdateRequest updateRequest = (UpdateRequest)action;
                if (updateRequest.doc() != null) {
                    bulkContentType = RequestConvertersBuilder.enforceSameContentType(updateRequest.doc(), bulkContentType);
                }
                if (updateRequest.upsertRequest() == null) continue;
                bulkContentType = RequestConvertersBuilder.enforceSameContentType(updateRequest.upsertRequest(), bulkContentType);
                continue;
            }
            bulkContentType = RequestConvertersBuilder.enforceSameContentType((IndexRequest)action, bulkContentType);
        }
        if (bulkContentType == null) {
            bulkContentType = XContentType.JSON;
        }
        byte separator = bulkContentType.xContent().streamSeparator();
        ContentType requestContentType = RequestConvertersBuilder.createContentType(bulkContentType);
        ByteArrayOutputStream content = new ByteArrayOutputStream();
        for (DocWriteRequest action : bulkRequest.requests()) {
            IndexRequest indexRequest;
            DocWriteRequest.OpType opType = action.opType();
            try (XContentBuilder metadata = XContentBuilder.builder((XContent)bulkContentType.xContent());){
                VersionType versionType;
                metadata.startObject();
                metadata.startObject(opType.getLowercase());
                if (Strings.hasLength((String)action.index())) {
                    metadata.field("_index", action.index());
                }
                if (Strings.hasLength((String)action.type()) && !"_doc".equals(action.type())) {
                    metadata.field("_type", action.type());
                }
                if (Strings.hasLength((String)action.id())) {
                    metadata.field("_id", action.id());
                }
                if (Strings.hasLength((String)action.routing())) {
                    metadata.field("routing", action.routing());
                }
                if (action.version() != -3L) {
                    metadata.field("version", action.version());
                }
                if ((versionType = action.versionType()) != VersionType.INTERNAL) {
                    if (versionType == VersionType.EXTERNAL) {
                        metadata.field("version_type", "external");
                    } else if (versionType == VersionType.EXTERNAL_GTE) {
                        metadata.field("version_type", "external_gte");
                    }
                }
                if (action.ifSeqNo() != -2L) {
                    metadata.field("if_seq_no", action.ifSeqNo());
                    metadata.field("if_primary_term", action.ifPrimaryTerm());
                }
                if (opType != DocWriteRequest.OpType.INDEX && opType != DocWriteRequest.OpType.CREATE) {
                    if (opType == DocWriteRequest.OpType.UPDATE) {
                        UpdateRequest updateRequest = (UpdateRequest)action;
                        if (updateRequest.retryOnConflict() > 0) {
                            metadata.field("retry_on_conflict", updateRequest.retryOnConflict());
                        }
                        if (updateRequest.fetchSource() != null) {
                            metadata.field("_source", (ToXContent)updateRequest.fetchSource());
                        }
                    }
                } else {
                    indexRequest = (IndexRequest)action;
                    if (Strings.hasLength((String)indexRequest.getPipeline())) {
                        metadata.field("pipeline", indexRequest.getPipeline());
                    }
                }
                metadata.endObject();
                metadata.endObject();
                BytesRef metadataSource = BytesReference.bytes((XContentBuilder)metadata).toBytesRef();
                content.write(metadataSource.bytes, metadataSource.offset, metadataSource.length);
                content.write(separator);
            }
            BytesRef source = null;
            if (opType != DocWriteRequest.OpType.INDEX && opType != DocWriteRequest.OpType.CREATE) {
                if (opType == DocWriteRequest.OpType.UPDATE) {
                    source = XContentHelper.toXContent((ToXContent)((UpdateRequest)action), (XContentType)bulkContentType, (boolean)false).toBytesRef();
                }
            } else {
                indexRequest = (IndexRequest)action;
                BytesReference indexSource = indexRequest.source();
                XContentType indexXContentType = indexRequest.getContentType();
                try (XContentParser parser = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)DeprecationHandler.THROW_UNSUPPORTED_OPERATION, (BytesReference)indexSource, (XContentType)indexXContentType);
                     XContentBuilder builder = XContentBuilder.builder((XContent)bulkContentType.xContent());){
                    builder.copyCurrentStructure(parser);
                    source = BytesReference.bytes((XContentBuilder)builder).toBytesRef();
                }
            }
            if (source == null) continue;
            content.write(source.bytes, source.offset, source.length);
            content.write(separator);
        }
        request.addParameters(parameters.asMap());
        request.setEntity((HttpEntity)new NByteArrayEntity(content.toByteArray(), 0, content.size(), requestContentType));
        return request;
    }

    static Request bulkFor(BulkRequest bulkRequest) throws IOException {
        Request request = new Request("POST", "/_bulk");
        Params parameters = new Params();
        parameters.withTimeout(bulkRequest.timeout());
        parameters.withRefreshPolicy(bulkRequest.getRefreshPolicy());
        XContentType bulkContentType = null;
        for (int i = 0; i < bulkRequest.numberOfActions(); ++i) {
            DocWriteRequest action = (DocWriteRequest)bulkRequest.requests().get(i);
            DocWriteRequest.OpType opType = action.opType();
            if (opType != DocWriteRequest.OpType.INDEX && opType != DocWriteRequest.OpType.CREATE) {
                if (opType != DocWriteRequest.OpType.UPDATE) continue;
                UpdateRequest updateRequest = (UpdateRequest)action;
                if (updateRequest.doc() != null) {
                    bulkContentType = RequestConvertersBuilder.enforceSameContentType(updateRequest.doc(), bulkContentType);
                }
                if (updateRequest.upsertRequest() == null) continue;
                bulkContentType = RequestConvertersBuilder.enforceSameContentType(updateRequest.upsertRequest(), bulkContentType);
                continue;
            }
            bulkContentType = RequestConvertersBuilder.enforceSameContentType((IndexRequest)action, bulkContentType);
        }
        if (bulkContentType == null) {
            bulkContentType = XContentType.JSON;
        }
        byte separator = bulkContentType.xContent().streamSeparator();
        ContentType requestContentType = RequestConvertersBuilder.createContentType(bulkContentType);
        ByteArrayOutputStream content = new ByteArrayOutputStream();
        for (DocWriteRequest action : bulkRequest.requests()) {
            IndexRequest indexRequest;
            DocWriteRequest.OpType opType = action.opType();
            try (XContentBuilder metadata = XContentBuilder.builder((XContent)bulkContentType.xContent());){
                VersionType versionType;
                metadata.startObject();
                metadata.startObject(opType.getLowercase());
                if (Strings.hasLength((String)action.index())) {
                    metadata.field("_index", action.index());
                }
                if (Strings.hasLength((String)action.type()) && !"_doc".equals(action.type())) {
                    metadata.field("_type", action.type());
                }
                if (Strings.hasLength((String)action.id())) {
                    metadata.field("_id", action.id());
                }
                if (Strings.hasLength((String)action.routing())) {
                    metadata.field("routing", action.routing());
                }
                if (action.version() != -3L) {
                    metadata.field("version", action.version());
                }
                if ((versionType = action.versionType()) != VersionType.INTERNAL) {
                    if (versionType == VersionType.EXTERNAL) {
                        metadata.field("version_type", "external");
                    } else if (versionType == VersionType.EXTERNAL_GTE) {
                        metadata.field("version_type", "external_gte");
                    }
                }
                if (action.ifSeqNo() != -2L) {
                    metadata.field("if_seq_no", action.ifSeqNo());
                    metadata.field("if_primary_term", action.ifPrimaryTerm());
                }
                if (opType != DocWriteRequest.OpType.INDEX && opType != DocWriteRequest.OpType.CREATE) {
                    if (opType == DocWriteRequest.OpType.UPDATE) {
                        UpdateRequest updateRequest = (UpdateRequest)action;
                        if (updateRequest.retryOnConflict() > 0) {
                            metadata.field("retry_on_conflict", updateRequest.retryOnConflict());
                        }
                        if (updateRequest.fetchSource() != null) {
                            metadata.field("_source", (ToXContent)updateRequest.fetchSource());
                        }
                    }
                } else {
                    indexRequest = (IndexRequest)action;
                    if (Strings.hasLength((String)indexRequest.getPipeline())) {
                        metadata.field("pipeline", indexRequest.getPipeline());
                    }
                }
                metadata.endObject();
                metadata.endObject();
                BytesRef metadataSource = BytesReference.bytes((XContentBuilder)metadata).toBytesRef();
                content.write(metadataSource.bytes, metadataSource.offset, metadataSource.length);
                content.write(separator);
            }
            BytesRef source = null;
            if (opType != DocWriteRequest.OpType.INDEX && opType != DocWriteRequest.OpType.CREATE) {
                if (opType == DocWriteRequest.OpType.UPDATE) {
                    source = XContentHelper.toXContent((ToXContent)((UpdateRequest)action), (XContentType)bulkContentType, (boolean)false).toBytesRef();
                }
            } else {
                indexRequest = (IndexRequest)action;
                BytesReference indexSource = indexRequest.source();
                XContentType indexXContentType = indexRequest.getContentType();
                try (XContentParser parser = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)DeprecationHandler.THROW_UNSUPPORTED_OPERATION, (BytesReference)indexSource, (XContentType)indexXContentType);
                     XContentBuilder builder = XContentBuilder.builder((XContent)bulkContentType.xContent());){
                    builder.copyCurrentStructure(parser);
                    source = BytesReference.bytes((XContentBuilder)builder).toBytesRef();
                }
            }
            if (source == null) continue;
            content.write(source.bytes, source.offset, source.length);
            content.write(separator);
        }
        request.addParameters(parameters.asMap());
        request.setEntity((HttpEntity)new NByteArrayEntity(content.toByteArray(), 0, content.size(), requestContentType));
        return request;
    }

    static Request exists(GetRequest getRequest) {
        return RequestConvertersBuilder.getStyleRequest("HEAD", getRequest);
    }

    static Request get(GetRequest getRequest) {
        return RequestConvertersBuilder.getStyleRequest("GET", getRequest);
    }

    private static Request getStyleRequest(String method, GetRequest getRequest) {
        Request request = new Request(method, RequestConvertersBuilder.endpoint(getRequest.index(), getRequest.type(), getRequest.id()));
        Params parameters = new Params();
        parameters.withPreference(getRequest.preference());
        parameters.withRouting(getRequest.routing());
        parameters.withRefresh(getRequest.refresh());
        parameters.withRealtime(getRequest.realtime());
        parameters.withStoredFields(getRequest.storedFields());
        parameters.withVersion(getRequest.version());
        parameters.withVersionType(getRequest.versionType());
        parameters.withFetchSourceContext(getRequest.fetchSourceContext());
        request.addParameters(parameters.asMap());
        return request;
    }

    static Request sourceExists(GetRequest getRequest) {
        String optionalType = getRequest.type();
        String endpoint = optionalType.equals("_doc") ? RequestConvertersBuilder.endpoint(getRequest.index(), "_source", getRequest.id()) : RequestConvertersBuilder.endpoint(getRequest.index(), optionalType, getRequest.id(), "_source");
        Request request = new Request("HEAD", endpoint);
        Params parameters = new Params();
        parameters.withPreference(getRequest.preference());
        parameters.withRouting(getRequest.routing());
        parameters.withRefresh(getRequest.refresh());
        parameters.withRealtime(getRequest.realtime());
        request.addParameters(parameters.asMap());
        return request;
    }

    static Request multiGet(MultiGetRequest multiGetRequest) throws IOException {
        Request request = new Request("POST", "/_mget");
        Params parameters = new Params();
        parameters.withPreference(multiGetRequest.preference());
        parameters.withRealtime(multiGetRequest.realtime());
        parameters.withRefresh(multiGetRequest.refresh());
        request.addParameters(parameters.asMap());
        request.setEntity(RequestConvertersBuilder.createEntity((ToXContent)multiGetRequest, REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request index(IndexRequest indexRequest) {
        String method;
        String string = method = Strings.hasLength((String)indexRequest.id()) ? "PUT" : "POST";
        String endpoint = indexRequest.opType() == DocWriteRequest.OpType.CREATE ? (indexRequest.type().equals("_doc") ? RequestConvertersBuilder.endpoint(indexRequest.index(), "_create", indexRequest.id()) : RequestConvertersBuilder.endpoint(indexRequest.index(), indexRequest.type(), indexRequest.id(), "_create")) : RequestConvertersBuilder.endpoint(indexRequest.index(), indexRequest.type(), indexRequest.id());
        Request request = new Request(method, endpoint);
        Params parameters = new Params();
        parameters.withRouting(indexRequest.routing());
        parameters.withTimeout(indexRequest.timeout());
        parameters.withVersion(indexRequest.version());
        parameters.withVersionType(indexRequest.versionType());
        parameters.withPipeline(indexRequest.getPipeline());
        parameters.withRefreshPolicy(indexRequest.getRefreshPolicy());
        parameters.withWaitForActiveShards(indexRequest.waitForActiveShards());
        BytesRef source = indexRequest.source().toBytesRef();
        ContentType contentType = RequestConvertersBuilder.createContentType(indexRequest.getContentType());
        request.addParameters(parameters.asMap());
        request.setEntity((HttpEntity)new NByteArrayEntity(source.bytes, source.offset, source.length, contentType));
        return request;
    }

    static Request ping() {
        return new Request("HEAD", "/");
    }

    static Request update(UpdateRequest updateRequest) throws IOException {
        String endpoint = updateRequest.type().equals("_doc") ? RequestConvertersBuilder.endpoint(updateRequest.index(), "_update", updateRequest.id()) : RequestConvertersBuilder.endpoint(updateRequest.index(), updateRequest.type(), updateRequest.id(), "_update");
        Request request = new Request("POST", endpoint);
        Params parameters = new Params();
        parameters.withRouting(updateRequest.routing());
        parameters.withTimeout(updateRequest.timeout());
        parameters.withRefreshPolicy(updateRequest.getRefreshPolicy());
        parameters.withWaitForActiveShards(updateRequest.waitForActiveShards());
        parameters.withDocAsUpsert(updateRequest.docAsUpsert());
        parameters.withFetchSourceContext(updateRequest.fetchSource());
        parameters.withRetryOnConflict(updateRequest.retryOnConflict());
        parameters.withVersion(updateRequest.version());
        parameters.withVersionType(updateRequest.versionType());
        XContentType xContentType = null;
        if (updateRequest.doc() != null) {
            xContentType = updateRequest.doc().getContentType();
        }
        if (updateRequest.upsertRequest() != null) {
            XContentType upsertContentType = updateRequest.upsertRequest().getContentType();
            if (xContentType != null && xContentType != upsertContentType) {
                throw new IllegalStateException("Update request cannot have different content types for doc [" + xContentType + "] and upsert [" + upsertContentType + "] documents");
            }
            xContentType = upsertContentType;
        }
        if (xContentType == null) {
            xContentType = Requests.INDEX_CONTENT_TYPE;
        }
        request.addParameters(parameters.asMap());
        request.setEntity(RequestConvertersBuilder.createEntity((ToXContent)updateRequest, xContentType));
        return request;
    }

    static Request search(SearchRequest searchRequest, String searchEndpoint) throws IOException {
        Request request = new Request("POST", RequestConvertersBuilder.endpoint(searchRequest.indices(), searchRequest.types(), searchEndpoint));
        Params params = new Params();
        RequestConvertersBuilder.addSearchRequestParams(params, searchRequest);
        if (searchRequest.source() != null) {
            request.setEntity(RequestConvertersBuilder.createEntity((ToXContent)searchRequest.source(), REQUEST_BODY_CONTENT_TYPE));
        }
        request.addParameters(params.asMap());
        return request;
    }

    private static void addSearchRequestParams(Params params, SearchRequest searchRequest) {
        params.putParam("typed_keys", "true");
        params.withRouting(searchRequest.routing());
        params.withPreference(searchRequest.preference());
        params.withIndicesOptions(searchRequest.indicesOptions());
        params.putParam("search_type", searchRequest.searchType().name().toLowerCase(Locale.ROOT));
        if (searchRequest.requestCache() != null) {
            params.putParam("request_cache", Boolean.toString(searchRequest.requestCache()));
        }
        if (searchRequest.allowPartialSearchResults() != null) {
            params.putParam("allow_partial_search_results", Boolean.toString(searchRequest.allowPartialSearchResults()));
        }
        if (searchRequest.scroll() != null) {
            params.putParam("scroll", searchRequest.scroll().keepAlive());
        }
    }

    static Request searchScroll(SearchScrollRequest searchScrollRequest) throws IOException {
        Request request = new Request("POST", "/_search/scroll");
        request.setEntity(RequestConvertersBuilder.createEntity((ToXContent)searchScrollRequest, REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request clearScroll(ClearScrollRequest clearScrollRequest) throws IOException {
        Request request = new Request("DELETE", "/_search/scroll");
        request.setEntity(RequestConvertersBuilder.createEntity((ToXContent)clearScrollRequest, REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request multiSearch(MultiSearchRequest multiSearchRequest) throws IOException {
        Request request = new Request("POST", "/_msearch");
        Params params = new Params();
        params.putParam("typed_keys", "true");
        if (multiSearchRequest.maxConcurrentSearchRequests() != 0) {
            params.putParam("max_concurrent_searches", Integer.toString(multiSearchRequest.maxConcurrentSearchRequests()));
        }
        XContent xContent = REQUEST_BODY_CONTENT_TYPE.xContent();
        byte[] source = MultiSearchRequest.writeMultiLineFormat((MultiSearchRequest)multiSearchRequest, (XContent)xContent);
        request.addParameters(params.asMap());
        request.setEntity((HttpEntity)new NByteArrayEntity(source, RequestConvertersBuilder.createContentType(xContent.type())));
        return request;
    }

    static Request searchTemplate(SearchTemplateRequest searchTemplateRequest) throws IOException {
        Request request;
        if (searchTemplateRequest.isSimulate()) {
            request = new Request("GET", "_render/template");
        } else {
            SearchRequest searchRequest = searchTemplateRequest.getRequest();
            String endpoint = RequestConvertersBuilder.endpoint(searchRequest.indices(), searchRequest.types(), "_search/template");
            request = new Request("GET", endpoint);
            Params params = new Params();
            RequestConvertersBuilder.addSearchRequestParams(params, searchRequest);
            request.addParameters(params.asMap());
        }
        request.setEntity(RequestConvertersBuilder.createEntity((ToXContent)searchTemplateRequest, REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request multiSearchTemplate(MultiSearchTemplateRequest multiSearchTemplateRequest) throws IOException {
        Request request = new Request("POST", "/_msearch/template");
        Params params = new Params();
        params.putParam("typed_keys", "true");
        if (multiSearchTemplateRequest.maxConcurrentSearchRequests() != 0) {
            params.putParam("max_concurrent_searches", Integer.toString(multiSearchTemplateRequest.maxConcurrentSearchRequests()));
        }
        request.addParameters(params.asMap());
        XContent xContent = REQUEST_BODY_CONTENT_TYPE.xContent();
        byte[] source = MultiSearchTemplateRequest.writeMultiLineFormat((MultiSearchTemplateRequest)multiSearchTemplateRequest, (XContent)xContent);
        request.setEntity((HttpEntity)new NByteArrayEntity(source, RequestConvertersBuilder.createContentType(xContent.type())));
        return request;
    }

    static Request count(CountRequest countRequest) throws IOException {
        Request request = new Request("POST", RequestConvertersBuilder.endpoint(countRequest.indices(), countRequest.types(), "_count"));
        Params params = new Params();
        params.withRouting(countRequest.routing());
        params.withPreference(countRequest.preference());
        params.withIndicesOptions(countRequest.indicesOptions());
        if (countRequest.terminateAfter() != 0) {
            params.withTerminateAfter(countRequest.terminateAfter());
        }
        if (countRequest.minScore() != null) {
            params.putParam("min_score", String.valueOf(countRequest.minScore()));
        }
        request.addParameters(params.asMap());
        request.setEntity(RequestConvertersBuilder.createEntity((ToXContent)countRequest, REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    @Deprecated
    static Request explain(ExplainRequest explainRequest) throws IOException {
        String endpoint = explainRequest.type().equals("_doc") ? RequestConvertersBuilder.endpoint(explainRequest.index(), "_explain", explainRequest.id()) : RequestConvertersBuilder.endpoint(explainRequest.index(), explainRequest.type(), explainRequest.id(), "_explain");
        Request request = new Request("GET", endpoint);
        Params params = new Params();
        params.withStoredFields(explainRequest.storedFields());
        params.withFetchSourceContext(explainRequest.fetchSourceContext());
        params.withRouting(explainRequest.routing());
        params.withPreference(explainRequest.preference());
        request.addParameters(params.asMap());
        return request;
    }

    static Request fieldCaps(FieldCapabilitiesRequest fieldCapabilitiesRequest) {
        Request request = new Request("GET", RequestConvertersBuilder.endpoint(fieldCapabilitiesRequest.indices(), "_field_caps"));
        Params params = new Params();
        params.withFields(fieldCapabilitiesRequest.fields());
        params.withIndicesOptions(fieldCapabilitiesRequest.indicesOptions());
        request.addParameters(params.asMap());
        return request;
    }

    static Request rankEval(RankEvalRequest rankEvalRequest) throws IOException {
        Request request = new Request("GET", RequestConvertersBuilder.endpoint(rankEvalRequest.indices(), Strings.EMPTY_ARRAY, "_rank_eval"));
        Params params = new Params();
        params.withIndicesOptions(rankEvalRequest.indicesOptions());
        params.putParam("search_type", rankEvalRequest.searchType().name().toLowerCase(Locale.ROOT));
        request.addParameters(params.asMap());
        request.setEntity(RequestConvertersBuilder.createEntity((ToXContent)rankEvalRequest.getRankEvalSpec(), REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request reindex(ReindexRequest reindexRequest) throws IOException {
        return RequestConvertersBuilder.prepareReindexRequest(reindexRequest, true);
    }

    static Request submitReindex(ReindexRequest reindexRequest) throws IOException {
        return RequestConvertersBuilder.prepareReindexRequest(reindexRequest, false);
    }

    static Request submitDeleteByQuery(DeleteByQueryRequest deleteByQueryRequest) throws IOException {
        return RequestConvertersBuilder.prepareDeleteByQueryRequest(deleteByQueryRequest, false);
    }

    @Deprecated
    private static Request prepareReindexRequest(ReindexRequest reindexRequest, boolean waitForCompletion) throws IOException {
        String endpoint = new EndpointBuilder().addPathPart("_reindex").build();
        Request request = new Request("POST", endpoint);
        Params params = new Params().withWaitForCompletion(waitForCompletion).withRefresh(reindexRequest.isRefresh()).withTimeout(reindexRequest.getTimeout()).withWaitForActiveShards(reindexRequest.getWaitForActiveShards()).withRequestsPerSecond(reindexRequest.getRequestsPerSecond()).withSlices(reindexRequest.getSlices());
        if (reindexRequest.getScrollTime() != null) {
            params.putParam("scroll", reindexRequest.getScrollTime());
        }
        request.addParameters(params.asMap());
        return request;
    }

    @Deprecated
    private static Request prepareDeleteByQueryRequest(DeleteByQueryRequest deleteByQueryRequest, boolean waitForCompletion) throws IOException {
        String endpoint = RequestConvertersBuilder.endpoint(deleteByQueryRequest.indices(), deleteByQueryRequest.types(), "_delete_by_query");
        Request request = new Request("POST", endpoint);
        Params params = new Params().withRefresh(deleteByQueryRequest.isRefresh()).withTimeout(deleteByQueryRequest.getTimeout()).withWaitForActiveShards(deleteByQueryRequest.getWaitForActiveShards()).withRequestsPerSecond(deleteByQueryRequest.getRequestsPerSecond()).withIndicesOptions(deleteByQueryRequest.indicesOptions()).withWaitForCompletion(waitForCompletion).withSlices(deleteByQueryRequest.getSlices());
        if (!deleteByQueryRequest.isAbortOnVersionConflict()) {
            params.putParam("conflicts", "proceed");
        }
        if (deleteByQueryRequest.getBatchSize() != 1000) {
            params.putParam("scroll_size", Integer.toString(deleteByQueryRequest.getBatchSize()));
        }
        if (deleteByQueryRequest.getScrollTime() != AbstractBulkByScrollRequest.DEFAULT_SCROLL_TIMEOUT) {
            params.putParam("scroll", deleteByQueryRequest.getScrollTime());
        }
        if (deleteByQueryRequest.getMaxDocs() > 0) {
            params.putParam("max_docs", Integer.toString(deleteByQueryRequest.getMaxDocs()));
        }
        request.addParameters(params.asMap());
        request.setEntity(RequestConvertersBuilder.createEntity((ToXContent)deleteByQueryRequest, REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    @Deprecated
    static Request updateByQuery(UpdateByQueryRequest updateByQueryRequest) throws IOException {
        String endpoint = RequestConvertersBuilder.endpoint(updateByQueryRequest.indices(), "_update_by_query");
        Request request = new Request("POST", endpoint);
        Params params = new Params().withPipeline(updateByQueryRequest.getPipeline()).withRefresh(updateByQueryRequest.isRefresh()).withTimeout(updateByQueryRequest.getTimeout()).withWaitForActiveShards(updateByQueryRequest.getWaitForActiveShards()).withRequestsPerSecond(updateByQueryRequest.getRequestsPerSecond()).withIndicesOptions(updateByQueryRequest.indicesOptions()).withSlices(updateByQueryRequest.getSlices());
        if (!updateByQueryRequest.isAbortOnVersionConflict()) {
            params.putParam("conflicts", "proceed");
        }
        request.addParameters(params.asMap());
        request.setEntity(RequestConvertersBuilder.createEntity((ToXContent)updateByQueryRequest.getScript(), REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request deleteByQuery(DeleteByQueryRequest deleteByQueryRequest) throws IOException {
        return RequestConvertersBuilder.prepareDeleteByQueryRequest(deleteByQueryRequest, true);
    }

    static Request rethrottleReindex(RethrottleRequest rethrottleRequest) {
        return RequestConvertersBuilder.rethrottle(rethrottleRequest, "_reindex");
    }

    static Request rethrottleUpdateByQuery(RethrottleRequest rethrottleRequest) {
        return RequestConvertersBuilder.rethrottle(rethrottleRequest, "_update_by_query");
    }

    static Request rethrottleDeleteByQuery(RethrottleRequest rethrottleRequest) {
        return RequestConvertersBuilder.rethrottle(rethrottleRequest, "_delete_by_query");
    }

    private static Request rethrottle(RethrottleRequest rethrottleRequest, String firstPathPart) {
        String endpoint = new EndpointBuilder().addPathPart(firstPathPart).addPathPart(rethrottleRequest.getTaskId().toString()).addPathPart("_rethrottle").build();
        Request request = new Request("POST", endpoint);
        Params params = new Params().withRequestsPerSecond(rethrottleRequest.getRequestsPerSecond());
        params.putParam("group_by", "none");
        request.addParameters(params.asMap());
        return request;
    }

    @Deprecated
    static Request putScript(PutStoredScriptRequest putStoredScriptRequest) throws IOException {
        String endpoint = new EndpointBuilder().addPathPartAsIs("_scripts").addPathPart(putStoredScriptRequest.id()).build();
        Request request = new Request("POST", endpoint);
        Params params = new Params();
        params.withTimeout(putStoredScriptRequest.timeout());
        params.withMasterTimeout(putStoredScriptRequest.masterNodeTimeout());
        if (Strings.hasText((String)putStoredScriptRequest.context())) {
            params.putParam("context", putStoredScriptRequest.context());
        }
        request.addParameters(params.asMap());
        request.setEntity(RequestConvertersBuilder.createEntity((ToXContent)putStoredScriptRequest, REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request analyze(AnalyzeRequest request) throws IOException {
        EndpointBuilder builder = new EndpointBuilder();
        String index = request.index();
        if (index != null) {
            builder.addPathPart(index);
        }
        builder.addPathPartAsIs("_analyze");
        Request req = new Request("GET", builder.build());
        req.setEntity(RequestConvertersBuilder.createEntity((ToXContent)request, REQUEST_BODY_CONTENT_TYPE));
        return req;
    }

    static Request termVectors(TermVectorsRequest tvrequest) throws IOException {
        String endpoint = tvrequest.getType() != null ? new EndpointBuilder().addPathPart(tvrequest.getIndex(), tvrequest.getType(), tvrequest.getId()).addPathPartAsIs("_termvectors").build() : new EndpointBuilder().addPathPart(tvrequest.getIndex()).addPathPartAsIs("_termvectors").addPathPart(tvrequest.getId()).build();
        Request request = new Request("GET", endpoint);
        Params params = new Params();
        params.withRouting(tvrequest.getRouting());
        params.withPreference(tvrequest.getPreference());
        params.withFields(tvrequest.getFields());
        params.withRealtime(tvrequest.getRealtime());
        request.addParameters(params.asMap());
        request.setEntity(RequestConvertersBuilder.createEntity((ToXContent)tvrequest, REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request mtermVectors(MultiTermVectorsRequest mtvrequest) throws IOException {
        String endpoint = "_mtermvectors";
        Request request = new Request("GET", endpoint);
        request.setEntity(RequestConvertersBuilder.createEntity((ToXContent)mtvrequest, REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request getScript(GetStoredScriptRequest getStoredScriptRequest) {
        String endpoint = new EndpointBuilder().addPathPartAsIs("_scripts").addPathPart(getStoredScriptRequest.id()).build();
        Request request = new Request("GET", endpoint);
        Params params = new Params();
        params.withMasterTimeout(getStoredScriptRequest.masterNodeTimeout());
        request.addParameters(params.asMap());
        return request;
    }

    static Request deleteScript(DeleteStoredScriptRequest deleteStoredScriptRequest) {
        String endpoint = new EndpointBuilder().addPathPartAsIs("_scripts").addPathPart(deleteStoredScriptRequest.id()).build();
        Request request = new Request("DELETE", endpoint);
        Params params = new Params();
        params.withTimeout(deleteStoredScriptRequest.timeout());
        params.withMasterTimeout(deleteStoredScriptRequest.masterNodeTimeout());
        request.addParameters(params.asMap());
        return request;
    }

    static HttpEntity createEntity(ToXContent toXContent, XContentType xContentType) throws IOException {
        return RequestConvertersBuilder.createEntity(toXContent, xContentType, ToXContent.EMPTY_PARAMS);
    }

    static HttpEntity createEntity(ToXContent toXContent, XContentType xContentType, ToXContent.Params toXContentParams) throws IOException {
        BytesRef source = XContentHelper.toXContent((ToXContent)toXContent, (XContentType)xContentType, (ToXContent.Params)toXContentParams, (boolean)false).toBytesRef();
        return new NByteArrayEntity(source.bytes, source.offset, source.length, RequestConvertersBuilder.createContentType(xContentType));
    }

    static String endpoint(String index, String type, String id) {
        return new EndpointBuilder().addPathPart(index, type, id).build();
    }

    static String endpoint(String index, String type, String id, String endpoint) {
        return new EndpointBuilder().addPathPart(index, type, id).addPathPartAsIs(endpoint).build();
    }

    static String endpoint(String[] indices) {
        return new EndpointBuilder().addCommaSeparatedPathParts(indices).build();
    }

    static String endpoint(String[] indices, String endpoint) {
        return new EndpointBuilder().addCommaSeparatedPathParts(indices).addPathPartAsIs(endpoint).build();
    }

    static String endpoint(String[] indices, String[] types, String endpoint) {
        return new EndpointBuilder().addCommaSeparatedPathParts(indices).addCommaSeparatedPathParts(types).addPathPartAsIs(endpoint).build();
    }

    static String endpoint(String[] indices, String endpoint, String[] suffixes) {
        return new EndpointBuilder().addCommaSeparatedPathParts(indices).addPathPartAsIs(endpoint).addCommaSeparatedPathParts(suffixes).build();
    }

    static String endpoint(String[] indices, String endpoint, String type) {
        return new EndpointBuilder().addCommaSeparatedPathParts(indices).addPathPartAsIs(endpoint).addPathPart(type).build();
    }

    @SuppressForbidden(reason="Only allowed place to convert a XContentType to a ContentType")
    public static ContentType createContentType(XContentType xContentType) {
        return ContentType.create((String)xContentType.mediaTypeWithoutParameters(), (Charset)null);
    }

    static XContentType enforceSameContentType(IndexRequest indexRequest, @Nullable XContentType xContentType) {
        XContentType requestContentType = indexRequest.getContentType();
        if (requestContentType != XContentType.JSON && requestContentType != XContentType.SMILE) {
            throw new IllegalArgumentException("Unsupported content-type found for request with content-type [" + requestContentType + "], only JSON and SMILE are supported");
        }
        if (xContentType == null) {
            return requestContentType;
        }
        if (requestContentType != xContentType) {
            throw new IllegalArgumentException("Mismatching content-type found for request with content-type [" + requestContentType + "], previous requests have content-type [" + xContentType + "]");
        }
        return xContentType;
    }

    static class EndpointBuilder {
        private final StringJoiner joiner = new StringJoiner("/", "/", "");

        EndpointBuilder() {
        }

        EndpointBuilder addPathPart(String ... parts) {
            String[] var2 = parts;
            int var3 = parts.length;
            for (int var4 = 0; var4 < var3; ++var4) {
                String part = var2[var4];
                if (!Strings.hasLength((String)part)) continue;
                this.joiner.add(EndpointBuilder.encodePart(part));
            }
            return this;
        }

        EndpointBuilder addCommaSeparatedPathParts(String[] parts) {
            this.addPathPart(String.join((CharSequence)",", parts));
            return this;
        }

        EndpointBuilder addCommaSeparatedPathParts(List<String> parts) {
            this.addPathPart(String.join((CharSequence)",", parts));
            return this;
        }

        EndpointBuilder addPathPartAsIs(String ... parts) {
            String[] var2 = parts;
            int var3 = parts.length;
            for (int var4 = 0; var4 < var3; ++var4) {
                String part = var2[var4];
                if (!Strings.hasLength((String)part)) continue;
                this.joiner.add(part);
            }
            return this;
        }

        String build() {
            return this.joiner.toString();
        }

        private static String encodePart(String pathPart) {
            try {
                URI uri = new URI(null, "", "/" + pathPart, null, null);
                return uri.getRawPath().substring(1).replaceAll("/", "%2F");
            }
            catch (URISyntaxException var2) {
                throw new IllegalArgumentException("Path part [" + pathPart + "] couldn't be encoded", var2);
            }
        }
    }

    static class Params {
        private final Map<String, String> parameters = new HashMap<String, String>();

        Params() {
        }

        Params putParam(String name, String value) {
            if (Strings.hasLength((String)value)) {
                this.parameters.put(name, value);
            }
            return this;
        }

        Params putParam(String key, TimeValue value) {
            return value != null ? this.putParam(key, value.getStringRep()) : this;
        }

        Map<String, String> asMap() {
            return this.parameters;
        }

        Params withDocAsUpsert(boolean docAsUpsert) {
            return docAsUpsert ? this.putParam("doc_as_upsert", Boolean.TRUE.toString()) : this;
        }

        Params withFetchSourceContext(FetchSourceContext fetchSourceContext) {
            if (fetchSourceContext != null) {
                if (!fetchSourceContext.fetchSource()) {
                    this.putParam("_source", Boolean.FALSE.toString());
                }
                if (fetchSourceContext.includes() != null && fetchSourceContext.includes().length > 0) {
                    this.putParam("_source_includes", String.join((CharSequence)",", fetchSourceContext.includes()));
                }
                if (fetchSourceContext.excludes() != null && fetchSourceContext.excludes().length > 0) {
                    this.putParam("_source_excludes", String.join((CharSequence)",", fetchSourceContext.excludes()));
                }
            }
            return this;
        }

        Params withFields(String[] fields) {
            return fields != null && fields.length > 0 ? this.putParam("fields", String.join((CharSequence)",", fields)) : this;
        }

        Params withMasterTimeout(TimeValue masterTimeout) {
            return this.putParam("master_timeout", masterTimeout);
        }

        Params withPipeline(String pipeline) {
            return this.putParam("pipeline", pipeline);
        }

        Params withPreference(String preference) {
            return this.putParam("preference", preference);
        }

        Params withRealtime(boolean realtime) {
            return !realtime ? this.putParam("realtime", Boolean.FALSE.toString()) : this;
        }

        Params withRefresh(boolean refresh) {
            return refresh ? this.withRefreshPolicy(RefreshPolicy.IMMEDIATE) : this;
        }

        @Deprecated
        Params withRefreshPolicy(WriteRequest.RefreshPolicy refreshPolicy) {
            return refreshPolicy != WriteRequest.RefreshPolicy.NONE ? this.putParam("refresh", refreshPolicy.getValue()) : this;
        }

        Params withRefreshPolicy(RefreshPolicy refreshPolicy) {
            return refreshPolicy != RefreshPolicy.NONE ? this.putParam("refresh", refreshPolicy.getValue()) : this;
        }

        Params withRequestsPerSecond(float requestsPerSecond) {
            return Float.isFinite(requestsPerSecond) ? this.putParam("requests_per_second", Float.toString(requestsPerSecond)) : this.putParam("requests_per_second", "-1");
        }

        Params withRetryOnConflict(int retryOnConflict) {
            return retryOnConflict > 0 ? this.putParam("retry_on_conflict", String.valueOf(retryOnConflict)) : this;
        }

        Params withRouting(String routing) {
            return this.putParam("routing", routing);
        }

        Params withSlices(int slices) {
            return slices == 0 ? this.putParam("slices", "auto") : this.putParam("slices", String.valueOf(slices));
        }

        Params withStoredFields(String[] storedFields) {
            return storedFields != null && storedFields.length > 0 ? this.putParam("stored_fields", String.join((CharSequence)",", storedFields)) : this;
        }

        Params withTerminateAfter(int terminateAfter) {
            return this.putParam("terminate_after", String.valueOf(terminateAfter));
        }

        Params withTimeout(TimeValue timeout) {
            return this.putParam("timeout", timeout);
        }

        Params withVersion(long version) {
            return version != -3L ? this.putParam("version", Long.toString(version)) : this;
        }

        Params withVersionType(VersionType versionType) {
            return versionType != VersionType.INTERNAL ? this.putParam("version_type", versionType.name().toLowerCase(Locale.ROOT)) : this;
        }

        Params withIfSeqNo(long ifSeqNo) {
            return ifSeqNo != -2L ? this.putParam("if_seq_no", Long.toString(ifSeqNo)) : this;
        }

        Params withIfPrimaryTerm(long ifPrimaryTerm) {
            return ifPrimaryTerm != 0L ? this.putParam("if_primary_term", Long.toString(ifPrimaryTerm)) : this;
        }

        Params withWaitForActiveShards(ActiveShardCount activeShardCount) {
            return this.withWaitForActiveShards(activeShardCount, ActiveShardCount.DEFAULT);
        }

        Params withWaitForActiveShards(ActiveShardCount activeShardCount, ActiveShardCount defaultActiveShardCount) {
            return activeShardCount != null && activeShardCount != defaultActiveShardCount ? this.putParam("wait_for_active_shards", activeShardCount.toString().toLowerCase(Locale.ROOT)) : this;
        }

        Params withIndicesOptions(IndicesOptions indicesOptions) {
            if (indicesOptions != null) {
                String expandWildcards;
                this.withIgnoreUnavailable(indicesOptions.ignoreUnavailable());
                this.putParam("allow_no_indices", Boolean.toString(indicesOptions.allowNoIndices()));
                if (!indicesOptions.expandWildcardsOpen() && !indicesOptions.expandWildcardsClosed()) {
                    expandWildcards = "none";
                } else {
                    StringJoiner joiner = new StringJoiner(",");
                    if (indicesOptions.expandWildcardsOpen()) {
                        joiner.add("open");
                    }
                    if (indicesOptions.expandWildcardsClosed()) {
                        joiner.add("closed");
                    }
                    expandWildcards = joiner.toString();
                }
                this.putParam("expand_wildcards", expandWildcards);
            }
            return this;
        }

        Params withIgnoreUnavailable(boolean ignoreUnavailable) {
            this.putParam("ignore_unavailable", Boolean.toString(ignoreUnavailable));
            return this;
        }

        Params withHuman(boolean human) {
            if (human) {
                this.putParam("human", Boolean.toString(human));
            }
            return this;
        }

        Params withLocal(boolean local) {
            if (local) {
                this.putParam("local", Boolean.toString(local));
            }
            return this;
        }

        Params withIncludeDefaults(boolean includeDefaults) {
            return includeDefaults ? this.putParam("include_defaults", Boolean.TRUE.toString()) : this;
        }

        Params withPreserveExisting(boolean preserveExisting) {
            return preserveExisting ? this.putParam("preserve_existing", Boolean.TRUE.toString()) : this;
        }

        Params withDetailed(boolean detailed) {
            return detailed ? this.putParam("detailed", Boolean.TRUE.toString()) : this;
        }

        Params withWaitForCompletion(Boolean waitForCompletion) {
            return this.putParam("wait_for_completion", waitForCompletion.toString());
        }

        Params withNodes(String[] nodes) {
            return this.withNodes(Arrays.asList(nodes));
        }

        Params withNodes(List<String> nodes) {
            return nodes != null && nodes.size() > 0 ? this.putParam("nodes", String.join((CharSequence)",", nodes)) : this;
        }

        Params withActions(String[] actions) {
            return this.withActions(Arrays.asList(actions));
        }

        Params withActions(List<String> actions) {
            return actions != null && actions.size() > 0 ? this.putParam("actions", String.join((CharSequence)",", actions)) : this;
        }

        Params withTaskId(TaskId taskId) {
            return taskId != null && taskId.isSet() ? this.putParam("task_id", taskId.toString()) : this;
        }

        Params withParentTaskId(TaskId parentTaskId) {
            return parentTaskId != null && parentTaskId.isSet() ? this.putParam("parent_task_id", parentTaskId.toString()) : this;
        }

        Params withTaskId(org.elasticsearch.client.tasks.TaskId taskId) {
            return taskId != null && taskId.isSet() ? this.putParam("task_id", taskId.toString()) : this;
        }

        Params withParentTaskId(org.elasticsearch.client.tasks.TaskId parentTaskId) {
            return parentTaskId != null && parentTaskId.isSet() ? this.putParam("parent_task_id", parentTaskId.toString()) : this;
        }

        Params withWaitForStatus(ClusterHealthStatus status) {
            return status != null ? this.putParam("wait_for_status", status.name().toLowerCase(Locale.ROOT)) : this;
        }

        Params withWaitForNoRelocatingShards(boolean waitNoRelocatingShards) {
            return waitNoRelocatingShards ? this.putParam("wait_for_no_relocating_shards", Boolean.TRUE.toString()) : this;
        }

        Params withWaitForNoInitializingShards(boolean waitNoInitShards) {
            return waitNoInitShards ? this.putParam("wait_for_no_initializing_shards", Boolean.TRUE.toString()) : this;
        }

        Params withWaitForNodes(String waitForNodes) {
            return this.putParam("wait_for_nodes", waitForNodes);
        }

        Params withWaitForEvents(Priority waitForEvents) {
            return waitForEvents != null ? this.putParam("wait_for_events", waitForEvents.name().toLowerCase(Locale.ROOT)) : this;
        }
    }
}

