/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.core.client;

import com.xphsc.elasticsearch.core.client.IndicesRequestConvertersBuilder;
import com.xphsc.elasticsearch.core.client.RequestConvertersBuilder;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.cache.clear.ClearIndicesCacheRequest;
import org.elasticsearch.action.admin.indices.cache.clear.ClearIndicesCacheResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.flush.FlushRequest;
import org.elasticsearch.action.admin.indices.flush.FlushResponse;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.open.OpenIndexRequest;
import org.elasticsearch.action.admin.indices.open.OpenIndexResponse;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Cancellable;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.client.indices.CloseIndexRequest;
import org.elasticsearch.client.indices.CloseIndexResponse;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.common.CheckedFunction;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;

public class RestHighLevelClientBulider
extends RestHighLevelClient {
    RestClientBuilder restClientBuilder;

    public RestHighLevelClientBulider(RestClientBuilder restClientBuilder) {
        super(restClientBuilder);
        this.restClientBuilder = restClientBuilder;
    }

    protected RestHighLevelClientBulider(RestClientBuilder restClientBuilder, List<NamedXContentRegistry.Entry> namedXContentEntries) {
        super(restClientBuilder, namedXContentEntries);
    }

    @Deprecated
    public final SearchResponse searchBuilder(SearchRequest searchRequest, RequestOptions options) throws IOException {
        return (SearchResponse)this.performRequestAndParseEntity((ActionRequest)searchRequest, r -> RequestConvertersBuilder.search((SearchRequest)r, "_search"), options, SearchResponse::fromXContent, Collections.emptySet());
    }

    public final SearchResponse searchFor(SearchRequest searchRequest, RequestOptions options) throws IOException {
        return (SearchResponse)this.performRequestAndParseEntity((ActionRequest)searchRequest, r -> RequestConvertersBuilder.search((SearchRequest)r, "_search"), options, SearchResponse::fromXContent, Collections.emptySet());
    }

    public final SearchResponse searchFor(SearchRequest searchRequest) throws IOException {
        return (SearchResponse)this.performRequestAndParseEntity((ActionRequest)searchRequest, r -> RequestConvertersBuilder.search((SearchRequest)r, "_search"), RequestOptions.DEFAULT, SearchResponse::fromXContent, Collections.emptySet());
    }

    public final Cancellable searchForAsync(SearchRequest searchRequest, RequestOptions options, ActionListener<SearchResponse> listener) {
        return this.performRequestAsyncAndParseEntity((ActionRequest)searchRequest, r -> RequestConvertersBuilder.search((SearchRequest)r, "_search"), options, SearchResponse::fromXContent, listener, Collections.emptySet());
    }

    public final SearchResponse scrollFor(SearchScrollRequest searchScrollRequest, RequestOptions options) throws IOException {
        return (SearchResponse)this.performRequestAndParseEntity((ActionRequest)searchScrollRequest, RequestConvertersBuilder::searchScroll, options, SearchResponse::fromXContent, Collections.emptySet());
    }

    public final SearchResponse scrollFor(SearchScrollRequest searchScrollRequest) throws IOException {
        return (SearchResponse)this.performRequestAndParseEntity((ActionRequest)searchScrollRequest, RequestConvertersBuilder::searchScroll, RequestOptions.DEFAULT, SearchResponse::fromXContent, Collections.emptySet());
    }

    public boolean existsFor(GetIndexRequest request, RequestOptions options) throws IOException {
        return (Boolean)this.performRequest((ActionRequest)request, IndicesRequestConvertersBuilder::indicesExist, options, RestHighLevelClient::convertExistsResponse, Collections.emptySet());
    }

    public CreateIndexResponse createFor(org.elasticsearch.action.admin.indices.create.CreateIndexRequest createIndexRequest, RequestOptions options) throws IOException {
        return (CreateIndexResponse)this.performRequestAndParseEntity((ActionRequest)createIndexRequest, IndicesRequestConvertersBuilder::createIndex, options, CreateIndexResponse::fromXContent, Collections.emptySet());
    }

    public org.elasticsearch.client.indices.CreateIndexResponse createFor(CreateIndexRequest createIndexRequest, RequestOptions options) throws IOException {
        return (org.elasticsearch.client.indices.CreateIndexResponse)this.performRequestAndParseEntity((Validatable)createIndexRequest, IndicesRequestConvertersBuilder::createIndex, options, org.elasticsearch.client.indices.CreateIndexResponse::fromXContent, Collections.emptySet());
    }

    public final BulkResponse bulkFor(BulkRequest bulkRequest, RequestOptions options) throws IOException {
        return (BulkResponse)this.performRequestAndParseEntityFor(bulkRequest, RequestConvertersBuilder::bulk, options, BulkResponse::fromXContent, Collections.emptySet());
    }

    public RefreshResponse refreshFor(RefreshRequest refreshRequest, RequestOptions options) throws IOException {
        return (RefreshResponse)this.performRequestAndParseEntity((ActionRequest)refreshRequest, IndicesRequestConvertersBuilder::refresh, options, RefreshResponse::fromXContent, Collections.emptySet());
    }

    public AcknowledgedResponse deleteFor(DeleteIndexRequest deleteIndexRequest, RequestOptions options) throws IOException {
        return (AcknowledgedResponse)this.performRequestAndParseEntity((ActionRequest)deleteIndexRequest, IndicesRequestConvertersBuilder::deleteIndex, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public AcknowledgedResponse putMappingFor(PutMappingRequest putMappingRequest, RequestOptions options) throws IOException {
        return (AcknowledgedResponse)this.performRequestAndParseEntity((ActionRequest)putMappingRequest, IndicesRequestConvertersBuilder::putMapping, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public AcknowledgedResponse putMappingFor(org.elasticsearch.client.indices.PutMappingRequest putMappingRequest, RequestOptions options) throws IOException {
        return (AcknowledgedResponse)this.performRequestAndParseEntity((Validatable)putMappingRequest, IndicesRequestConvertersBuilder::putMapping, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public AcknowledgedResponse putSettingsFor(UpdateSettingsRequest updateSettingsRequest, RequestOptions options) throws IOException {
        return (AcknowledgedResponse)this.performRequestAndParseEntity((ActionRequest)updateSettingsRequest, IndicesRequestConvertersBuilder::indexPutSettings, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public boolean existsAliasFor(GetAliasesRequest getAliasesRequest, RequestOptions options) throws IOException {
        return (Boolean)this.performRequest((ActionRequest)getAliasesRequest, IndicesRequestConvertersBuilder::existsAlias, options, RestHighLevelClient::convertExistsResponse, Collections.emptySet());
    }

    public OpenIndexResponse openFor(OpenIndexRequest openIndexRequest, RequestOptions options) throws IOException {
        return (OpenIndexResponse)this.performRequestAndParseEntity((ActionRequest)openIndexRequest, IndicesRequestConvertersBuilder::openIndex, options, OpenIndexResponse::fromXContent, Collections.emptySet());
    }

    public CloseIndexResponse closeFor(CloseIndexRequest closeIndexRequest, RequestOptions options) throws IOException {
        return (CloseIndexResponse)this.performRequestAndParseEntity((Validatable)closeIndexRequest, IndicesRequestConvertersBuilder::closeIndex, options, CloseIndexResponse::fromXContent, Collections.emptySet());
    }

    public ClearIndicesCacheResponse clearCacheFor(ClearIndicesCacheRequest clearIndicesCacheRequest, RequestOptions options) throws IOException {
        return (ClearIndicesCacheResponse)this.performRequestAndParseEntity((ActionRequest)clearIndicesCacheRequest, IndicesRequestConvertersBuilder::clearCache, options, ClearIndicesCacheResponse::fromXContent, Collections.emptySet());
    }

    public FlushResponse flushFor(FlushRequest flushRequest, RequestOptions options) throws IOException {
        return (FlushResponse)this.performRequestAndParseEntity((ActionRequest)flushRequest, IndicesRequestConvertersBuilder::flush, options, FlushResponse::fromXContent, Collections.emptySet());
    }

    protected final <Req extends ActionRequest, Resp> Resp performRequestAndParseEntityFor(Req request, CheckedFunction<Req, Request, IOException> requestConverter, RequestOptions options, CheckedFunction<XContentParser, Resp, IOException> entityParser, Set<Integer> ignores) throws IOException {
        return this.performRequestFor(request, requestConverter, options, response -> this.parseEntity(response.getEntity(), entityParser), ignores);
    }

    protected final <Req extends ActionRequest, Resp> Resp performRequestFor(Req request, CheckedFunction<Req, Request, IOException> requestConverter, RequestOptions options, CheckedFunction<Response, Resp, IOException> responseConverter, Set<Integer> ignores) throws IOException {
        ActionRequestValidationException validationException = request.validate();
        if (validationException != null && !validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return this.internalPerformRequestFor(request, requestConverter, options, responseConverter, ignores);
    }

    private <Req, Resp> Resp internalPerformRequestFor(Req request, CheckedFunction<Req, Request, IOException> requestConverter, RequestOptions options, CheckedFunction<Response, Resp, IOException> responseConverter, Set<Integer> ignores) throws IOException {
        Response response;
        Request req = (Request)requestConverter.apply(request);
        req.setOptions(options);
        try {
            response = this.getLowLevelClient().performRequest(req);
        }
        catch (ResponseException var12) {
            ResponseException e = var12;
            if (ignores.contains(var12.getResponse().getStatusLine().getStatusCode())) {
                try {
                    return (Resp)responseConverter.apply((Object)e.getResponse());
                }
                catch (Exception var10) {
                    throw this.parseResponseException(var12);
                }
            }
            throw this.parseResponseException(var12);
        }
        try {
            return (Resp)responseConverter.apply((Object)response);
        }
        catch (Exception var11) {
            throw new IOException("Unable to parse response body for " + response, var11);
        }
    }
}

