/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.core.entity;

import com.xphsc.elasticsearch.core.exception.ElasticsearchException;
import com.xphsc.elasticsearch.core.lambda.LambdaFunction;
import com.xphsc.elasticsearch.core.lambda.Reflections;
import com.xphsc.elasticsearch.util.Collects;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Sort {
    private List<Order> orders;
    public static final Direction DEFAULT_DIRECTION = Direction.ASC;

    public Sort() {
    }

    public Sort(List<Order> orders) {
        if (Collects.isEmpty(orders)) {
            throw new ElasticsearchException("You have to provide at least one sort property to sort by!");
        }
        this.orders = orders;
    }

    public Sort(Direction direction, String property) {
        Order order = new Order(direction, property);
        this.orders = new ArrayList<Order>();
        this.orders.add(order);
    }

    public <T> Sort addSort(Order ... orders) {
        this.orders = new ArrayList<Order>();
        for (Order order : orders) {
            this.orders.add(order);
        }
        return this;
    }

    public <T> Sort addSort(Direction direction, LambdaFunction<T, Object> property) {
        Order order = new Order(direction, Reflections.fieldNameForLambdaFunction(property));
        this.orders = new ArrayList<Order>();
        this.orders.add(order);
        return this;
    }

    public List<Order> getOrders() {
        return this.orders;
    }

    public static Direction getDefaultDirection() {
        return DEFAULT_DIRECTION;
    }

    public static enum Direction {
        ASC,
        DESC;

    }

    public static class Order<T>
    implements Serializable {
        private Direction direction;
        private String property;

        public Order(Direction direction, String property) {
            this.direction = direction;
            this.property = property;
        }

        public Order(Direction direction, LambdaFunction<T, Object> property) {
            this.direction = direction;
            this.property = Reflections.fieldNameForLambdaFunction(property);
        }

        public Direction getDirection() {
            return this.direction;
        }

        public String getProperty() {
            return this.property;
        }
    }
}

