/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.core.entity.aggregate;

import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;

public class DateHistogramEntity {
    private String name;
    private String field;
    private DateHistogramInterval dateHistogramInterval;
    private String format;
    private long interval;
    private long offset = 0L;
    private BucketOrder order = BucketOrder.key((boolean)true);
    private boolean keyed = false;
    private long minDocCount = 0L;
    private DateHistogramInterval fixedInterval;

    private DateHistogramEntity(Builder builder) {
        this.name = builder.name;
        this.field = builder.field;
        this.dateHistogramInterval = builder.dateHistogramInterval;
        this.format = builder.format;
        this.interval = builder.interval;
        this.offset = builder.offset;
        this.order = builder.order;
        this.keyed = builder.keyed;
        this.minDocCount = builder.minDocCount;
        this.fixedInterval = builder.fixedInterval;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public BucketOrder getOrder() {
        return this.order;
    }

    public void setOrder(BucketOrder order) {
        this.order = order;
    }

    public boolean isKeyed() {
        return this.keyed;
    }

    public void setKeyed(boolean keyed) {
        this.keyed = keyed;
    }

    public long getMinDocCount() {
        return this.minDocCount;
    }

    public void setMinDocCount(long minDocCount) {
        this.minDocCount = minDocCount;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public DateHistogramInterval getDateHistogramInterval() {
        return this.dateHistogramInterval;
    }

    public void setDateHistogramInterval(DateHistogramInterval dateHistogramInterval) {
        this.dateHistogramInterval = dateHistogramInterval;
    }

    public DateHistogramInterval getFixedInterval() {
        return this.fixedInterval;
    }

    public void setFixedInterval(DateHistogramInterval fixedInterval) {
        this.fixedInterval = fixedInterval;
    }

    public String toString() {
        return "DateHistogramEntity{name='" + this.name + '\'' + ", field='" + this.field + '\'' + ", dateHistogramInterval=" + this.dateHistogramInterval + ", format='" + this.format + '\'' + ", interval=" + this.interval + ", offset=" + this.offset + ", order=" + this.order + ", keyed=" + this.keyed + ", minDocCount=" + this.minDocCount + ", fixedInterval=" + this.fixedInterval + '}';
    }

    public static class Builder {
        private String name;
        private String field;
        private DateHistogramInterval dateHistogramInterval;
        private String format;
        private long interval;
        private long offset = 0L;
        private BucketOrder order = BucketOrder.key((boolean)true);
        private boolean keyed = false;
        private long minDocCount = 0L;
        private DateHistogramInterval fixedInterval;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder field(String field) {
            this.field = field;
            return this;
        }

        public Builder dateHistogramInterval(DateHistogramInterval dateHistogramInterval) {
            this.dateHistogramInterval = dateHistogramInterval;
            return this;
        }

        public Builder format(String format) {
            this.format = format;
            return this;
        }

        public Builder interval(long interval) {
            this.interval = interval;
            return this;
        }

        public Builder offset(long offset) {
            this.offset = offset;
            return this;
        }

        public Builder bucketOrder(BucketOrder order) {
            this.order = order;
            return this;
        }

        public Builder keyed(boolean keyed) {
            this.keyed = keyed;
            return this;
        }

        public Builder minDocCount(long minDocCount) {
            this.minDocCount = minDocCount;
            return this;
        }

        public Builder fixedInterval(DateHistogramInterval fixedInterval) {
            this.fixedInterval = fixedInterval;
            return this;
        }

        public DateHistogramEntity build() {
            return new DateHistogramEntity(this);
        }
    }
}

