/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.core.entity.cluster;

import com.alibaba.fastjson.JSON;
import com.carrotsearch.hppc.ObjectIntHashMap;
import com.xphsc.elasticsearch.core.entity.monitor.OsStats;
import com.xphsc.elasticsearch.util.Collects;
import com.xphsc.elasticsearch.util.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;

public class ClusterStatsNodesInfo {
    private long timestamp;
    private Os os;
    private Process process;
    private Jvm jvm;
    private FsInfo fsInfo;
    private HttpStats httpStats;

    public ClusterStatsNodesInfo(Os os, Process process, Jvm jvm, FsInfo fsInfo, long timestamp, HttpStats httpStats) {
        this.os = os;
        this.process = process;
        this.jvm = jvm;
        this.fsInfo = fsInfo;
        this.timestamp = timestamp;
        this.httpStats = httpStats;
    }

    public void setOs(Os os) {
        this.os = os;
    }

    public Os getOs() {
        return this.os;
    }

    public Process getProcess() {
        return this.process;
    }

    public void setProcess(Process process) {
        this.process = process;
    }

    public Jvm getJvm() {
        return this.jvm;
    }

    public void setJvm(Jvm jvm) {
        this.jvm = jvm;
    }

    public FsInfo getFsInfo() {
        return this.fsInfo;
    }

    public void setFsInfo(FsInfo fsInfo) {
        this.fsInfo = fsInfo;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public HttpStats getHttpStats() {
        return this.httpStats;
    }

    public void setHttpStats(HttpStats httpStats) {
        this.httpStats = httpStats;
    }

    public static final class HttpStats {
        private final long serverOpen;
        private final long totalOpen;

        public HttpStats(long serverOpen, long totalOpen) {
            this.serverOpen = serverOpen;
            this.totalOpen = totalOpen;
        }

        public HttpStats(StreamInput in) throws IOException {
            this.serverOpen = in.readVLong();
            this.totalOpen = in.readVLong();
        }

        public long getServerOpen() {
            return this.serverOpen;
        }

        public long getTotalOpen() {
            return this.totalOpen;
        }

        public static final class Fields {
            private String http;
            private long current_open;
            private long total_opened;

            public String getHttp() {
                return this.http;
            }

            public void setHttp(String http) {
                this.http = http;
            }

            public long getCurrent_open() {
                return this.current_open;
            }

            public void setCurrent_open(long current_open) {
                this.current_open = current_open;
            }

            public long getTotal_opened() {
                return this.total_opened;
            }

            public void setTotal_opened(long total_opened) {
                this.total_opened = total_opened;
            }
        }
    }

    public static final class Fields {
        private long timestamp;
        String count;
        String versions;
        String os;
        String process;
        String jvm;
        String fs;
        String plugins;
        String network_types;
        String http;
        String threadPool;

        public String getCount() {
            return this.count;
        }

        public void setCount(String count) {
            this.count = count;
        }

        public String getVersions() {
            return this.versions;
        }

        public void setVersions(String versions) {
            this.versions = versions;
        }

        public String getOs() {
            return this.os;
        }

        public void setOs(String os) {
            this.os = os;
        }

        public String getProcess() {
            return this.process;
        }

        public void setProcess(String process) {
            this.process = process;
        }

        public String getJvm() {
            return this.jvm;
        }

        public void setJvm(String jvm) {
            this.jvm = jvm;
        }

        public String getFs() {
            return this.fs;
        }

        public void setFs(String fs) {
            this.fs = fs;
        }

        public String getPlugins() {
            return this.plugins;
        }

        public void setPlugins(String plugins) {
            this.plugins = plugins;
        }

        public String getNetwork_types() {
            return this.network_types;
        }

        public void setNetwork_types(String network_types) {
            this.network_types = network_types;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public String getHttp() {
            return this.http;
        }

        public void setHttp(String http) {
            this.http = http;
        }

        public String getThreadPool() {
            return this.threadPool;
        }

        public void setThreadPool(String threadPool) {
            this.threadPool = threadPool;
        }
    }

    public static final class FsInfo {
        private String total;
        private long totalInBytes;
        private String free;
        private long freeInBytes;
        private String available;
        private long availableInBytes;

        public FsInfo() {
        }

        public FsInfo(String total, long totalInBytes, String free, long freeInBytes, String available, long availableInBytes) {
            this.total = total;
            this.totalInBytes = totalInBytes;
            this.free = free;
            this.freeInBytes = freeInBytes;
            this.available = available;
            this.availableInBytes = availableInBytes;
        }

        public String getTotal() {
            return this.total;
        }

        public void setTotal(String total) {
            this.total = total;
        }

        public long getTotalInBytes() {
            return this.totalInBytes;
        }

        public void setTotalInBytes(long totalInBytes) {
            this.totalInBytes = totalInBytes;
        }

        public String getFree() {
            return this.free;
        }

        public void setFree(String free) {
            this.free = free;
        }

        public long getFreeInBytes() {
            return this.freeInBytes;
        }

        public void setFreeInBytes(long freeInBytes) {
            this.freeInBytes = freeInBytes;
        }

        public String getAvailable() {
            return this.available;
        }

        public void setAvailable(String available) {
            this.available = available;
        }

        public long getAvailableInBytes() {
            return this.availableInBytes;
        }

        public void setAvailableInBytes(long availableInBytes) {
            this.availableInBytes = availableInBytes;
        }

        public static final class Fields {
            private String total;
            private long total_in_bytes;
            private String free;
            private long free_inBytes;
            private String available;
            private long available_in_bytes;

            public String getTotal() {
                return this.total;
            }

            public void setTotal(String total) {
                this.total = total;
            }

            public long getTotal_in_bytes() {
                return this.total_in_bytes;
            }

            public void setTotal_in_bytes(long total_in_bytes) {
                this.total_in_bytes = total_in_bytes;
            }

            public String getFree() {
                return this.free;
            }

            public void setFree(String free) {
                this.free = free;
            }

            public long getFree_inBytes() {
                return this.free_inBytes;
            }

            public void setFree_inBytes(long free_inBytes) {
                this.free_inBytes = free_inBytes;
            }

            public String getAvailable() {
                return this.available;
            }

            public void setAvailable(String available) {
                this.available = available;
            }

            public long getAvailable_in_bytes() {
                return this.available_in_bytes;
            }

            public void setAvailable_in_bytes(long available_in_bytes) {
                this.available_in_bytes = available_in_bytes;
            }
        }
    }

    public static final class Process {
        int count;
        int cpuPercent;
        long totalOpenFileDescriptors = 0L;
        long minOpenFileDescriptors = 0L;
        long maxOpenFileDescriptors = 0L;

        public Process(Fields cpufields, Fields openFilefields) {
            int count = 0;
            int cpuPercent = 0;
            long totalOpenFileDescriptors = 0L;
            long minOpenFileDescriptors = Long.MAX_VALUE;
            long maxOpenFileDescriptors = Long.MIN_VALUE;
            ++count;
            if (cpufields.cpu != null) {
                cpuPercent += cpufields.percent;
            }
            this.count = count;
            this.cpuPercent = cpuPercent;
            this.totalOpenFileDescriptors = openFilefields.getAvg();
            this.minOpenFileDescriptors = openFilefields.getMin();
            this.maxOpenFileDescriptors = openFilefields.getMax();
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public int getCpuPercent() {
            return this.cpuPercent;
        }

        public void setCpuPercent(int cpuPercent) {
            this.cpuPercent = cpuPercent;
        }

        public long getTotalOpenFileDescriptors() {
            return this.totalOpenFileDescriptors;
        }

        public void setTotalOpenFileDescriptors(long totalOpenFileDescriptors) {
            this.totalOpenFileDescriptors = totalOpenFileDescriptors;
        }

        public long getMinOpenFileDescriptors() {
            return this.minOpenFileDescriptors;
        }

        public void setMinOpenFileDescriptors(long minOpenFileDescriptors) {
            this.minOpenFileDescriptors = minOpenFileDescriptors;
        }

        public long getMaxOpenFileDescriptors() {
            return this.maxOpenFileDescriptors;
        }

        public void setMaxOpenFileDescriptors(long maxOpenFileDescriptors) {
            this.maxOpenFileDescriptors = maxOpenFileDescriptors;
        }

        public static final class Fields {
            String cpu;
            int percent;
            String open_file_descriptors;
            int min;
            int max;
            int avg;

            public String getCpu() {
                return this.cpu;
            }

            public void setCpu(String cpu) {
                this.cpu = cpu;
            }

            public int getPercent() {
                return this.percent;
            }

            public void setPercent(int percent) {
                this.percent = percent;
            }

            public String getOpen_file_descriptors() {
                return this.open_file_descriptors;
            }

            public void setOpen_file_descriptors(String open_file_descriptors) {
                this.open_file_descriptors = open_file_descriptors;
            }

            public int getMin() {
                return this.min;
            }

            public void setMin(int min) {
                this.min = min;
            }

            public int getMax() {
                return this.max;
            }

            public void setMax(int max) {
                this.max = max;
            }

            public int getAvg() {
                return this.avg;
            }

            public void setAvg(int avg) {
                this.avg = avg;
            }
        }
    }

    public static final class Jvm {
        private ObjectIntHashMap<JvmVersion> versions = new ObjectIntHashMap();
        private long threads;
        private long maxUptimeInMillis;
        private String maxUptime;
        private String heapUsed;
        private String heapMax;
        private long heapUsedInBytes;
        private long heapMaxInBytes;

        public Jvm(Fields fields, Fields memfields, List<JvmVersion> jvmVersions) {
            if (Collects.isNotEmpty(jvmVersions)) {
                for (JvmVersion jvmVersion : jvmVersions) {
                    this.versions.addTo((Object)jvmVersion, 1);
                }
            }
            this.threads = fields.getThreads();
            this.maxUptime = fields.max_uptime;
            this.maxUptimeInMillis = fields.max_uptime_in_millis;
            this.heapUsedInBytes = memfields.heap_used_in_bytes;
            this.heapMaxInBytes = memfields.heap_max_in_bytes;
            this.heapUsed = memfields.heap_used;
            this.heapMax = memfields.heap_max;
        }

        public ObjectIntHashMap<JvmVersion> getVersions() {
            return this.versions;
        }

        public void setVersions(ObjectIntHashMap<JvmVersion> versions) {
            this.versions = versions;
        }

        public long getThreads() {
            return this.threads;
        }

        public void setThreads(long threads) {
            this.threads = threads;
        }

        public long getMaxUptimeInMillis() {
            return this.maxUptimeInMillis;
        }

        public void setMaxUptimeInMillis(long maxUptimeInMillis) {
            this.maxUptimeInMillis = maxUptimeInMillis;
        }

        public String getMaxUptime() {
            return this.maxUptime;
        }

        public void setMaxUptime(String maxUptime) {
            this.maxUptime = maxUptime;
        }

        public String getHeapUsed() {
            return this.heapUsed;
        }

        public void setHeapUsed(String heapUsed) {
            this.heapUsed = heapUsed;
        }

        public String getHeapMax() {
            return this.heapMax;
        }

        public void setHeapMax(String heapMax) {
            this.heapMax = heapMax;
        }

        public long getHeapUsedInBytes() {
            return this.heapUsedInBytes;
        }

        public void setHeapUsedInBytes(long heapUsedInBytes) {
            this.heapUsedInBytes = heapUsedInBytes;
        }

        public long getHeapMaxInBytes() {
            return this.heapMaxInBytes;
        }

        public void setHeapMaxInBytes(long heapMaxInBytes) {
            this.heapMaxInBytes = heapMaxInBytes;
        }

        public static class JvmVersion {
            String version;
            String vmName;
            String vmVersion;
            String vmVendor;

            public String getVersion() {
                return this.version;
            }

            public void setVersion(String version) {
                this.version = version;
            }

            public String getVmName() {
                return this.vmName;
            }

            public void setVmName(String vmName) {
                this.vmName = vmName;
            }

            public String getVmVersion() {
                return this.vmVersion;
            }

            public void setVmVersion(String vmVersion) {
                this.vmVersion = vmVersion;
            }

            public String getVmVendor() {
                return this.vmVendor;
            }

            public void setVmVendor(String vmVendor) {
                this.vmVendor = vmVendor;
            }
        }

        public static class Fields {
            private String versions;
            private String version;
            private String vm_name;
            private String vm_version;
            private String vm_vendor;
            private String threads;
            private String max_uptime;
            private long max_uptime_in_millis;
            private String mem;
            private String heap_used;
            private long heap_used_in_bytes;
            private String heap_max;
            private long heap_max_in_bytes;

            public String getVersions() {
                return this.versions;
            }

            public void setVersions(String versions) {
                this.versions = versions;
            }

            public String getVersion() {
                return this.version;
            }

            public void setVersion(String version) {
                this.version = version;
            }

            public String getVm_name() {
                return this.vm_name;
            }

            public void setVm_name(String vm_name) {
                this.vm_name = vm_name;
            }

            public String getVm_version() {
                return this.vm_version;
            }

            public void setVm_version(String vm_version) {
                this.vm_version = vm_version;
            }

            public String getVm_vendor() {
                return this.vm_vendor;
            }

            public void setVm_vendor(String vm_vendor) {
                this.vm_vendor = vm_vendor;
            }

            public long getThreads() {
                Map mapThreads = new HashMap(2);
                if (this.threads.contains("{")) {
                    mapThreads = (Map)JSON.parseObject((String)this.threads, Map.class);
                }
                return mapThreads.get("count") != null ? Long.valueOf(mapThreads.get("count").toString()) : Long.valueOf(this.threads);
            }

            public void setThreads(String threads) {
                this.threads = threads;
            }

            public String getMax_uptime() {
                return this.max_uptime;
            }

            public void setMax_uptime(String max_uptime) {
                this.max_uptime = max_uptime;
            }

            public long getMax_uptime_in_millis() {
                return this.max_uptime_in_millis;
            }

            public void setMax_uptime_in_millis(long max_uptime_in_millis) {
                this.max_uptime_in_millis = max_uptime_in_millis;
            }

            public String getMem() {
                return this.mem;
            }

            public void setMem(String mem) {
                this.mem = mem;
            }

            public String getHeap_used() {
                return this.heap_used;
            }

            public void setHeap_used(String heap_used) {
                this.heap_used = heap_used;
            }

            public long getHeap_used_in_bytes() {
                return this.heap_used_in_bytes;
            }

            public void setHeap_used_in_bytes(long heap_used_in_bytes) {
                this.heap_used_in_bytes = heap_used_in_bytes;
            }

            public String getHeap_max() {
                return this.heap_max;
            }

            public void setHeap_max(String heap_max) {
                this.heap_max = heap_max;
            }

            public long getHeap_max_in_bytes() {
                return this.heap_max_in_bytes;
            }

            public void setHeap_max_in_bytes(long heap_max_in_bytes) {
                this.heap_max_in_bytes = heap_max_in_bytes;
            }
        }
    }

    public static final class Os {
        private int availableProcessors;
        private int allocatedProcessors;
        private List<Names> names;
        private OsStats.MemInfo mem;

        public int getAvailableProcessors() {
            return this.availableProcessors;
        }

        public void setAvailableProcessors(int availableProcessors) {
            this.availableProcessors = availableProcessors;
        }

        public int getAllocatedProcessors() {
            return this.allocatedProcessors;
        }

        public void setAllocatedProcessors(int allocatedProcessors) {
            this.allocatedProcessors = allocatedProcessors;
        }

        public List<Names> getNames() {
            return this.names;
        }

        public void setNames(List<Names> names) {
            this.names = names;
        }

        public OsStats.MemInfo getMem() {
            return this.mem;
        }

        public void setMem(OsStats.MemInfo mem) {
            this.mem = mem;
        }

        public Os(Fields fields, OsStats.MemInfo memInfo) {
            List<Names> namesList = new ArrayList<Names>(2);
            if (Strings.isNotEmpty(fields.names)) {
                namesList = JSON.parseArray((String)fields.names, Names.class);
            }
            this.names = namesList;
            this.availableProcessors = fields.available_processors;
            this.allocatedProcessors = fields.allocated_processors;
            this.mem = memInfo;
        }

        public static class Fields {
            private int available_processors;
            private int allocated_processors;
            private String name;
            private String names;
            private int count;
            private String mem;

            public int getAvailable_processors() {
                return this.available_processors;
            }

            public void setAvailable_processors(int available_processors) {
                this.available_processors = available_processors;
            }

            public int getAllocated_processors() {
                return this.allocated_processors;
            }

            public void setAllocated_processors(int allocated_processors) {
                this.allocated_processors = allocated_processors;
            }

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public String getNames() {
                return this.names;
            }

            public void setNames(String names) {
                this.names = names;
            }

            public int getCount() {
                return this.count;
            }

            public void setCount(int count) {
                this.count = count;
            }

            public String getMem() {
                return this.mem;
            }

            public void setMem(String mem) {
                this.mem = mem;
            }
        }

        public static class Names {
            private String name;
            private int count;

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public int getCount() {
                return this.count;
            }

            public void setCount(int count) {
                this.count = count;
            }

            public String toString() {
                return "Names{name='" + this.name + '\'' + ", count=" + this.count + '}';
            }
        }
    }
}

