/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.core.executor;

import com.xphsc.elasticsearch.core.client.RestHighLevelClientBulider;
import com.xphsc.elasticsearch.core.exception.ElasticsearchException;
import com.xphsc.elasticsearch.core.executor.Executor;
import com.xphsc.elasticsearch.core.lambda.LambdaSupplier;
import com.xphsc.elasticsearch.util.Strings;
import java.io.IOException;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.common.unit.TimeValue;

public abstract class AbstractExecutor<T>
implements Executor<T> {
    protected final RestHighLevelClientBulider client;
    protected long requestRimeout = 1L;

    protected AbstractExecutor(LambdaSupplier<RestHighLevelClientBulider> client) {
        this.client = (RestHighLevelClientBulider)((Object)client.get());
    }

    @Override
    public T execute() throws ElasticsearchException {
        return this.doExecute();
    }

    protected abstract T doExecute() throws ElasticsearchException;

    protected boolean indexExist(String indexName) {
        String newIndexName = "";
        if (Strings.isNotBlank(indexName)) {
            newIndexName = indexName;
        }
        GetIndexRequest request = new GetIndexRequest();
        request.indices(new String[]{newIndexName});
        request.masterNodeTimeout(TimeValue.timeValueMinutes((long)this.requestRimeout));
        boolean exists = false;
        try {
            exists = this.client.existsFor(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return exists;
    }

    protected RestHighLevelClientBulider getClient() {
        return this.client;
    }
}

