/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.core.executor;

import com.xphsc.elasticsearch.core.client.RestHighLevelClientBulider;
import com.xphsc.elasticsearch.core.exception.ElasticsearchException;
import com.xphsc.elasticsearch.core.executor.AbstractExecutor;
import com.xphsc.elasticsearch.core.lambda.LambdaSupplier;
import com.xphsc.elasticsearch.util.Strings;
import java.io.IOException;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.client.RequestOptions;

public class AliasExecutor
extends AbstractExecutor<Object> {
    private String indexName;
    private String alias;
    private String aliasType;

    public AliasExecutor(LambdaSupplier<RestHighLevelClientBulider> client, String indexName, String alias) {
        super(client);
        this.indexName = indexName;
        this.alias = alias;
    }

    public AliasExecutor(LambdaSupplier<RestHighLevelClientBulider> client, String indexName, String alias, AliasType aliasType) {
        super(client);
        this.indexName = indexName;
        this.alias = alias;
        this.aliasType = aliasType.name();
    }

    @Override
    protected Object doExecute() throws ElasticsearchException {
        if (Strings.isNotBlank(this.aliasType)) {
            if (this.aliasType.equals(AliasType.ADD.toString()) || this.aliasType.equals(AliasType.REMOVE.toString())) {
                IndicesAliasesRequest indicesAliasesRequest = new IndicesAliasesRequest();
                IndicesAliasesRequest.AliasActions aliasAction = null;
                if (this.aliasType.equals(AliasType.ADD.toString())) {
                    aliasAction = new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.ADD);
                }
                if (this.aliasType.equals(AliasType.REMOVE.toString())) {
                    aliasAction = new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.REMOVE);
                }
                aliasAction.indices(new String[]{this.indexName});
                aliasAction.alias(this.alias);
                indicesAliasesRequest.addAliasAction(aliasAction);
                try {
                    return this.client.indices().updateAliases(indicesAliasesRequest, RequestOptions.DEFAULT).isAcknowledged();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (this.aliasType.equals(AliasType.GET.toString())) {
                GetAliasesRequest getAliasesRequest = new GetAliasesRequest();
                getAliasesRequest.indices(new String[]{this.indexName});
                try {
                    return this.client.indices().getAlias(getAliasesRequest, RequestOptions.DEFAULT).getAliases();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            GetAliasesRequest aliasesRequest = new GetAliasesRequest();
            aliasesRequest.indices(new String[]{this.indexName});
            aliasesRequest.aliases(new String[]{this.alias});
            try {
                return this.client.existsAliasFor(aliasesRequest, RequestOptions.DEFAULT);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static enum AliasType {
        ADD,
        REMOVE,
        REMOVE_INDEX,
        GET;

        private String name;

        private AliasType() {
        }

        private AliasType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

