/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.core.executor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xphsc.elasticsearch.core.client.RestHighLevelClientBulider;
import com.xphsc.elasticsearch.core.entity.cluster.ClusterHealth;
import com.xphsc.elasticsearch.core.entity.cluster.ClusterStatsNodesInfo;
import com.xphsc.elasticsearch.core.entity.monitor.OsStats;
import com.xphsc.elasticsearch.core.exception.ElasticsearchException;
import com.xphsc.elasticsearch.core.executor.AbstractExecutor;
import com.xphsc.elasticsearch.core.lambda.LambdaSupplier;
import com.xphsc.elasticsearch.util.Elasticsearchs;
import com.xphsc.elasticsearch.util.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;

public class ClusterNodesExecutor
extends AbstractExecutor<Object> {
    private String method;
    private String endpoint;
    private String indices;
    private String indexMode;

    public ClusterNodesExecutor(LambdaSupplier<RestHighLevelClientBulider> client, String indices, IndexMode indexMode) {
        super(client);
        this.indices = indices;
        this.indexMode = indexMode.name();
    }

    public ClusterNodesExecutor(LambdaSupplier<RestHighLevelClientBulider> client, IndexMode indexMode) {
        super(client);
        this.indexMode = indexMode.name();
    }

    @Override
    protected Object doExecute() throws ElasticsearchException {
        Object result = null;
        if (Strings.isNotBlank(this.indexMode)) {
            String[] catNodes;
            String[] stringArray;
            int n;
            int n2;
            Request request;
            Response response;
            if (this.indexMode.equals(IndexMode.STATUS.toString())) {
                String[] strings;
                this.method = "GET";
                this.endpoint = "/_cat/indices?index=" + this.indices;
                response = null;
                try {
                    request = new Request(this.method, this.endpoint);
                    request.addParameters(Collections.emptyMap());
                    response = this.client.getLowLevelClient().performRequest(request);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                String responseEntity = Elasticsearchs.responseEntity(response);
                for (String s : strings = Strings.splitByWholeSeparator(responseEntity, "")) {
                    if (s.contains(IndexStatus.OPEN.getName())) {
                        result = IndexStatus.OPEN.getName();
                        continue;
                    }
                    if (!s.contains(IndexStatus.CLOSE.getName())) continue;
                    result = IndexStatus.CLOSE.getName();
                }
            }
            if (this.indexMode.equals(IndexMode.INDICES.toString())) {
                String[] strings;
                this.method = "GET";
                this.endpoint = "/_cat/indices?index";
                response = null;
                try {
                    request = new Request(this.method, this.endpoint);
                    request.addParameters(Collections.emptyMap());
                    response = this.client.getLowLevelClient().performRequest(request);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ArrayList<String> indicesName = new ArrayList<String>();
                String responseEntity = Elasticsearchs.responseEntity(response);
                for (String s : strings = Strings.splitByWholeSeparator(responseEntity, "")) {
                    if (!s.contains(this.indices)) continue;
                    indicesName.add(s);
                }
                result = indicesName;
            }
            if (this.indexMode.equals(IndexMode.MAPPING.toString())) {
                this.method = "GET";
                this.endpoint = "/" + this.indices + "/_mapping";
                result = this.response(this.indices);
            }
            if (this.indexMode.equals(IndexMode.SETTING.toString())) {
                this.method = "GET";
                this.endpoint = "/" + this.indices + "/_settings";
                result = this.response(this.indices);
            }
            if (this.indexMode.equals(IndexMode.CLUSTER_HEALTH.toString())) {
                this.method = "GET";
                this.endpoint = "_cluster/health?pretty=true";
                result = this.response(null);
                ClusterHealth clusterHealth = (ClusterHealth)JSONObject.parseObject((String)Strings.toCamelCase(result.toString()), ClusterHealth.class);
                return clusterHealth;
            }
            if (this.indexMode.equals(IndexMode.CLUSTER_STATS.toString())) {
                this.method = "GET";
                this.endpoint = "_cluster/stats?human&pretty";
                result = this.response(null);
                return this.getclusterStatsNodesInfo(result, false);
            }
            if (this.indexMode.equals(IndexMode.NODES.toString()) && (n2 = 0) < (n = (stringArray = (catNodes = this.getCatNodes())).length)) {
                String catNode = stringArray[n2];
                this.method = "GET";
                this.endpoint = "_nodes/" + catNode + "/stats";
                result = this.response(null);
                return this.getclusterStatsNodesInfo(result, true);
            }
        }
        return result;
    }

    private Object response(String params) {
        Object result = null;
        Response response = null;
        try {
            Request request = new Request(this.method, this.endpoint);
            request.addParameters(Collections.emptyMap());
            response = this.client.getLowLevelClient().performRequest(request);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String responseEntity = Elasticsearchs.responseEntity(response);
        JSONObject jsonObject = JSONObject.parseObject((String)responseEntity);
        result = Strings.isNotBlank(params) ? jsonObject.get((Object)params) : jsonObject;
        return result;
    }

    private String[] getCatNodes() {
        String method = "GET";
        String endpoint = "/_cat/nodes?h=ip";
        Response response = null;
        try {
            Request request = new Request(method, endpoint);
            request.addParameters(Collections.emptyMap());
            response = this.client.getLowLevelClient().performRequest(request);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String responseEntity = Elasticsearchs.responseEntity(response);
        String[] strings = Strings.splitByWholeSeparator(responseEntity, "");
        return strings;
    }

    private Object getclusterStatsNodesInfo(Object result, boolean list) {
        ClusterStatsNodesInfo.Fields slusterStatsNodesFields;
        Map clusterStats = null;
        if (list) {
            String node;
            Map clusterNode = (Map)JSONObject.parseObject((String)result.toString(), Map.class);
            Map cluster = (Map)JSON.parseObject((String)clusterNode.get("nodes").toString(), Map.class);
            if (cluster.get(node = Strings.substringAfter(Strings.substringBeforeLast(cluster.toString(), "="), "{")) != null) {
                clusterStats = (Map)JSONObject.parseObject((String)cluster.get(node).toString(), Map.class);
            }
            slusterStatsNodesFields = (ClusterStatsNodesInfo.Fields)JSONObject.parseObject((String)JSON.toJSONString((Object)clusterStats), ClusterStatsNodesInfo.Fields.class);
        } else {
            clusterStats = (Map)JSONObject.parseObject((String)result.toString(), Map.class);
            slusterStatsNodesFields = (ClusterStatsNodesInfo.Fields)JSONObject.parseObject((String)clusterStats.get("nodes").toString(), ClusterStatsNodesInfo.Fields.class);
        }
        long timestamp = 0L;
        if (slusterStatsNodesFields != null) {
            if (slusterStatsNodesFields.getTimestamp() != 0L) {
                timestamp = slusterStatsNodesFields.getTimestamp();
            }
            ClusterStatsNodesInfo.HttpStats.Fields httpField = (ClusterStatsNodesInfo.HttpStats.Fields)JSON.parseObject((String)slusterStatsNodesFields.getHttp(), ClusterStatsNodesInfo.HttpStats.Fields.class);
            ClusterStatsNodesInfo.HttpStats httpStats = null;
            if (httpField != null) {
                httpStats = new ClusterStatsNodesInfo.HttpStats(httpField.getCurrent_open(), httpField.getTotal_opened());
            }
            ClusterStatsNodesInfo.Os.Fields osFileds = (ClusterStatsNodesInfo.Os.Fields)JSONObject.parseObject((String)slusterStatsNodesFields.getOs(), ClusterStatsNodesInfo.Os.Fields.class);
            OsStats.MemInfo memInfo = (OsStats.MemInfo)JSONObject.parseObject((String)osFileds.getMem(), OsStats.MemInfo.class);
            ClusterStatsNodesInfo.Os os = new ClusterStatsNodesInfo.Os(osFileds, memInfo);
            ClusterStatsNodesInfo.Process.Fields processFileds = (ClusterStatsNodesInfo.Process.Fields)JSONObject.parseObject((String)slusterStatsNodesFields.getProcess(), ClusterStatsNodesInfo.Process.Fields.class);
            ClusterStatsNodesInfo.Process.Fields cpuFileds = (ClusterStatsNodesInfo.Process.Fields)JSONObject.parseObject((String)processFileds.getCpu(), ClusterStatsNodesInfo.Process.Fields.class);
            ClusterStatsNodesInfo.Jvm.Fields jvmFileds = (ClusterStatsNodesInfo.Jvm.Fields)JSONObject.parseObject((String)slusterStatsNodesFields.getJvm(), ClusterStatsNodesInfo.Jvm.Fields.class);
            ClusterStatsNodesInfo.Jvm.Fields jvmMemFileFileds = (ClusterStatsNodesInfo.Jvm.Fields)JSONObject.parseObject((String)jvmFileds.getMem(), ClusterStatsNodesInfo.Jvm.Fields.class);
            List jvmVersion = JSONObject.parseArray((String)Strings.toCamelCase(jvmFileds.getVersions()), ClusterStatsNodesInfo.Jvm.JvmVersion.class);
            ClusterStatsNodesInfo.Jvm jvm = new ClusterStatsNodesInfo.Jvm(jvmFileds, jvmMemFileFileds, jvmVersion);
            if (list) {
                ClusterStatsNodesInfo.FsInfo.Fields fsInfoFields = (ClusterStatsNodesInfo.FsInfo.Fields)JSONObject.parseObject((String)slusterStatsNodesFields.getFs(), ClusterStatsNodesInfo.FsInfo.Fields.class);
                ClusterStatsNodesInfo.FsInfo.Fields fsInfoField = (ClusterStatsNodesInfo.FsInfo.Fields)JSONObject.parseObject((String)fsInfoFields.getTotal(), ClusterStatsNodesInfo.FsInfo.Fields.class);
                ClusterStatsNodesInfo.FsInfo fsInfo = new ClusterStatsNodesInfo.FsInfo(fsInfoField.getTotal(), fsInfoField.getTotal_in_bytes(), fsInfoField.getFree(), fsInfoField.getFree_inBytes(), fsInfoField.getAvailable(), fsInfoField.getAvailable_in_bytes());
                ClusterStatsNodesInfo.Process.Fields openFileFileds = (ClusterStatsNodesInfo.Process.Fields)JSONObject.parseObject((String)JSON.toJSONString((Object)processFileds), ClusterStatsNodesInfo.Process.Fields.class);
                ClusterStatsNodesInfo.Process process = new ClusterStatsNodesInfo.Process(cpuFileds, openFileFileds);
                LinkedList<ClusterStatsNodesInfo> clusterStatsNodesInfos = new LinkedList<ClusterStatsNodesInfo>();
                ClusterStatsNodesInfo clusterStatsNodes = new ClusterStatsNodesInfo(os, process, jvm, fsInfo, timestamp, httpStats);
                clusterStatsNodesInfos.add(clusterStatsNodes);
                return clusterStatsNodesInfos;
            }
            ClusterStatsNodesInfo.Process.Fields openFileFileds = (ClusterStatsNodesInfo.Process.Fields)JSONObject.parseObject((String)processFileds.getOpen_file_descriptors(), ClusterStatsNodesInfo.Process.Fields.class);
            ClusterStatsNodesInfo.Process process = new ClusterStatsNodesInfo.Process(cpuFileds, openFileFileds);
            ClusterStatsNodesInfo.FsInfo fsInfo = (ClusterStatsNodesInfo.FsInfo)JSONObject.parseObject((String)slusterStatsNodesFields.getFs(), ClusterStatsNodesInfo.FsInfo.class);
            ClusterStatsNodesInfo clusterStatsNodes = new ClusterStatsNodesInfo(os, process, jvm, fsInfo, timestamp, httpStats);
            return clusterStatsNodes;
        }
        return null;
    }

    public static enum IndexMode {
        STATUS,
        INDICES,
        MAPPING,
        NODES,
        CLUSTER_HEALTH,
        CLUSTER_STATS,
        SETTING;

        private String name;

        private IndexMode() {
        }

        private IndexMode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static enum IndexStatus {
        OPEN("open"),
        CLOSE("close");

        private String name;

        private IndexStatus(String name) {
            this.name = name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

