/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.core.executor;

import com.xphsc.elasticsearch.core.client.RestHighLevelClientBulider;
import com.xphsc.elasticsearch.core.entity.PersistentEntity;
import com.xphsc.elasticsearch.core.exception.ElasticsearchException;
import com.xphsc.elasticsearch.core.executor.AbstractExecutor;
import com.xphsc.elasticsearch.core.lambda.LambdaSupplier;
import com.xphsc.elasticsearch.core.query.CriteriaWrapper;
import com.xphsc.elasticsearch.core.query.QueryCriteria;
import com.xphsc.elasticsearch.core.query.SearchIndexRequest;
import com.xphsc.elasticsearch.core.query.SearchQuery;
import com.xphsc.elasticsearch.core.transform.DynamicEntity;
import com.xphsc.elasticsearch.util.Asserts;
import com.xphsc.elasticsearch.util.Strings;
import java.io.IOException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class CountExecutor
extends AbstractExecutor<Long> {
    private Class clazz;
    private QueryCriteria criteria;
    private CriteriaWrapper criteriaWrapper;
    private SearchIndexRequest searchIndexRequest;
    private SearchQuery searchQuery;

    public CountExecutor(LambdaSupplier<RestHighLevelClientBulider> client, Class clazz) {
        super(client);
        this.clazz = clazz;
    }

    public CountExecutor(LambdaSupplier<RestHighLevelClientBulider> client, QueryCriteria criteria, Class clazz) {
        super(client);
        this.criteria = criteria;
        this.clazz = clazz;
        this.searchIndexRequest = criteria.queryProperty.getSearchIndexRequest();
    }

    public CountExecutor(LambdaSupplier<RestHighLevelClientBulider> client, CriteriaWrapper criteriaWrapper, Class clazz) {
        super(client);
        this.criteriaWrapper = criteriaWrapper;
        this.clazz = clazz;
        this.searchIndexRequest = criteriaWrapper.queryProperty.getSearchIndexRequest();
    }

    public CountExecutor(LambdaSupplier<RestHighLevelClientBulider> client, QueryCriteria criteria) {
        super(client);
        this.criteria = criteria;
        this.searchIndexRequest = criteria.queryProperty.getSearchIndexRequest();
    }

    public CountExecutor(LambdaSupplier<RestHighLevelClientBulider> client, CriteriaWrapper criteriaWrapper) {
        super(client);
        this.criteriaWrapper = criteriaWrapper;
        this.searchIndexRequest = criteriaWrapper.queryProperty.getSearchIndexRequest();
    }

    public CountExecutor(LambdaSupplier<RestHighLevelClientBulider> client, SearchQuery searchQuery) {
        super(client);
        this.searchQuery = searchQuery;
    }

    @Override
    protected Long doExecute() throws ElasticsearchException {
        SearchRequest request = new SearchRequest();
        if (this.clazz != null && this.searchIndexRequest == null) {
            PersistentEntity persistentEntity = DynamicEntity.getPersistentEntityFor(this.clazz);
            Asserts.notNull((Object)persistentEntity, "This object is not an initialization object and has an annotated @Document!");
            request.indices(new String[]{persistentEntity.getIndexName()});
            boolean ignoreTypeName = persistentEntity.isIgnoreTypeName();
            if (!ignoreTypeName && Strings.isNotBlank(persistentEntity.getIndexType())) {
                request.types(new String[]{persistentEntity.getIndexType()});
            }
        }
        this.getSearchRequestMapper(request);
        SearchSourceBuilder builder = new SearchSourceBuilder();
        if (null != this.criteria) {
            builder.query(this.criteria.listBuilders());
        }
        if (null != this.criteriaWrapper) {
            builder.query(this.criteriaWrapper.listBuilders());
        }
        if (null != this.searchQuery) {
            builder.query(this.searchQuery.getQueryBuilder());
        }
        request.source(builder);
        SearchResponse searchResponse = null;
        try {
            searchResponse = this.client.searchFor(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        SearchHits hits = searchResponse.getHits();
        return hits.getTotalHits().value;
    }

    private SearchRequest getSearchRequestMapper(SearchRequest searchRequest) {
        if (this.searchIndexRequest != null) {
            searchRequest.indices(this.searchIndexRequest.getIndexNames());
            if (this.searchIndexRequest.getTypes() != null && this.searchIndexRequest.getTypes().length > 0) {
                searchRequest.types(this.searchIndexRequest.getTypes());
            }
        } else if (this.searchQuery != null) {
            searchRequest.indices(this.searchQuery.getIndices());
            if (this.searchQuery.getTypes() != null && this.searchQuery.getTypes().length > 0) {
                searchRequest.types(this.searchQuery.getTypes());
            }
        }
        return searchRequest;
    }
}

