/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.core.executor;

import com.alibaba.fastjson.JSON;
import com.xphsc.elasticsearch.core.client.RestHighLevelClientBulider;
import com.xphsc.elasticsearch.core.exception.ElasticsearchException;
import com.xphsc.elasticsearch.core.executor.AbstractExecutor;
import com.xphsc.elasticsearch.core.lambda.LambdaSupplier;
import com.xphsc.elasticsearch.core.query.DocumentQuery;
import com.xphsc.elasticsearch.core.transform.DynamicEntity;
import com.xphsc.elasticsearch.util.Beans;
import com.xphsc.elasticsearch.util.Strings;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;

public class CreateDocumentExecutor
extends AbstractExecutor<Object> {
    private DocumentQuery query;
    private String indexName;
    private String indexType;
    private String id;
    private String source;
    private String routing;
    private long version = -3L;
    private List<DocumentQuery> indexQueries;

    public CreateDocumentExecutor(LambdaSupplier<RestHighLevelClientBulider> client, DocumentQuery query) {
        super(client);
        this.query = query;
    }

    public CreateDocumentExecutor(LambdaSupplier<RestHighLevelClientBulider> client, List<DocumentQuery> indexQueries) {
        super(client);
        this.indexQueries = indexQueries;
    }

    @Override
    protected Object doExecute() throws ElasticsearchException {
        IndexRequest indexRequest = new IndexRequest();
        indexRequest.timeout(TimeValue.timeValueMinutes((long)this.requestRimeout));
        BulkResponse bulkResponse = null;
        BulkRequest request = null;
        LinkedList<Integer> result = new LinkedList<Integer>();
        if (this.indexQueries != null) {
            Iterator<DocumentQuery> iterator = this.indexQueries.iterator();
            while (iterator.hasNext()) {
                DocumentQuery query;
                this.query = query = iterator.next();
                this.getIndexRequest(indexRequest);
                request = new BulkRequest();
                request.add(indexRequest);
                try {
                    bulkResponse = this.client.bulk(request, RequestOptions.DEFAULT);
                    result.add(bulkResponse.status().getStatus());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return result.size();
        }
        this.getIndexRequest(indexRequest);
        request = new BulkRequest();
        request.add(indexRequest);
        try {
            bulkResponse = this.client.bulk(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        BulkItemResponse bulkItemResponse = bulkResponse.getItems()[0];
        return bulkItemResponse.getId();
    }

    private IndexRequest getIndexRequest(IndexRequest indexRequest) {
        String string = Strings.isBlank(this.query.getIndexName()) ? (!(this.query.getObject() instanceof Map) ? DynamicEntity.getPersistentEntityFor(this.query.getObject().getClass()).getIndexName() : null) : (this.indexName = this.query.getIndexName());
        this.indexType = Strings.isBlank(this.query.getType()) ? (!(this.query.getObject() instanceof Map) ? DynamicEntity.getPersistentEntityFor(this.query.getObject().getClass()).getIndexType() : null) : this.query.getType();
        this.id = this.query.getObject() != null ? Beans.getIdValue(this.query.getObject()) : this.query.getId();
        if (Strings.isNotEmpty(this.query.getRouting())) {
            this.routing = this.query.getRouting();
        }
        if (this.query.getVersion() > 0L) {
            this.version = this.query.getVersion();
        }
        indexRequest.index(this.indexName);
        if (Strings.isNotBlank(this.indexType)) {
            indexRequest.type(this.indexType);
        }
        if (Strings.isNotEmpty(this.id)) {
            indexRequest.id(this.id);
        }
        if (Strings.isNotEmpty(this.routing)) {
            indexRequest.routing(this.routing);
        }
        if (this.version > 0L) {
            indexRequest.version(this.version);
        }
        this.source = Strings.isBlank(this.query.getSource()) ? JSON.toJSONString((Object)this.query.getObject(), (boolean)true) : this.query.getSource();
        indexRequest.source(this.source, XContentType.JSON);
        return indexRequest;
    }
}

