/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.core.executor;

import com.alibaba.fastjson.JSON;
import com.xphsc.elasticsearch.core.client.RestHighLevelClientBulider;
import com.xphsc.elasticsearch.core.entity.PersistentEntity;
import com.xphsc.elasticsearch.core.exception.ElasticsearchException;
import com.xphsc.elasticsearch.core.executor.AbstractExecutor;
import com.xphsc.elasticsearch.core.executor.PutExecutor;
import com.xphsc.elasticsearch.core.executor.RefreshExecutor;
import com.xphsc.elasticsearch.core.lambda.LambdaSupplier;
import com.xphsc.elasticsearch.core.transform.DynamicEntity;
import com.xphsc.elasticsearch.util.Beans;
import com.xphsc.elasticsearch.util.Collects;
import com.xphsc.elasticsearch.util.Elasticsearchs;
import com.xphsc.elasticsearch.util.Strings;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;

public class CreateEntityExecutor<T>
extends AbstractExecutor<Object> {
    private T entity;
    private List<T> entities;
    private boolean ignoreTypeName;

    public CreateEntityExecutor(LambdaSupplier<RestHighLevelClientBulider> client, T entity) {
        super(client);
        this.entity = entity;
    }

    public CreateEntityExecutor(LambdaSupplier<RestHighLevelClientBulider> client, List<T> entities) {
        super(client);
        this.entities = entities;
    }

    @Override
    protected Object doExecute() throws ElasticsearchException {
        IndexRequest indexRequest = new IndexRequest();
        indexRequest.timeout(TimeValue.timeValueMinutes((long)this.requestRimeout));
        PersistentEntity persistentEntity = null;
        BulkResponse bulkResponse = null;
        LinkedList<Integer> result = new LinkedList<Integer>();
        RefreshExecutor executor = null;
        PutExecutor putExecutor = null;
        if (this.entity != null) {
            putExecutor = new PutExecutor(this::getClient, this.entity.getClass());
            putExecutor.execute();
            persistentEntity = DynamicEntity.getPersistentEntityFor(this.entity.getClass());
            String id = Beans.getIdValue(this.entity);
            indexRequest.index(persistentEntity.getIndexName());
            this.ignoreTypeName = persistentEntity.isIgnoreTypeName();
            if (!this.ignoreTypeName && Strings.isNotBlank(persistentEntity.getIndexType())) {
                indexRequest.type(persistentEntity.getIndexType());
            }
            if (Strings.isNotEmpty(id)) {
                indexRequest.id(id);
            }
        }
        BulkRequest request = null;
        if (Collects.isNotEmpty(this.entities)) {
            persistentEntity = DynamicEntity.getPersistentEntityFor(this.entities.get(0).getClass());
            this.ignoreTypeName = persistentEntity.isIgnoreTypeName();
            putExecutor = new PutExecutor(this::getClient, this.entities.get(0).getClass());
            putExecutor.execute();
            for (T entity : this.entities) {
                request = new BulkRequest();
                indexRequest.index(persistentEntity.getIndexName());
                if (!this.ignoreTypeName && Strings.isNotBlank(persistentEntity.getIndexType())) {
                    indexRequest.type(persistentEntity.getIndexType());
                }
                indexRequest.source(JSON.toJSONString(entity, (boolean)true), XContentType.JSON);
                request.add(indexRequest);
                try {
                    bulkResponse = this.client.bulk(request, RequestOptions.DEFAULT);
                    result.add(bulkResponse.status().getStatus());
                }
                catch (IOException iOException) {}
            }
            executor = new RefreshExecutor(this::getClient, persistentEntity.getIndexName());
            executor.execute();
            return result.size();
        }
        request = new BulkRequest();
        String source = JSON.toJSONString(this.entity, (boolean)true);
        indexRequest.source(source, XContentType.JSON);
        request.add(indexRequest);
        try {
            bulkResponse = this.client.bulk(request, RequestOptions.DEFAULT);
        }
        catch (IOException entity) {
            // empty catch block
        }
        if (!Objects.isNull(bulkResponse)) {
            BulkItemResponse bulkItemResponse = bulkResponse.getItems()[0];
            executor = new RefreshExecutor(this::getClient, persistentEntity.getIndexName());
            executor.execute();
            return JSON.parseObject((String)Elasticsearchs.toJsonWithId(source, Beans.getIdName(this.entity.getClass()), bulkItemResponse.getId()), this.entity.getClass());
        }
        return null;
    }
}

