/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.core.executor;

import com.xphsc.elasticsearch.core.client.RestHighLevelClientBulider;
import com.xphsc.elasticsearch.core.entity.PersistentEntity;
import com.xphsc.elasticsearch.core.exception.ElasticsearchException;
import com.xphsc.elasticsearch.core.executor.AbstractExecutor;
import com.xphsc.elasticsearch.core.lambda.LambdaSupplier;
import com.xphsc.elasticsearch.core.query.IndexSettings;
import com.xphsc.elasticsearch.core.transform.DynamicEntity;
import com.xphsc.elasticsearch.util.Asserts;
import com.xphsc.elasticsearch.util.Strings;
import java.io.IOException;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentType;

public class CreateExecutor
extends AbstractExecutor<Boolean> {
    private String indexName;
    private Class<?> clazz;
    private String alias;
    private int shards;
    private int replicas;
    private String refreshInterval;
    private String indexStoreType;
    private long maxResult;
    private boolean createAnotationSettings;
    private Object settings;

    public CreateExecutor(LambdaSupplier<RestHighLevelClientBulider> client, String indexName) {
        super(client);
        this.indexName = indexName;
    }

    public CreateExecutor(LambdaSupplier<RestHighLevelClientBulider> client, Class<?> clazz) {
        super(client);
        this.clazz = clazz;
    }

    public CreateExecutor(LambdaSupplier<RestHighLevelClientBulider> client, String indexName, String alias, int shards, int replicas, String refreshInterval, String indexStoreType) {
        super(client);
        this.indexName = indexName;
        this.alias = alias;
        this.shards = shards;
        this.replicas = replicas;
        this.refreshInterval = refreshInterval;
        this.indexStoreType = indexStoreType;
    }

    public CreateExecutor(LambdaSupplier<RestHighLevelClientBulider> client, String indexName, IndexSettings settings) {
        super(client);
        this.indexName = indexName;
        this.alias = settings.getAlias();
        this.shards = settings.getShards();
        this.replicas = settings.getReplicas();
        this.refreshInterval = settings.getRefreshInterval();
        this.indexStoreType = settings.getIndexStoreType();
        this.maxResult = settings.getMaxResult();
    }

    public CreateExecutor(LambdaSupplier<RestHighLevelClientBulider> client, String indexName, String alias, int shards, int replicas, long maxResult, String refreshInterval, String indexStoreType) {
        super(client);
        this.indexName = indexName;
        this.alias = alias;
        this.shards = shards;
        this.replicas = replicas;
        this.refreshInterval = refreshInterval;
        this.indexStoreType = indexStoreType;
        this.maxResult = maxResult;
    }

    @Override
    protected Boolean doExecute() throws ElasticsearchException {
        String newIndexName = "";
        Settings.Builder settings = Settings.builder();
        if (Strings.isNotBlank(this.indexName)) {
            newIndexName = this.indexName;
        }
        if (this.clazz != null) {
            PersistentEntity entity = DynamicEntity.getPersistentEntityFor(this.clazz);
            Asserts.notNull((Object)entity, "This object is not an initialization object and has an annotated @Document!");
            newIndexName = entity.getIndexName();
            if (entity.getShards() != 0) {
                this.shards = entity.getShards();
            }
            if (entity.getReplicas() != 0) {
                this.replicas = entity.getReplicas();
            }
            if (entity.getMaxResult() > 10000L) {
                this.maxResult = entity.getMaxResult();
            }
            if (Strings.isNotBlank(entity.getRefreshInterval())) {
                this.refreshInterval = entity.getRefreshInterval();
            }
            if (Strings.isNotBlank(entity.getIndexStoreType())) {
                this.indexStoreType = entity.getIndexStoreType();
            }
            if (Strings.isNotBlank(entity.getAlias())) {
                this.alias = entity.getAlias();
            }
            if (DynamicEntity.annotatinSettings(this.clazz)) {
                this.settings = DynamicEntity.settings(this.clazz);
                this.createAnotationSettings = true;
            }
        }
        if (this.shards != 0) {
            settings.put("index.number_of_shards", this.shards);
        }
        if (this.replicas != 0) {
            settings.put("index.number_of_replicas", this.replicas);
        }
        if (this.maxResult > 10000L) {
            settings.put("index.max_result_window", this.maxResult);
        }
        if (Strings.isNotBlank(this.refreshInterval)) {
            settings.put("index.refresh_interval", this.refreshInterval);
        }
        if (Strings.isNotBlank(this.indexStoreType)) {
            settings.put("index.store.type", this.indexStoreType);
        }
        try {
            CreateIndexRequest request = this.createAnotationSettings ? new CreateIndexRequest(newIndexName.toLowerCase()).settings((String)this.settings, XContentType.JSON) : new CreateIndexRequest(newIndexName.toLowerCase()).settings(settings);
            if (Strings.isNotEmpty(this.alias)) {
                request.alias(new Alias(this.alias));
            }
            this.indexExist(newIndexName);
            return !this.indexExist(newIndexName) ? this.client.createFor(request, RequestOptions.DEFAULT).isAcknowledged() : false;
        }
        catch (IOException iOException) {
            return true;
        }
    }
}

