/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.core.executor;

import com.xphsc.elasticsearch.core.client.RestHighLevelClientBulider;
import com.xphsc.elasticsearch.core.exception.ElasticsearchException;
import com.xphsc.elasticsearch.core.executor.AbstractExecutor;
import com.xphsc.elasticsearch.core.lambda.LambdaSupplier;
import com.xphsc.elasticsearch.core.query.DeleteQuery;
import com.xphsc.elasticsearch.util.Strings;
import java.io.IOException;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.client.RequestOptions;

public class DeleteDocmentExecutor<T>
extends AbstractExecutor<Object> {
    private DeleteQuery deleteQuery;
    private String id;
    private String indexName;
    private String type;
    private String routing;
    private String parent;
    private long version = -3L;

    public DeleteDocmentExecutor(LambdaSupplier<RestHighLevelClientBulider> client, DeleteQuery deleteQuery) {
        super(client);
        this.deleteQuery = deleteQuery;
    }

    @Override
    public Object doExecute() throws ElasticsearchException {
        DeleteResponse deleteResponse = null;
        DeleteRequest deleteRequest = new DeleteRequest();
        if (this.deleteQuery != null) {
            this.indexName = this.deleteQuery.getIndex();
            this.type = this.deleteQuery.getType();
            this.id = this.deleteQuery.getId();
            this.routing = this.deleteQuery.getRouting();
            this.parent = this.deleteQuery.getParent();
            this.version = this.deleteQuery.getVersion();
        }
        if (Strings.isNotBlank(this.indexName)) {
            deleteRequest.index(this.indexName);
        }
        if (Strings.isNotBlank(this.type)) {
            deleteRequest.type(this.type);
        }
        if (Strings.isNotBlank(this.id)) {
            deleteRequest.id(this.id);
        }
        if (Strings.isNotBlank(this.routing)) {
            deleteRequest.routing(this.routing);
        }
        if (this.version > 0L) {
            deleteRequest.version(this.version);
        }
        try {
            deleteResponse = this.client.delete(deleteRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return deleteResponse.status().getStatus();
    }
}

