/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.core.executor;

import com.xphsc.elasticsearch.core.client.RestHighLevelClientBulider;
import com.xphsc.elasticsearch.core.entity.PersistentEntity;
import com.xphsc.elasticsearch.core.exception.ElasticsearchException;
import com.xphsc.elasticsearch.core.executor.AbstractExecutor;
import com.xphsc.elasticsearch.core.lambda.LambdaSupplier;
import com.xphsc.elasticsearch.core.transform.DynamicEntity;
import com.xphsc.elasticsearch.util.Asserts;
import com.xphsc.elasticsearch.util.Beans;
import com.xphsc.elasticsearch.util.Collects;
import com.xphsc.elasticsearch.util.Strings;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.common.unit.TimeValue;

public class DeleteEntityExecutor<T>
extends AbstractExecutor<Object> {
    private String id;
    private T entity;
    private Iterable<String> ids;
    private Class<?> clazz;
    private String indexName;
    private String type;
    private boolean ignoreTypeName;

    public DeleteEntityExecutor(LambdaSupplier<RestHighLevelClientBulider> client, Class<?> clazz, Serializable id) {
        super(client);
        this.id = id.toString();
        this.clazz = clazz;
    }

    public DeleteEntityExecutor(LambdaSupplier<RestHighLevelClientBulider> client, Class<T> clazz, Iterable<String> ids) {
        super(client);
        this.ids = ids;
        this.clazz = clazz;
    }

    public DeleteEntityExecutor(LambdaSupplier<RestHighLevelClientBulider> client, T entity) {
        super(client);
        this.entity = entity;
    }

    public DeleteEntityExecutor(LambdaSupplier<RestHighLevelClientBulider> client, String indexName, String type, Serializable id) {
        super(client);
        this.indexName = indexName;
        this.type = type;
        this.id = id.toString();
        this.ignoreTypeName = true;
    }

    public DeleteEntityExecutor(LambdaSupplier<RestHighLevelClientBulider> client, String indexName, Serializable id) {
        super(client);
        this.indexName = indexName;
        this.id = id.toString();
    }

    @Override
    protected Object doExecute() throws ElasticsearchException {
        PersistentEntity persistentEntity = null;
        Object executor = null;
        if (this.entity != null) {
            persistentEntity = DynamicEntity.getPersistentEntityFor(this.entity.getClass());
            Asserts.notNull((Object)persistentEntity, "This object is not an initialization instance object and has an annotated @Document!");
            this.ignoreTypeName = persistentEntity.isIgnoreTypeName();
            this.indexName = persistentEntity.getIndexName();
            this.type = persistentEntity.getIndexType();
            String id = Beans.getIdValue(this.entity);
            Asserts.notNull((Object)id, "This object  has an annotated @Id And id cannot be empty!");
            this.id = id;
        }
        if (this.clazz != null) {
            persistentEntity = DynamicEntity.getPersistentEntityFor(this.clazz);
            Asserts.notNull((Object)persistentEntity, "This object is not an initialization class object and has an annotated @Document!");
            this.indexName = persistentEntity.getIndexName();
            this.type = persistentEntity.getIndexType();
            this.ignoreTypeName = persistentEntity.isIgnoreTypeName();
        }
        DeleteRequest deleteRequest = new DeleteRequest();
        if (Strings.isNotBlank(this.indexName)) {
            deleteRequest.index(this.indexName);
        }
        if (!this.ignoreTypeName && Strings.isNotBlank(this.type)) {
            deleteRequest.type(this.type);
        }
        deleteRequest.timeout(TimeValue.timeValueMinutes((long)this.requestRimeout));
        if (Collects.isNotEmpty(this.ids)) {
            DeleteResponse deleteResponse = null;
            ArrayList<Integer> result = new ArrayList<Integer>();
            for (String id : this.ids) {
                deleteRequest.id(id);
                try {
                    deleteResponse = this.client.delete(deleteRequest, RequestOptions.DEFAULT);
                    result.add(deleteResponse.status().getStatus());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return result.size();
        }
        deleteRequest.id(this.id);
        try {
            return this.client.delete(deleteRequest, RequestOptions.DEFAULT).status().getStatus();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

