/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.core.executor;

import com.xphsc.elasticsearch.core.client.RestHighLevelClientBulider;
import com.xphsc.elasticsearch.core.entity.PersistentEntity;
import com.xphsc.elasticsearch.core.exception.ElasticsearchException;
import com.xphsc.elasticsearch.core.executor.AbstractExecutor;
import com.xphsc.elasticsearch.core.lambda.LambdaSupplier;
import com.xphsc.elasticsearch.core.transform.DynamicEntity;
import com.xphsc.elasticsearch.util.Asserts;
import java.io.IOException;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.common.unit.TimeValue;

public class DeleteExecutor
extends AbstractExecutor<Boolean> {
    private String[] indexNames;
    private Class clazz;

    public DeleteExecutor(LambdaSupplier<RestHighLevelClientBulider> client, String ... indexNames) {
        super(client);
        this.indexNames = indexNames;
    }

    public DeleteExecutor(LambdaSupplier<RestHighLevelClientBulider> client, Class clazz) {
        super(client);
        this.clazz = clazz;
    }

    @Override
    protected Boolean doExecute() throws ElasticsearchException {
        if (this.clazz != null) {
            PersistentEntity entity = DynamicEntity.getPersistentEntityFor(this.clazz);
            Asserts.notNull((Object)entity, "This object is not an initialization object and has an annotated @Document!");
            this.indexNames = new String[]{entity.getIndexName()};
        }
        try {
            DeleteIndexRequest request = new DeleteIndexRequest(this.indexNames);
            request.timeout(TimeValue.timeValueMinutes((long)this.requestRimeout));
            return this.client.deleteFor(request, RequestOptions.DEFAULT).isAcknowledged();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

