/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.core.executor;

import com.alibaba.fastjson.JSON;
import com.xphsc.elasticsearch.core.client.RestHighLevelClientBulider;
import com.xphsc.elasticsearch.core.entity.PersistentEntity;
import com.xphsc.elasticsearch.core.exception.ElasticsearchException;
import com.xphsc.elasticsearch.core.executor.AbstractExecutor;
import com.xphsc.elasticsearch.core.lambda.LambdaSupplier;
import com.xphsc.elasticsearch.core.transform.DynamicEntity;
import com.xphsc.elasticsearch.util.Asserts;
import com.xphsc.elasticsearch.util.Beans;
import com.xphsc.elasticsearch.util.Elasticsearchs;
import com.xphsc.elasticsearch.util.Strings;
import java.io.IOException;
import java.io.Serializable;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.client.RequestOptions;

public class GetEntityExecutor<T>
extends AbstractExecutor<T> {
    private String id;
    private T entity;
    private Class<?> clazz;
    private boolean ignoreTypeName;

    public GetEntityExecutor(LambdaSupplier<RestHighLevelClientBulider> client, T entity) {
        super(client);
        this.entity = entity;
    }

    public GetEntityExecutor(LambdaSupplier<RestHighLevelClientBulider> client, Class<?> clazz, Serializable id) {
        super(client);
        this.id = id.toString();
        this.clazz = clazz;
    }

    @Override
    protected T doExecute() throws ElasticsearchException {
        PersistentEntity persistentEntity = null;
        if (this.entity != null) {
            persistentEntity = DynamicEntity.getPersistentEntityFor(this.entity.getClass());
            Asserts.notNull((Object)persistentEntity, "This object is not an initialization  instance object and has an annotated @Document!");
        } else {
            persistentEntity = DynamicEntity.getPersistentEntityFor(this.clazz);
            Asserts.notNull((Object)persistentEntity, "This object is not an initialization class object and has an annotated @Document!");
        }
        GetRequest getRequest = new GetRequest();
        getRequest.index(persistentEntity.getIndexName());
        this.ignoreTypeName = persistentEntity.isIgnoreTypeName();
        if (!this.ignoreTypeName && Strings.isNotBlank(persistentEntity.getIndexType())) {
            getRequest.type(persistentEntity.getIndexType());
        }
        if (Strings.isNotBlank(this.id)) {
            getRequest.id(this.id);
        } else {
            String id = Beans.getIdValue(this.entity);
            Asserts.notNull((Object)id, "This object  has an annotated @Id And id cannot be empty!");
            getRequest.id(id);
        }
        try {
            GetResponse getResponse = this.client.get(getRequest, RequestOptions.DEFAULT);
            Class<?> entityObject = this.entity != null ? this.entity.getClass() : this.clazz;
            return (T)JSON.parseObject((String)Elasticsearchs.toJsonWithId(getResponse.getSourceAsString(), Beans.getIdName(entityObject), getRequest.id()), entityObject);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

