/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.core.executor;

import com.xphsc.elasticsearch.core.client.RestHighLevelClientBulider;
import com.xphsc.elasticsearch.core.entity.PersistentEntity;
import com.xphsc.elasticsearch.core.exception.ElasticsearchException;
import com.xphsc.elasticsearch.core.executor.AbstractExecutor;
import com.xphsc.elasticsearch.core.lambda.LambdaSupplier;
import com.xphsc.elasticsearch.core.transform.DynamicEntity;
import com.xphsc.elasticsearch.util.Asserts;
import com.xphsc.elasticsearch.util.Strings;
import java.io.IOException;
import org.elasticsearch.action.admin.indices.cache.clear.ClearIndicesCacheRequest;
import org.elasticsearch.action.admin.indices.flush.FlushRequest;
import org.elasticsearch.action.admin.indices.open.OpenIndexRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.indices.CloseIndexRequest;

public class IndexExecutor<T>
extends AbstractExecutor<Object> {
    private String indexName;
    private String indexRequestMode;
    private Class<T> clazz;

    public IndexExecutor(LambdaSupplier<RestHighLevelClientBulider> client, String indexName, IndexRequestMode indexRequestMode) {
        super(client);
        this.indexName = indexName;
        this.indexRequestMode = indexRequestMode.name();
    }

    public IndexExecutor(LambdaSupplier<RestHighLevelClientBulider> client, Class<T> clazz, IndexRequestMode indexRequestMode) {
        super(client);
        this.clazz = clazz;
        this.indexRequestMode = indexRequestMode.name();
    }

    @Override
    protected Object doExecute() throws ElasticsearchException {
        boolean result = false;
        if (this.clazz != null) {
            PersistentEntity entity = DynamicEntity.getPersistentEntityFor(this.clazz);
            Asserts.notNull((Object)entity, "This object is not an initialization object and has an annotated @Document!");
            this.indexName = entity.getIndexName();
        }
        if (Strings.isNotBlank(this.indexRequestMode)) {
            if (this.indexRequestMode.equals(IndexRequestMode.OPEN.toString())) {
                OpenIndexRequest openIndexRequest = new OpenIndexRequest();
                openIndexRequest.indices(new String[]{this.indexName});
                try {
                    result = this.client.openFor(openIndexRequest, RequestOptions.DEFAULT).isAcknowledged();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.indexRequestMode.equals(IndexRequestMode.CLOSE.toString())) {
                CloseIndexRequest closeIndexRequest = new CloseIndexRequest(new String[]{this.indexName});
                try {
                    result = this.client.closeFor(closeIndexRequest, RequestOptions.DEFAULT).isAcknowledged();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (this.indexRequestMode.equals(IndexRequestMode.CLEAR_CACHE.toString())) {
                ClearIndicesCacheRequest cacheRequest = new ClearIndicesCacheRequest(new String[0]);
                cacheRequest.indices(new String[]{this.indexName});
                try {
                    result = this.client.clearCacheFor(cacheRequest, RequestOptions.DEFAULT).getStatus().getStatus() == 200;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (this.indexRequestMode.equals(IndexRequestMode.FLUSH.toString())) {
                FlushRequest flushRequest = new FlushRequest(new String[0]);
                flushRequest.indices(new String[]{this.indexName});
                try {
                    result = this.client.flushFor(flushRequest, RequestOptions.DEFAULT).getStatus().getStatus() == 200;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public static enum IndexRequestMode {
        OPEN,
        CLOSE,
        CLEAR_CACHE,
        FLUSH;

        private String name;

        private IndexRequestMode() {
        }

        private IndexRequestMode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

