/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.core.executor;

import com.alibaba.fastjson.annotation.JSONField;
import com.xphsc.elasticsearch.annotations.Child;
import com.xphsc.elasticsearch.annotations.Id;
import com.xphsc.elasticsearch.annotations.Transient;
import com.xphsc.elasticsearch.core.client.RestHighLevelClientBulider;
import com.xphsc.elasticsearch.core.entity.FieldType;
import com.xphsc.elasticsearch.core.entity.PersistentEntity;
import com.xphsc.elasticsearch.core.exception.ElasticsearchException;
import com.xphsc.elasticsearch.core.executor.AbstractExecutor;
import com.xphsc.elasticsearch.core.executor.CreateExecutor;
import com.xphsc.elasticsearch.core.executor.ExistExecutor;
import com.xphsc.elasticsearch.core.lambda.LambdaSupplier;
import com.xphsc.elasticsearch.core.transform.DynamicEntity;
import com.xphsc.elasticsearch.util.Elasticsearchs;
import com.xphsc.elasticsearch.util.Strings;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;

public class PutExecutor
extends AbstractExecutor<Boolean> {
    private Class<?> clazz;
    private String indexName;
    private String type;
    private Object mapping;
    private boolean annotationMapping;
    private boolean ignoreTypeName;
    public static final String FIELD_STORE = "store";
    public static final String FIELD_TYPE = "type";
    public static final String FIELD_INDEX = "index";
    public static final String FIELD_FORMAT = "format";
    public static final String FIELDS = "fields";
    public static final String FIELD_KEYWORD = "keyword";
    public static final String FIELD_DATA = "fielddata";
    public static final String FIELD_DOC_VALUES = "doc_values";
    public static final String FIELD_NULL_VALUE = "null_value";
    public static final String FIELD_NULL = "NULL";
    public static final String FIELD_TRICT = "trict";
    public static final String FIELD_DYNAMIC = "dynamic";
    public static final String FIELD_NORMALIZER = "normalizer";
    public static final String FIELD_NORMALIZER_NAME = "normalizer_name";
    public static final String FIELD_ANALYZER = "analyzer";
    public static final String VOID = "void";
    public static final String MAPPING_PROPERTIES = "properties";

    public PutExecutor(LambdaSupplier<RestHighLevelClientBulider> client, Class<?> clazz) {
        super(client);
        this.clazz = clazz;
        PersistentEntity entity = DynamicEntity.getPersistentEntityFor(clazz);
        this.ignoreTypeName = entity.isIgnoreTypeName();
    }

    public PutExecutor(LambdaSupplier<RestHighLevelClientBulider> client, String indexName, String type, Object mapping) {
        super(client);
        this.indexName = indexName;
        this.type = type;
        this.mapping = mapping;
    }

    public PutExecutor(LambdaSupplier<RestHighLevelClientBulider> client, String indexName, Object mapping) {
        super(client);
        this.indexName = indexName;
        this.mapping = mapping;
        this.ignoreTypeName = true;
    }

    @Override
    protected Boolean doExecute() throws ElasticsearchException {
        try {
            if (this.clazz != null) {
                ExistExecutor executor = new ExistExecutor(this::getClient, this.clazz);
                boolean result = (Boolean)executor.execute();
                return !result ? (this.ignoreTypeName ? this.client.putMappingFor((org.elasticsearch.client.indices.PutMappingRequest)this.reflectMapping(this.clazz, this.ignoreTypeName), RequestOptions.DEFAULT).isAcknowledged() : this.client.putMappingFor((PutMappingRequest)this.reflectMapping(this.clazz, this.ignoreTypeName), RequestOptions.DEFAULT).isAcknowledged()) : false;
            }
            PutMappingRequest mappingAdminRequest = null;
            org.elasticsearch.client.indices.PutMappingRequest mappingRequest = null;
            if (this.ignoreTypeName) {
                mappingRequest = new org.elasticsearch.client.indices.PutMappingRequest(new String[]{this.indexName});
                if (this.mapping instanceof String) {
                    mappingRequest.source(String.valueOf(this.mapping), XContentType.JSON);
                } else if (this.mapping instanceof Map) {
                    mappingRequest.source((Map)this.mapping);
                } else if (this.mapping instanceof XContentBuilder) {
                    mappingRequest.source((XContentBuilder)this.mapping);
                }
            } else {
                mappingAdminRequest = Requests.putMappingRequest((String[])new String[]{this.indexName});
                if (Strings.isNotBlank(this.type)) {
                    mappingAdminRequest.type(this.type);
                }
                if (this.mapping instanceof String) {
                    mappingAdminRequest.source(String.valueOf(this.mapping), XContentType.JSON);
                } else if (this.mapping instanceof Map) {
                    mappingAdminRequest.source((Map)this.mapping);
                } else if (this.mapping instanceof XContentBuilder) {
                    mappingAdminRequest.source((XContentBuilder)this.mapping);
                }
            }
            ExistExecutor executor = new ExistExecutor(this::getClient, this.indexName);
            boolean result = (Boolean)executor.execute();
            return result ? (this.ignoreTypeName ? this.client.putMappingFor(mappingRequest, RequestOptions.DEFAULT).isAcknowledged() : this.client.putMappingFor(mappingAdminRequest, RequestOptions.DEFAULT).isAcknowledged()) : false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Object reflectMapping(Class clazz, boolean ignoreTypeName) {
        try {
            PersistentEntity entity = DynamicEntity.getPersistentEntityFor(clazz);
            if (entity.isAutoCreateIndex()) {
                CreateExecutor executor = new CreateExecutor(this::getClient, entity.getIndexName(), entity.getAlias(), entity.getShards(), entity.getReplicas(), entity.getMaxResult(), entity.getRefreshInterval(), entity.getIndexStoreType());
                executor.execute();
            }
            XContentBuilder mapping = null;
            try {
                mapping = XContentFactory.jsonBuilder().startObject();
                if (entity != null && Strings.isNotEmpty(entity.getDynamic())) {
                    mapping.field(FIELD_DYNAMIC, FIELD_TRICT.equals(entity.getDynamic()) ? FIELD_TRICT : Boolean.valueOf(entity.getDynamic()));
                }
                mapping = mapping.startObject(MAPPING_PROPERTIES);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                mapping = this.iterClass(clazz, mapping);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                mapping.endObject().endObject();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (DynamicEntity.mappings(clazz) != null) {
                this.annotationMapping = true;
            }
            org.elasticsearch.client.indices.PutMappingRequest putMappingRequest = !this.annotationMapping ? new org.elasticsearch.client.indices.PutMappingRequest(new String[]{entity.getIndexName()}).source(mapping) : new org.elasticsearch.client.indices.PutMappingRequest(new String[]{entity.getIndexName()}).source(DynamicEntity.mappings(clazz), XContentType.JSON);
            return ignoreTypeName ? putMappingRequest : (!this.annotationMapping ? Requests.putMappingRequest((String[])new String[]{entity.getIndexName()}).type(entity.getIndexType()).source(mapping) : Requests.putMappingRequest((String[])new String[]{entity.getIndexName()}).type(entity.getIndexType()).source(DynamicEntity.mappings(clazz), XContentType.JSON));
        }
        catch (ElasticsearchException e) {
            throw new ElasticsearchException(e);
        }
    }

    private XContentBuilder iterClass(Class clazz, XContentBuilder mapping) throws IOException {
        Field[] declaredFields = null;
        try {
            declaredFields = clazz.getClassLoader().loadClass(clazz.getName()).getDeclaredFields();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        for (Field declaredField : declaredFields) {
            Type genericType;
            String fieldName;
            com.xphsc.elasticsearch.annotations.Field annotation = declaredField.getAnnotation(com.xphsc.elasticsearch.annotations.Field.class);
            JSONField jsonField = declaredField.getAnnotation(JSONField.class);
            Child child = declaredField.getAnnotation(Child.class);
            String aliasName = null;
            if (declaredField.isAnnotationPresent(Transient.class)) continue;
            if (annotation != null) {
                if (annotation.ignoreField()) continue;
                if (Strings.isNotBlank(annotation.name())) {
                    aliasName = annotation.name();
                }
            }
            if (null != child && !VOID.equals(child.childClass().getName())) {
                if (null != jsonField && Strings.isNotEmpty(jsonField.name())) {
                    mapping.startObject(jsonField.name());
                } else {
                    fieldName = Strings.isNotBlank(aliasName) ? aliasName : declaredField.getName();
                    mapping.startObject(fieldName);
                }
                mapping.startObject(MAPPING_PROPERTIES);
                mapping = this.iterClass(child.childClass(), mapping);
                mapping.endObject();
                mapping.endObject();
                continue;
            }
            Id idAnno = declaredField.getAnnotation(Id.class);
            if (null != idAnno) continue;
            String typeName = declaredField.getType().getName();
            if (declaredField.getType() == List.class && (genericType = declaredField.getGenericType()) instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)genericType;
                Class genericClazz = (Class)pt.getActualTypeArguments()[0];
                typeName = genericClazz.getName();
            }
            if (annotation != null) {
                typeName = annotation.keyword() || annotation.textAndKeyword() || annotation.type().equals((Object)FieldType.text) ? FieldType.keyword.name() : (annotation.type().equals((Object)FieldType.text) ? FieldType.text.name() : (annotation.type().equals((Object)FieldType.Integer) ? FieldType.Integer.name() : (annotation.type().equals((Object)FieldType.Long) ? FieldType.Long.name() : (annotation.type().equals((Object)FieldType.Date) ? FieldType.Date.name() : (annotation.type().equals((Object)FieldType.Boolean) ? FieldType.Boolean.name() : (annotation.type().equals((Object)FieldType.Double) ? FieldType.Double.name() : (annotation.type().equals((Object)FieldType.Float) ? FieldType.Float.name() : FieldType.text.name())))))));
            } else if (declaredField.getType() == String.class) {
                typeName = FieldType.text.name();
            }
            if (null != jsonField && Strings.isNotEmpty(jsonField.name())) {
                mapping.startObject(jsonField.name()).field(FIELD_TYPE, Elasticsearchs.format(typeName));
            } else {
                fieldName = Strings.isNotBlank(aliasName) ? aliasName : declaredField.getName();
                mapping.startObject(fieldName).field(FIELD_TYPE, Elasticsearchs.format(typeName));
            }
            mapping = this.getMapping(mapping, annotation);
            mapping.endObject();
        }
        return mapping;
    }

    private XContentBuilder getMapping(XContentBuilder mapping, com.xphsc.elasticsearch.annotations.Field annotation) throws IOException {
        if (null != annotation) {
            if (Strings.isNotBlank(annotation.fields())) {
                mapping.startObject(FIELDS).startObject(annotation.fields());
                mapping.field(FIELD_TYPE, FIELD_KEYWORD);
                mapping.endObject().endObject();
            }
            if (annotation.fieldData()) {
                mapping.field(FIELD_DATA, annotation.fieldData());
            }
            if (!annotation.docValues()) {
                mapping.field(FIELD_DOC_VALUES, annotation.docValues());
            }
            if (Strings.isNotBlank(annotation.format())) {
                mapping.field(FIELD_FORMAT, annotation.format());
            }
            if (annotation.nullValue()) {
                mapping.field(FIELD_NULL_VALUE, FIELD_NULL);
            }
            if (Strings.isNotBlank(annotation.indexAnalyzer())) {
                mapping.field(FIELD_ANALYZER, annotation.indexAnalyzer());
            }
            if (annotation.normalizer()) {
                mapping.field(FIELD_NORMALIZER, FIELD_NORMALIZER_NAME);
            }
            mapping.field(FIELD_INDEX, annotation.index());
            mapping.field(FIELD_STORE, annotation.store());
        }
        return mapping;
    }
}

