/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.core.executor;

import com.xphsc.elasticsearch.core.client.RestHighLevelClientBulider;
import com.xphsc.elasticsearch.core.entity.PersistentEntity;
import com.xphsc.elasticsearch.core.entity.Sort;
import com.xphsc.elasticsearch.core.exception.ElasticsearchException;
import com.xphsc.elasticsearch.core.executor.AbstractExecutor;
import com.xphsc.elasticsearch.core.executor.RefreshExecutor;
import com.xphsc.elasticsearch.core.lambda.LambdaSupplier;
import com.xphsc.elasticsearch.core.query.CriteriaWrapper;
import com.xphsc.elasticsearch.core.query.QueryCriteria;
import com.xphsc.elasticsearch.core.query.QueryProperty;
import com.xphsc.elasticsearch.core.query.ResultsMapper;
import com.xphsc.elasticsearch.core.query.SearchIndexRequest;
import com.xphsc.elasticsearch.core.transform.DynamicEntity;
import com.xphsc.elasticsearch.page.Page;
import com.xphsc.elasticsearch.util.Asserts;
import com.xphsc.elasticsearch.util.Collects;
import com.xphsc.elasticsearch.util.Strings;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;

public class SelectEntityExecutor<T>
extends AbstractExecutor<T> {
    private Class<?> entity;
    private QueryCriteria queryCriteria;
    private CriteriaWrapper criteriaWrapper;
    private QueryProperty queryProperty;
    private boolean isPage = false;
    private List<Object> ids;
    private Class<?> entityClass;
    private Map<String, String> mapping;
    private String indexName;
    private String indexType;
    private Page page;
    private int size = 0;
    private int from = 0;
    private LinkedList<String> aggregationNames;
    private Sort sort;
    private SearchIndexRequest searchIndexRequest;
    private boolean scroll;
    private boolean ignoreTypeName;

    public SelectEntityExecutor(LambdaSupplier<RestHighLevelClientBulider> client, QueryCriteria criteria, Class<?> entity) {
        super(client);
        this.entity = entity;
        this.queryCriteria = criteria;
        this.searchIndexRequest = criteria.queryProperty.getSearchIndexRequest();
    }

    public SelectEntityExecutor(LambdaSupplier<RestHighLevelClientBulider> client, CriteriaWrapper criteriaWrapper, Class<?> entity) {
        super(client);
        this.entity = entity;
        this.criteriaWrapper = criteriaWrapper;
        this.searchIndexRequest = criteriaWrapper.queryProperty.getSearchIndexRequest();
    }

    public SelectEntityExecutor(LambdaSupplier<RestHighLevelClientBulider> client, Class<?> entity) {
        super(client);
        this.entity = entity;
    }

    public SelectEntityExecutor(LambdaSupplier<RestHighLevelClientBulider> client, Class<?> entity, List<Object> ids) {
        super(client);
        this.entity = entity;
        this.ids = ids;
    }

    public SelectEntityExecutor(LambdaSupplier<RestHighLevelClientBulider> client, Class<?> entity, Page page) {
        super(client);
        this.entity = entity;
        this.page = page;
    }

    public SelectEntityExecutor(LambdaSupplier<RestHighLevelClientBulider> client, Class<?> entity, Page page, Sort sort) {
        super(client);
        this.entity = entity;
        this.page = page;
        this.sort = sort;
    }

    public SelectEntityExecutor(LambdaSupplier<RestHighLevelClientBulider> client, Class<?> entity, Sort sort) {
        super(client);
        this.entity = entity;
        this.sort = sort;
    }

    public SelectEntityExecutor(LambdaSupplier<RestHighLevelClientBulider> client, QueryCriteria criteria) {
        super(client);
        this.queryCriteria = criteria;
        this.searchIndexRequest = criteria.queryProperty.getSearchIndexRequest();
    }

    public SelectEntityExecutor(LambdaSupplier<RestHighLevelClientBulider> client, CriteriaWrapper criteriaWrapper) {
        super(client);
        this.criteriaWrapper = criteriaWrapper;
        this.searchIndexRequest = criteriaWrapper.queryProperty.getSearchIndexRequest();
    }

    @Override
    protected T doExecute() throws ElasticsearchException {
        SearchRequest request = new SearchRequest();
        if (this.searchIndexRequest == null) {
            if (this.entity != null) {
                PersistentEntity persistentEntity = DynamicEntity.getPersistentEntityFor(this.entity);
                Asserts.notNull((Object)persistentEntity, "This object is not an initialization class object and has an annotated @Document!");
                this.indexName = persistentEntity.getIndexName();
                this.ignoreTypeName = persistentEntity.isIgnoreTypeName();
                if (Strings.isNotBlank(persistentEntity.getIndexType())) {
                    this.indexType = persistentEntity.getIndexType();
                }
                request.indices(new String[]{this.indexName});
            }
            if (!this.ignoreTypeName && Strings.isNotBlank(this.indexType)) {
                request.types(new String[]{this.indexType});
            }
        }
        this.getSearchRequestMapper(request);
        SearchSourceBuilder builder = new SearchSourceBuilder();
        SearchResponse searchResponse = null;
        if (null != this.queryCriteria || null != this.criteriaWrapper) {
            if (null != this.queryCriteria) {
                builder.query(this.queryCriteria.listBuilders());
                if (null != this.queryCriteria.queryProperty) {
                    this.queryProperty = this.queryCriteria.queryProperty;
                }
            } else if (null != this.criteriaWrapper.queryProperty) {
                builder.query(this.criteriaWrapper.listBuilders());
                if (null != this.criteriaWrapper.queryProperty) {
                    this.queryProperty = this.criteriaWrapper.queryProperty;
                }
            }
            ValuesSourceAggregationBuilder aggregation = null;
            if (this.queryProperty.isRefresh()) {
                RefreshExecutor executor = new RefreshExecutor(this::getClient, this.entity);
                executor.execute();
            }
            this.getQueryOrder(builder);
            if (this.queryProperty.getSort() != null) {
                this.sort = this.queryProperty.getSort();
                this.getOrder(builder);
            }
            if (null != this.queryProperty.getHighlightBuilder()) {
                builder.highlighter(this.queryProperty.getHighlightBuilder());
            }
            this.fetchSource(builder);
            if (this.queryProperty.getEntityClass() != null) {
                this.entityClass = this.queryProperty.getEntityClass();
            }
            if (Collects.isNotEmpty(this.queryProperty.getMapping())) {
                this.mapping = this.queryProperty.getMapping();
            }
            if (Boolean.TRUE.equals(this.queryProperty.isTrackTotalHits())) {
                builder.trackTotalHits(this.queryProperty.isTrackTotalHits());
            }
            Scroll scrolls = null;
            if (this.queryProperty.getPage() != null) {
                this.isPage = true;
                this.page = this.queryProperty.getPage();
                if (this.queryProperty.getTimeValue() != null) {
                    this.scroll = true;
                    scrolls = new Scroll(this.queryProperty.getTimeValue());
                    builder.size(this.page.getPageSize());
                    request.scroll(scrolls);
                    this.getPage(this.page);
                } else {
                    this.getPage(this.page);
                    builder.size(this.size);
                    builder.from(this.from);
                }
            } else if (this.queryProperty.getTimeValue() != null && this.queryProperty.getQueryMaxSize() != 0) {
                this.scroll = true;
                scrolls = new Scroll(this.queryProperty.getTimeValue());
                builder.size(this.queryProperty.getQueryMaxSize());
                request.scroll(scrolls);
                request.allowPartialSearchResults(true);
            }
            if (Collects.isNotEmpty(this.queryProperty.getStatBy()) || this.queryProperty.getAggregateBuilder() != null) {
                Object[] objectArray;
                if (Collects.isNotEmpty(this.queryProperty.getStatBy())) {
                    aggregation = AggregationBuilders.terms((String)"aggs").field(this.queryProperty.getStatBy().toString());
                    builder = builder.aggregation((AggregationBuilder)aggregation);
                }
                if (this.queryProperty.getAggregateBuilder().aggregationBuilder() != null) {
                    Asserts.notNull((Object)this.queryProperty.getAggregateBuilder().aggregationBuilder(), "\nAggregation must not be empty");
                    for (AggregationBuilder aggregationBuilder : this.queryProperty.getAggregateBuilder().listAggBuilders()) {
                        if (this.aggregationNames == null) {
                            this.aggregationNames = new LinkedList();
                        }
                        this.aggregationNames.add(aggregationBuilder.getName());
                        builder.aggregation(aggregationBuilder);
                        builder.fetchSource(true);
                    }
                }
                if (this.queryCriteria != null && this.queryCriteria.listBuilders() != null) {
                    builder.query(this.queryCriteria.listBuilders());
                }
                request.source(builder);
                try {
                    searchResponse = this.client.searchFor(request);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                Aggregations aggregations = searchResponse.getAggregations();
                SearchHits hits = searchResponse.getHits();
                if (this.isPage) {
                    Object[] objectArray2;
                    if (this.queryProperty.getAggregateBuilder().listAggBuilders() != null) {
                        objectArray2 = this.aggregationNames.toArray();
                    } else {
                        String[] stringArray = new String[1];
                        objectArray2 = stringArray;
                        stringArray[0] = aggregation.getName();
                    }
                    return (T)ResultsMapper.aggregateForPage(hits, aggregations, this.entity, this.entityClass, this.page, this.mapping, objectArray2);
                }
                if (this.queryProperty.getAggregateBuilder().listAggBuilders() != null) {
                    objectArray = this.aggregationNames.toArray();
                } else {
                    String[] stringArray = new String[1];
                    objectArray = stringArray;
                    stringArray[0] = aggregation.getName();
                }
                return (T)ResultsMapper.aggregateForObject(aggregations, this.entity, this.entityClass, this.mapping, objectArray);
            }
            builder.timeout(TimeValue.timeValueMinutes((long)this.requestRimeout));
            request.source(builder);
            try {
                searchResponse = this.client.searchFor(request);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            SearchHits hits = searchResponse.getHits();
            if (this.scroll) {
                String scrollId = searchResponse.getScrollId();
                SearchScrollRequest scrollRequest = new SearchScrollRequest(scrollId);
                scrollRequest.scroll(scrolls);
                if (scrollId == null || scrollId.isEmpty()) {
                    return null;
                }
                try {
                    searchResponse = this.client.scrollFor(scrollRequest, RequestOptions.DEFAULT);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                scrollId = searchResponse.getScrollId();
                hits = searchResponse.getHits();
                ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
                clearScrollRequest.addScrollId(scrollId);
                try {
                    this.client.clearScroll(clearScrollRequest, RequestOptions.DEFAULT);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (this.isPage) {
                return (T)ResultsMapper.formatToPageEntity(hits, this.entity, this.entityClass, this.mapping, this.page);
            }
            return (T)ResultsMapper.formatToEntity(hits, this.entity, this.entityClass, this.mapping);
        }
        this.queryCriteria = new QueryCriteria();
        if (Collects.isNotEmpty(this.ids)) {
            QueryCriteria.Criteria criteria = this.queryCriteria.createCriteria();
            criteria.in((List)this.ids);
            builder.query(this.queryCriteria.listBuilders());
        } else {
            if (this.page != null) {
                this.isPage = true;
                this.getPage(this.page);
                builder.size(this.size);
                builder.from(this.from);
            }
            this.getOrder(builder);
            builder.query((QueryBuilder)QueryBuilders.matchAllQuery());
        }
        request.source(builder);
        try {
            searchResponse = this.client.searchFor(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        SearchHits hits = searchResponse.getHits();
        return (T)(!this.isPage ? ResultsMapper.formatToEntity(hits, this.entity, this.entityClass, this.mapping) : ResultsMapper.formatToPageEntity(hits, this.entity, this.entityClass, this.mapping, this.page));
    }

    private void getPage(Page page) {
        if (Strings.isNotBlank(String.valueOf(page.getPageNum())) && page.getPageSize() > 0) {
            this.size = page.getPageSize();
            this.from = (page.getPageNum() - 1) * this.size;
        } else {
            Asserts.isTrue(page.getOffset() >= 0, "Offset must be greater than or equal to 0");
            Asserts.isTrue(page.getLimit() > 0, "Limit must be greater than 0");
            this.size = page.getLimit();
            this.from = page.getOffset();
            this.page.setPageNum((int)Math.ceil((page.getOffset() + page.getLimit()) / page.getLimit()));
            this.page.setPageSize(page.getLimit());
        }
    }

    private SearchSourceBuilder getOrder(SearchSourceBuilder builder) {
        if (this.sort != null) {
            for (Sort.Order order : this.sort.getOrders()) {
                SortOrder sortOrder = SortOrder.valueOf((String)order.getDirection().name());
                builder.sort(order.getProperty(), sortOrder);
            }
        }
        return builder;
    }

    private SearchRequest getSearchRequestMapper(SearchRequest searchRequest) {
        if (this.searchIndexRequest != null) {
            searchRequest.indices(this.searchIndexRequest.getIndexNames());
            if (this.searchIndexRequest.getTypes() != null && this.searchIndexRequest.getTypes().length > 0) {
                searchRequest.types(this.searchIndexRequest.getTypes());
            }
        }
        return searchRequest;
    }

    private SearchSourceBuilder getQueryOrder(SearchSourceBuilder builder) {
        if (this.sort == null) {
            if (null != this.queryProperty.getOrderByAsc()) {
                for (String asc : this.queryProperty.getOrderByAsc()) {
                    builder.sort(asc, SortOrder.ASC);
                }
            }
            if (null != this.queryProperty.getOrderByDesc()) {
                for (String desc : this.queryProperty.getOrderByDesc()) {
                    builder.sort(desc, SortOrder.DESC);
                }
            }
        }
        return builder;
    }

    private SearchSourceBuilder fetchSource(SearchSourceBuilder builder) {
        if (this.queryProperty.getExclude() != null && this.queryProperty.getInclude() != null) {
            builder.fetchSource(this.queryProperty.getInclude(), this.queryProperty.getExclude());
        }
        if (Collects.isNotEmpty(this.queryProperty.getIncludes()) && Collects.isNotEmpty(this.queryProperty.getExcludes())) {
            builder.fetchSource(this.queryProperty.getIncludes(), this.queryProperty.getExcludes());
        }
        return builder;
    }
}

