/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.core.executor;

import com.xphsc.elasticsearch.core.client.RestHighLevelClientBulider;
import com.xphsc.elasticsearch.core.entity.Sort;
import com.xphsc.elasticsearch.core.exception.ElasticsearchException;
import com.xphsc.elasticsearch.core.executor.AbstractExecutor;
import com.xphsc.elasticsearch.core.executor.RefreshExecutor;
import com.xphsc.elasticsearch.core.lambda.LambdaSupplier;
import com.xphsc.elasticsearch.core.query.ResultsMapper;
import com.xphsc.elasticsearch.core.query.SearchQuery;
import com.xphsc.elasticsearch.page.Page;
import com.xphsc.elasticsearch.util.Asserts;
import com.xphsc.elasticsearch.util.Strings;
import java.io.IOException;
import java.util.LinkedList;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;

public class SelectExecutor<T>
extends AbstractExecutor<T> {
    private boolean isPage = false;
    private String indexName;
    private Page page;
    private int size = 0;
    private int from = 0;
    private LinkedList<String> aggregationNames;
    private Sort sort;
    private SearchQuery searchQuery;
    private boolean aggregationType;

    public SelectExecutor(LambdaSupplier<RestHighLevelClientBulider> client, SearchQuery searchQuery) {
        super(client);
        this.searchQuery = searchQuery;
    }

    @Override
    protected T doExecute() throws ElasticsearchException {
        SearchRequest request = new SearchRequest();
        this.getSearchRequestMapper(request);
        SearchSourceBuilder builder = new SearchSourceBuilder();
        SearchResponse searchResponse = null;
        if (null != this.searchQuery) {
            this.sort = this.searchQuery.getSort();
            Object aggregation = null;
            if (this.searchQuery.isRefresh()) {
                if (this.searchQuery.getIndices().length != 0 && this.searchQuery.getIndices().length == 1) {
                    this.indexName = this.searchQuery.getIndices().toString();
                }
                RefreshExecutor executor = new RefreshExecutor(this::getClient, this.indexName);
                executor.execute();
            }
            if (this.searchQuery.getSort() != null) {
                this.sort = this.searchQuery.getSort();
                this.getOrder(builder);
            }
            if (null != this.searchQuery.getHighlightBuilder()) {
                builder.highlighter(this.searchQuery.getHighlightBuilder());
            }
            if (this.searchQuery.getPage() != null) {
                this.isPage = true;
                this.page = this.searchQuery.getPage();
                this.getPage(this.page);
                builder.size(this.size);
                builder.from(this.from);
            }
            if (Boolean.TRUE.equals(this.searchQuery.isTrackTotalHits())) {
                builder.trackTotalHits(this.searchQuery.isTrackTotalHits());
            }
            if (this.searchQuery.getAggregationBuilder() != null) {
                Asserts.notNull((Object)this.searchQuery.getAggregationBuilder(), "\nAggregation must not be empty");
                this.aggregationType = true;
                for (AggregationBuilder aggregationBuilder : this.searchQuery.getAggregationBuilder().getSubAggregations()) {
                    if (this.aggregationNames == null) {
                        this.aggregationNames = new LinkedList();
                    }
                    this.aggregationNames.add(aggregationBuilder.getName());
                    builder.aggregation(aggregationBuilder);
                }
            }
            if (this.searchQuery.getQueryBuilder() != null) {
                builder.query(this.searchQuery.getQueryBuilder());
            } else {
                builder.query(this.searchQuery.listBuilders());
            }
            builder.timeout(TimeValue.timeValueMinutes((long)this.requestRimeout));
            request.source(builder);
            Aggregations aggregations = null;
            if (this.aggregationType) {
                try {
                    searchResponse = this.client.searchFor(request, RequestOptions.DEFAULT);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                aggregations = searchResponse.getAggregations();
            } else {
                try {
                    searchResponse = this.client.searchFor(request, RequestOptions.DEFAULT);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            SearchHits hits = searchResponse.getHits();
            if (this.aggregationType) {
                Object object;
                if (this.isPage) {
                    Object[] objectArray;
                    if (this.searchQuery.getAggregationBuilder() != null) {
                        objectArray = this.aggregationNames.toArray();
                    } else {
                        String[] stringArray = new String[1];
                        objectArray = stringArray;
                        stringArray[0] = aggregation.getName();
                    }
                    object = ResultsMapper.aggregateForPage(hits, aggregations, null, null, this.page, null, objectArray);
                } else {
                    Object[] objectArray;
                    if (this.searchQuery.getAggregationBuilder() != null) {
                        objectArray = this.aggregationNames.toArray();
                    } else {
                        String[] stringArray = new String[1];
                        objectArray = stringArray;
                        stringArray[0] = aggregation.getName();
                    }
                    object = ResultsMapper.aggregateForObject(aggregations, null, null, null, objectArray);
                }
                return (T)object;
            }
            if (this.isPage) {
                return (T)ResultsMapper.formatToPageEntity(hits, null, null, null, this.page);
            }
            return (T)ResultsMapper.formatToEntity(hits, null, null, null);
        }
        return null;
    }

    private void getPage(Page page) {
        if (Strings.isNotBlank(String.valueOf(page.getPageNum())) && page.getPageSize() > 0) {
            this.size = page.getPageSize();
            this.from = (page.getPageNum() - 1) * this.size;
        } else {
            Asserts.isTrue(page.getOffset() >= 0, "Offset must be greater than or equal to 0");
            Asserts.isTrue(page.getLimit() > 0, "Limit must be greater than 0");
            this.size = page.getLimit();
            this.from = page.getOffset();
            this.page.setPageNum((int)Math.ceil((page.getOffset() + page.getLimit()) / page.getLimit()));
            this.page.setPageSize(page.getLimit());
        }
    }

    private SearchSourceBuilder getOrder(SearchSourceBuilder builder) {
        if (this.sort != null) {
            for (Sort.Order order : this.sort.getOrders()) {
                SortOrder sortOrder = SortOrder.valueOf((String)order.getDirection().name());
                builder.sort(order.getProperty(), sortOrder);
            }
        }
        return builder;
    }

    private SearchRequest getSearchRequestMapper(SearchRequest searchRequest) {
        if (this.searchQuery != null) {
            searchRequest.indices(this.searchQuery.getIndices());
            if (this.searchQuery.getTypes() != null && this.searchQuery.getTypes().length > 0) {
                searchRequest.types(this.searchQuery.getTypes());
            }
            if (Strings.isNotBlank(this.searchQuery.getRouting())) {
                searchRequest.routing(this.searchQuery.getRouting());
            }
            if (this.searchQuery.getSearchType() != null) {
                searchRequest.searchType(this.searchQuery.getSearchType());
            }
        }
        return searchRequest;
    }
}

