/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.core.executor;

import com.xphsc.elasticsearch.core.client.RestHighLevelClientBulider;
import com.xphsc.elasticsearch.core.exception.ElasticsearchException;
import com.xphsc.elasticsearch.core.executor.AbstractExecutor;
import com.xphsc.elasticsearch.core.lambda.LambdaSupplier;
import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;

public class SettingsExecutor
extends AbstractExecutor<Object> {
    private String indexName;
    private Object settings;

    public SettingsExecutor(LambdaSupplier<RestHighLevelClientBulider> client, String indexName, Object settings) {
        super(client);
        this.indexName = indexName;
        this.settings = settings;
    }

    @Override
    protected Object doExecute() throws ElasticsearchException {
        AcknowledgedResponse response = null;
        UpdateSettingsRequest settingsRequest = new UpdateSettingsRequest();
        settingsRequest.indices(new String[]{this.indexName});
        if (this.settings instanceof String) {
            settingsRequest.settings(String.valueOf(this.settings), XContentType.JSON);
        } else if (this.settings instanceof Map) {
            settingsRequest.settings((Map)this.settings);
        } else if (this.settings instanceof XContentBuilder) {
            settingsRequest.settings((Settings)this.settings);
        }
        try {
            response = this.client.putSettingsFor(settingsRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return response.isAcknowledged();
    }
}

